package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class PracticedInterventionAbstract extends AbstractTopiaEntity implements PracticedIntervention {

    /**
     * Nom de l'attribut en BD : rank
     */
    protected int rank;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : startingPeriodDate
     */
    protected String startingPeriodDate;

    /**
     * Nom de l'attribut en BD : endingPeriodDate
     */
    protected String endingPeriodDate;

    /**
     * Nom de l'attribut en BD : intermediateCrop
     */
    protected boolean intermediateCrop;

    /**
     * Nom de l'attribut en BD : tillageDepth
     */
    protected Integer tillageDepth;

    /**
     * Nom de l'attribut en BD : otherToolSettings
     */
    protected String otherToolSettings;

    /**
     * Nom de l'attribut en BD : workRate
     */
    protected Double workRate;

    /**
     * Nom de l'attribut en BD : progressionSpeed
     */
    protected Integer progressionSpeed;

    /**
     * Nom de l'attribut en BD : involvedPeopleNumber
     */
    protected Double involvedPeopleNumber;

    /**
     * Nom de l'attribut en BD : toolsCouplingCodes
     */
    protected Collection<String> toolsCouplingCodes;

    /**
     * Nom de l'attribut en BD : spatialFrequency
     */
    protected double spatialFrequency;

    /**
     * Nom de l'attribut en BD : temporalFrequency
     */
    protected double temporalFrequency;

    /**
     * Nom de l'attribut en BD : transitVolume
     */
    protected Double transitVolume;

    /**
     * Nom de l'attribut en BD : nbBalls
     */
    protected Integer nbBalls;

    /**
     * Nom de l'attribut en BD : speciesStades
     */
    protected Collection<PracticedSpeciesStade> speciesStades;

    /**
     * Nom de l'attribut en BD : practicedCropCyclePhase
     */
    protected PracticedCropCyclePhase practicedCropCyclePhase;

    /**
     * Nom de l'attribut en BD : practicedCropCycleConnection
     */
    protected PracticedCropCycleConnection practicedCropCycleConnection;

    /**
     * Nom de l'attribut en BD : type
     */
    protected AgrosystInterventionType type;

    /**
     * Nom de l'attribut en BD : workRateUnit
     */
    protected MaterielWorkRateUnit workRateUnit;

    /**
     * Nom de l'attribut en BD : transitVolumeUnit
     */
    protected MaterielTransportUnit transitVolumeUnit;

    private static final long serialVersionUID = 3774922919938241592L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_RANK, int.class, rank);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_STARTING_PERIOD_DATE, String.class, startingPeriodDate);
        visitor.visit(this, PROPERTY_ENDING_PERIOD_DATE, String.class, endingPeriodDate);
        visitor.visit(this, PROPERTY_INTERMEDIATE_CROP, boolean.class, intermediateCrop);
        visitor.visit(this, PROPERTY_TILLAGE_DEPTH, Integer.class, tillageDepth);
        visitor.visit(this, PROPERTY_OTHER_TOOL_SETTINGS, String.class, otherToolSettings);
        visitor.visit(this, PROPERTY_WORK_RATE, Double.class, workRate);
        visitor.visit(this, PROPERTY_PROGRESSION_SPEED, Integer.class, progressionSpeed);
        visitor.visit(this, PROPERTY_INVOLVED_PEOPLE_NUMBER, Double.class, involvedPeopleNumber);
        visitor.visit(this, PROPERTY_TOOLS_COUPLING_CODES, Collection.class, String.class, toolsCouplingCodes);
        visitor.visit(this, PROPERTY_SPATIAL_FREQUENCY, double.class, spatialFrequency);
        visitor.visit(this, PROPERTY_TEMPORAL_FREQUENCY, double.class, temporalFrequency);
        visitor.visit(this, PROPERTY_TRANSIT_VOLUME, Double.class, transitVolume);
        visitor.visit(this, PROPERTY_NB_BALLS, Integer.class, nbBalls);
        visitor.visit(this, PROPERTY_SPECIES_STADES, Collection.class, PracticedSpeciesStade.class, speciesStades);
        visitor.visit(this, PROPERTY_PRACTICED_CROP_CYCLE_PHASE, PracticedCropCyclePhase.class, practicedCropCyclePhase);
        visitor.visit(this, PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, PracticedCropCycleConnection.class, practicedCropCycleConnection);
        visitor.visit(this, PROPERTY_TYPE, AgrosystInterventionType.class, type);
        visitor.visit(this, PROPERTY_WORK_RATE_UNIT, MaterielWorkRateUnit.class, workRateUnit);
        visitor.visit(this, PROPERTY_TRANSIT_VOLUME_UNIT, MaterielTransportUnit.class, transitVolumeUnit);
    }

    @Override
    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public int getRank() {
        int result = this.rank;
        return result;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setStartingPeriodDate(String startingPeriodDate) {
        this.startingPeriodDate = startingPeriodDate;
    }

    @Override
    public String getStartingPeriodDate() {
        String result = this.startingPeriodDate;
        return result;
    }

    @Override
    public void setEndingPeriodDate(String endingPeriodDate) {
        this.endingPeriodDate = endingPeriodDate;
    }

    @Override
    public String getEndingPeriodDate() {
        String result = this.endingPeriodDate;
        return result;
    }

    @Override
    public void setIntermediateCrop(boolean intermediateCrop) {
        this.intermediateCrop = intermediateCrop;
    }

    @Override
    public boolean isIntermediateCrop() {
        boolean result = this.intermediateCrop;
        return result;
    }

    @Override
    public void setTillageDepth(Integer tillageDepth) {
        this.tillageDepth = tillageDepth;
    }

    @Override
    public Integer getTillageDepth() {
        Integer result = this.tillageDepth;
        return result;
    }

    @Override
    public void setOtherToolSettings(String otherToolSettings) {
        this.otherToolSettings = otherToolSettings;
    }

    @Override
    public String getOtherToolSettings() {
        String result = this.otherToolSettings;
        return result;
    }

    @Override
    public void setWorkRate(Double workRate) {
        this.workRate = workRate;
    }

    @Override
    public Double getWorkRate() {
        Double result = this.workRate;
        return result;
    }

    @Override
    public void setProgressionSpeed(Integer progressionSpeed) {
        this.progressionSpeed = progressionSpeed;
    }

    @Override
    public Integer getProgressionSpeed() {
        Integer result = this.progressionSpeed;
        return result;
    }

    @Override
    public void setInvolvedPeopleNumber(Double involvedPeopleNumber) {
        this.involvedPeopleNumber = involvedPeopleNumber;
    }

    @Override
    public Double getInvolvedPeopleNumber() {
        Double result = this.involvedPeopleNumber;
        return result;
    }

    @Override
    public void addToolsCouplingCodes(String toolsCouplingCodes) {
        if (this.toolsCouplingCodes == null) {
            this.toolsCouplingCodes = new LinkedList<String>();
        }
        this.toolsCouplingCodes.add(toolsCouplingCodes);
    }

    @Override
    public void addAllToolsCouplingCodes(Iterable<String> toolsCouplingCodes) {
        if (toolsCouplingCodes == null) {
            return;
        }
        for (String item : toolsCouplingCodes) {
            addToolsCouplingCodes(item);
        }
    }

    @Override
    public void setToolsCouplingCodes(Collection<String> toolsCouplingCodes) {
        this.toolsCouplingCodes = toolsCouplingCodes;
    }

    @Override
    public void removeToolsCouplingCodes(String toolsCouplingCodes) {
        if (this.toolsCouplingCodes == null || !this.toolsCouplingCodes.remove(toolsCouplingCodes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearToolsCouplingCodes() {
        if (this.toolsCouplingCodes == null) {
            return;
        }
        this.toolsCouplingCodes.clear();
    }

    @Override
    public Collection<String> getToolsCouplingCodes() {
        return toolsCouplingCodes;
    }

    @Override
    public int sizeToolsCouplingCodes() {
        if (toolsCouplingCodes == null) {
            return 0;
        }
        return toolsCouplingCodes.size();
    }

    @Override
    public boolean isToolsCouplingCodesEmpty() {
        int size = sizeToolsCouplingCodes();
        return size == 0;
    }

    @Override
    public boolean isToolsCouplingCodesNotEmpty() {
        boolean empty = isToolsCouplingCodesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsToolsCouplingCodes(String toolsCouplingCodes) {
        boolean contains = this.toolsCouplingCodes !=null && this.toolsCouplingCodes.contains(toolsCouplingCodes);
        return contains;
    }

    @Override
    public void setSpatialFrequency(double spatialFrequency) {
        this.spatialFrequency = spatialFrequency;
    }

    @Override
    public double getSpatialFrequency() {
        double result = this.spatialFrequency;
        return result;
    }

    @Override
    public void setTemporalFrequency(double temporalFrequency) {
        this.temporalFrequency = temporalFrequency;
    }

    @Override
    public double getTemporalFrequency() {
        double result = this.temporalFrequency;
        return result;
    }

    @Override
    public void setTransitVolume(Double transitVolume) {
        this.transitVolume = transitVolume;
    }

    @Override
    public Double getTransitVolume() {
        Double result = this.transitVolume;
        return result;
    }

    @Override
    public void setNbBalls(Integer nbBalls) {
        this.nbBalls = nbBalls;
    }

    @Override
    public Integer getNbBalls() {
        Integer result = this.nbBalls;
        return result;
    }

    @Override
    public void addSpeciesStades(PracticedSpeciesStade speciesStades) {
        if (this.speciesStades == null) {
            this.speciesStades = new LinkedList<PracticedSpeciesStade>();
        }
        this.speciesStades.add(speciesStades);
    }

    @Override
    public void addAllSpeciesStades(Iterable<PracticedSpeciesStade> speciesStades) {
        if (speciesStades == null) {
            return;
        }
        for (PracticedSpeciesStade item : speciesStades) {
            addSpeciesStades(item);
        }
    }

    @Override
    public void setSpeciesStades(Collection<PracticedSpeciesStade> speciesStades) {
        this.speciesStades = speciesStades;
    }

    @Override
    public void removeSpeciesStades(PracticedSpeciesStade speciesStades) {
        if (this.speciesStades == null || !this.speciesStades.remove(speciesStades)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSpeciesStades() {
        if (this.speciesStades == null) {
            return;
        }
        this.speciesStades.clear();
    }

    @Override
    public Collection<PracticedSpeciesStade> getSpeciesStades() {
        return speciesStades;
    }

    @Override
    public PracticedSpeciesStade getSpeciesStadesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(speciesStades, topiaId);
    }

    @Override
    public Collection<String> getSpeciesStadesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade> tmp = getSpeciesStades();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSpeciesStades() {
        if (speciesStades == null) {
            return 0;
        }
        return speciesStades.size();
    }

    @Override
    public boolean isSpeciesStadesEmpty() {
        int size = sizeSpeciesStades();
        return size == 0;
    }

    @Override
    public boolean isSpeciesStadesNotEmpty() {
        boolean empty = isSpeciesStadesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSpeciesStades(PracticedSpeciesStade speciesStades) {
        boolean contains = this.speciesStades !=null && this.speciesStades.contains(speciesStades);
        return contains;
    }

    @Override
    public void setPracticedCropCyclePhase(PracticedCropCyclePhase practicedCropCyclePhase) {
        this.practicedCropCyclePhase = practicedCropCyclePhase;
    }

    @Override
    public PracticedCropCyclePhase getPracticedCropCyclePhase() {
        PracticedCropCyclePhase result = this.practicedCropCyclePhase;
        return result;
    }

    @Override
    public void setPracticedCropCycleConnection(PracticedCropCycleConnection practicedCropCycleConnection) {
        this.practicedCropCycleConnection = practicedCropCycleConnection;
    }

    @Override
    public PracticedCropCycleConnection getPracticedCropCycleConnection() {
        PracticedCropCycleConnection result = this.practicedCropCycleConnection;
        return result;
    }

    @Override
    public void setType(AgrosystInterventionType type) {
        this.type = type;
    }

    @Override
    public AgrosystInterventionType getType() {
        AgrosystInterventionType result = this.type;
        return result;
    }

    @Override
    public void setWorkRateUnit(MaterielWorkRateUnit workRateUnit) {
        this.workRateUnit = workRateUnit;
    }

    @Override
    public MaterielWorkRateUnit getWorkRateUnit() {
        MaterielWorkRateUnit result = this.workRateUnit;
        return result;
    }

    @Override
    public void setTransitVolumeUnit(MaterielTransportUnit transitVolumeUnit) {
        this.transitVolumeUnit = transitVolumeUnit;
    }

    @Override
    public MaterielTransportUnit getTransitVolumeUnit() {
        MaterielTransportUnit result = this.transitVolumeUnit;
        return result;
    }

} //PracticedInterventionAbstract
