package fr.inra.agrosyst.api.entities.performance;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:19 CET 2015")
public abstract class PerformanceAbstract extends AbstractTopiaEntity implements Performance {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : practiced
     */
    protected boolean practiced;

    /**
     * Nom de l'attribut en BD : updateDate
     */
    protected Date updateDate;

    /**
     * Nom de l'attribut en BD : domains
     */
    protected Collection<Domain> domains;

    /**
     * Nom de l'attribut en BD : plots
     */
    protected Collection<Plot> plots;

    /**
     * Nom de l'attribut en BD : zones
     */
    protected Collection<Zone> zones;

    /**
     * Nom de l'attribut en BD : author
     */
    protected AgrosystUser author;

    /**
     * Nom de l'attribut en BD : computeStatus
     */
    protected PerformanceState computeStatus;

    /**
     * Nom de l'attribut en BD : growingSystems
     */
    protected Collection<GrowingSystem> growingSystems;

    private static final long serialVersionUID = 3689918383223354978L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_PRACTICED, boolean.class, practiced);
        visitor.visit(this, PROPERTY_UPDATE_DATE, Date.class, updateDate);
        visitor.visit(this, PROPERTY_DOMAINS, Collection.class, Domain.class, domains);
        visitor.visit(this, PROPERTY_PLOTS, Collection.class, Plot.class, plots);
        visitor.visit(this, PROPERTY_ZONES, Collection.class, Zone.class, zones);
        visitor.visit(this, PROPERTY_AUTHOR, AgrosystUser.class, author);
        visitor.visit(this, PROPERTY_COMPUTE_STATUS, PerformanceState.class, computeStatus);
        visitor.visit(this, PROPERTY_GROWING_SYSTEMS, Collection.class, GrowingSystem.class, growingSystems);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    @Override
    public boolean isPracticed() {
        boolean result = this.practiced;
        return result;
    }

    @Override
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public Date getUpdateDate() {
        Date result = this.updateDate;
        return result;
    }

    @Override
    public void addDomains(Domain domains) {
        if (this.domains == null) {
            this.domains = new LinkedList<Domain>();
        }
        this.domains.add(domains);
    }

    @Override
    public void addAllDomains(Iterable<Domain> domains) {
        if (domains == null) {
            return;
        }
        for (Domain item : domains) {
            addDomains(item);
        }
    }

    @Override
    public void setDomains(Collection<Domain> domains) {
        this.domains = domains;
    }

    @Override
    public void removeDomains(Domain domains) {
        if (this.domains == null || !this.domains.remove(domains)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearDomains() {
        if (this.domains == null) {
            return;
        }
        this.domains.clear();
    }

    @Override
    public Collection<Domain> getDomains() {
        return domains;
    }

    @Override
    public Domain getDomainsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(domains, topiaId);
    }

    @Override
    public Collection<String> getDomainsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Domain> tmp = getDomains();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeDomains() {
        if (domains == null) {
            return 0;
        }
        return domains.size();
    }

    @Override
    public boolean isDomainsEmpty() {
        int size = sizeDomains();
        return size == 0;
    }

    @Override
    public boolean isDomainsNotEmpty() {
        boolean empty = isDomainsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsDomains(Domain domains) {
        boolean contains = this.domains !=null && this.domains.contains(domains);
        return contains;
    }

    @Override
    public void addPlots(Plot plots) {
        if (this.plots == null) {
            this.plots = new LinkedList<Plot>();
        }
        this.plots.add(plots);
    }

    @Override
    public void addAllPlots(Iterable<Plot> plots) {
        if (plots == null) {
            return;
        }
        for (Plot item : plots) {
            addPlots(item);
        }
    }

    @Override
    public void setPlots(Collection<Plot> plots) {
        this.plots = plots;
    }

    @Override
    public void removePlots(Plot plots) {
        if (this.plots == null || !this.plots.remove(plots)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearPlots() {
        if (this.plots == null) {
            return;
        }
        this.plots.clear();
    }

    @Override
    public Collection<Plot> getPlots() {
        return plots;
    }

    @Override
    public Plot getPlotsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(plots, topiaId);
    }

    @Override
    public Collection<String> getPlotsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Plot> tmp = getPlots();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizePlots() {
        if (plots == null) {
            return 0;
        }
        return plots.size();
    }

    @Override
    public boolean isPlotsEmpty() {
        int size = sizePlots();
        return size == 0;
    }

    @Override
    public boolean isPlotsNotEmpty() {
        boolean empty = isPlotsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPlots(Plot plots) {
        boolean contains = this.plots !=null && this.plots.contains(plots);
        return contains;
    }

    @Override
    public void addZones(Zone zones) {
        if (this.zones == null) {
            this.zones = new LinkedList<Zone>();
        }
        this.zones.add(zones);
    }

    @Override
    public void addAllZones(Iterable<Zone> zones) {
        if (zones == null) {
            return;
        }
        for (Zone item : zones) {
            addZones(item);
        }
    }

    @Override
    public void setZones(Collection<Zone> zones) {
        this.zones = zones;
    }

    @Override
    public void removeZones(Zone zones) {
        if (this.zones == null || !this.zones.remove(zones)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearZones() {
        if (this.zones == null) {
            return;
        }
        this.zones.clear();
    }

    @Override
    public Collection<Zone> getZones() {
        return zones;
    }

    @Override
    public Zone getZonesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(zones, topiaId);
    }

    @Override
    public Collection<String> getZonesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Zone> tmp = getZones();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeZones() {
        if (zones == null) {
            return 0;
        }
        return zones.size();
    }

    @Override
    public boolean isZonesEmpty() {
        int size = sizeZones();
        return size == 0;
    }

    @Override
    public boolean isZonesNotEmpty() {
        boolean empty = isZonesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsZones(Zone zones) {
        boolean contains = this.zones !=null && this.zones.contains(zones);
        return contains;
    }

    @Override
    public void setAuthor(AgrosystUser author) {
        this.author = author;
    }

    @Override
    public AgrosystUser getAuthor() {
        AgrosystUser result = this.author;
        return result;
    }

    @Override
    public void setComputeStatus(PerformanceState computeStatus) {
        this.computeStatus = computeStatus;
    }

    @Override
    public PerformanceState getComputeStatus() {
        PerformanceState result = this.computeStatus;
        return result;
    }

    @Override
    public void addGrowingSystems(GrowingSystem growingSystems) {
        if (this.growingSystems == null) {
            this.growingSystems = new LinkedList<GrowingSystem>();
        }
        this.growingSystems.add(growingSystems);
    }

    @Override
    public void addAllGrowingSystems(Iterable<GrowingSystem> growingSystems) {
        if (growingSystems == null) {
            return;
        }
        for (GrowingSystem item : growingSystems) {
            addGrowingSystems(item);
        }
    }

    @Override
    public void setGrowingSystems(Collection<GrowingSystem> growingSystems) {
        this.growingSystems = growingSystems;
    }

    @Override
    public void removeGrowingSystems(GrowingSystem growingSystems) {
        if (this.growingSystems == null || !this.growingSystems.remove(growingSystems)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearGrowingSystems() {
        if (this.growingSystems == null) {
            return;
        }
        this.growingSystems.clear();
    }

    @Override
    public Collection<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

    @Override
    public GrowingSystem getGrowingSystemsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(growingSystems, topiaId);
    }

    @Override
    public Collection<String> getGrowingSystemsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.GrowingSystem> tmp = getGrowingSystems();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeGrowingSystems() {
        if (growingSystems == null) {
            return 0;
        }
        return growingSystems.size();
    }

    @Override
    public boolean isGrowingSystemsEmpty() {
        int size = sizeGrowingSystems();
        return size == 0;
    }

    @Override
    public boolean isGrowingSystemsNotEmpty() {
        boolean empty = isGrowingSystemsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsGrowingSystems(GrowingSystem growingSystems) {
        boolean contains = this.growingSystems !=null && this.growingSystems.contains(growingSystems);
        return contains;
    }

} //PerformanceAbstract
