package fr.inra.agrosyst.api.entities.performance;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:19 CET 2015")
public interface Performance extends TopiaEntity {

    String PROPERTY_NAME = "name";

    String PROPERTY_PRACTICED = "practiced";

    String PROPERTY_UPDATE_DATE = "updateDate";

    String PROPERTY_DOMAINS = "domains";

    String PROPERTY_PLOTS = "plots";

    String PROPERTY_ZONES = "zones";

    String PROPERTY_AUTHOR = "author";

    String PROPERTY_COMPUTE_STATUS = "computeStatus";

    String PROPERTY_GROWING_SYSTEMS = "growingSystems";

    void setName(String name);

    String getName();

    void setPracticed(boolean practiced);

    boolean isPracticed();

    void setUpdateDate(Date updateDate);

    Date getUpdateDate();

    void addDomains(Domain domains);

    void addAllDomains(Iterable<Domain> domains);

    void setDomains(Collection<Domain> domains);

    void removeDomains(Domain domains);

    void clearDomains();

    Collection<Domain> getDomains();

    Domain getDomainsByTopiaId(String topiaId);

    Collection<String> getDomainsTopiaIds();

    int sizeDomains();

    boolean isDomainsEmpty();

    boolean isDomainsNotEmpty();

    boolean containsDomains(Domain domains);

    void addPlots(Plot plots);

    void addAllPlots(Iterable<Plot> plots);

    void setPlots(Collection<Plot> plots);

    void removePlots(Plot plots);

    void clearPlots();

    Collection<Plot> getPlots();

    Plot getPlotsByTopiaId(String topiaId);

    Collection<String> getPlotsTopiaIds();

    int sizePlots();

    boolean isPlotsEmpty();

    boolean isPlotsNotEmpty();

    boolean containsPlots(Plot plots);

    void addZones(Zone zones);

    void addAllZones(Iterable<Zone> zones);

    void setZones(Collection<Zone> zones);

    void removeZones(Zone zones);

    void clearZones();

    Collection<Zone> getZones();

    Zone getZonesByTopiaId(String topiaId);

    Collection<String> getZonesTopiaIds();

    int sizeZones();

    boolean isZonesEmpty();

    boolean isZonesNotEmpty();

    boolean containsZones(Zone zones);

    void setAuthor(AgrosystUser author);

    AgrosystUser getAuthor();

    void setComputeStatus(PerformanceState computeStatus);

    PerformanceState getComputeStatus();

    void addGrowingSystems(GrowingSystem growingSystems);

    void addAllGrowingSystems(Iterable<GrowingSystem> growingSystems);

    void setGrowingSystems(Collection<GrowingSystem> growingSystems);

    void removeGrowingSystems(GrowingSystem growingSystems);

    void clearGrowingSystems();

    Collection<GrowingSystem> getGrowingSystems();

    GrowingSystem getGrowingSystemsByTopiaId(String topiaId);

    Collection<String> getGrowingSystemsTopiaIds();

    int sizeGrowingSystems();

    boolean isGrowingSystemsEmpty();

    boolean isGrowingSystemsNotEmpty();

    boolean containsGrowingSystems(GrowingSystem growingSystems);

} //Performance
