package fr.inra.agrosyst.api.entities.measure;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Zone;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class MeasurementSessionAbstract extends AbstractTopiaEntity implements MeasurementSession {

    /**
     * Nom de l'attribut en BD : startDate
     */
    protected Date startDate;

    /**
     * Nom de l'attribut en BD : endDate
     */
    protected Date endDate;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : minStage
     */
    protected String minStage;

    /**
     * Nom de l'attribut en BD : maxStage
     */
    protected String maxStage;

    /**
     * Nom de l'attribut en BD : measurements
     */
    protected Collection<Measurement> measurements;

    /**
     * Nom de l'attribut en BD : zone
     */
    protected Zone zone;

    /**
     * Nom de l'attribut en BD : croppingPlanEntry
     */
    protected CroppingPlanEntry croppingPlanEntry;

    private static final long serialVersionUID = 3558183876481528888L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_START_DATE, Date.class, startDate);
        visitor.visit(this, PROPERTY_END_DATE, Date.class, endDate);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_MIN_STAGE, String.class, minStage);
        visitor.visit(this, PROPERTY_MAX_STAGE, String.class, maxStage);
        visitor.visit(this, PROPERTY_MEASUREMENTS, Collection.class, Measurement.class, measurements);
        visitor.visit(this, PROPERTY_ZONE, Zone.class, zone);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_ENTRY, CroppingPlanEntry.class, croppingPlanEntry);
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getStartDate() {
        Date result = this.startDate;
        return result;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Date getEndDate() {
        Date result = this.endDate;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setMinStage(String minStage) {
        this.minStage = minStage;
    }

    @Override
    public String getMinStage() {
        String result = this.minStage;
        return result;
    }

    @Override
    public void setMaxStage(String maxStage) {
        this.maxStage = maxStage;
    }

    @Override
    public String getMaxStage() {
        String result = this.maxStage;
        return result;
    }

    @Override
    public void addMeasurements(Measurement measurements) {
        if (this.measurements == null) {
            this.measurements = new LinkedList<Measurement>();
        }
        measurements.setMeasurementSession(this);
        this.measurements.add(measurements);
    }

    @Override
    public void addAllMeasurements(Iterable<Measurement> measurements) {
        if (measurements == null) {
            return;
        }
        for (Measurement item : measurements) {
            addMeasurements(item);
        }
    }

    @Override
    public void setMeasurements(Collection<Measurement> measurements) {
        this.measurements = measurements;
    }

    @Override
    public void removeMeasurements(Measurement measurements) {
        if (this.measurements == null || !this.measurements.remove(measurements)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        measurements.setMeasurementSession(null);
    }

    @Override
    public void clearMeasurements() {
        if (this.measurements == null) {
            return;
        }
        for (Measurement item : this.measurements) {
            item.setMeasurementSession(null);
        }
        this.measurements.clear();
    }

    @Override
    public Collection<Measurement> getMeasurements() {
        return measurements;
    }

    @Override
    public Measurement getMeasurementsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(measurements, topiaId);
    }

    @Override
    public Collection<String> getMeasurementsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.measure.Measurement> tmp = getMeasurements();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMeasurements() {
        if (measurements == null) {
            return 0;
        }
        return measurements.size();
    }

    @Override
    public boolean isMeasurementsEmpty() {
        int size = sizeMeasurements();
        return size == 0;
    }

    @Override
    public boolean isMeasurementsNotEmpty() {
        boolean empty = isMeasurementsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMeasurements(Measurement measurements) {
        boolean contains = this.measurements !=null && this.measurements.contains(measurements);
        return contains;
    }

    @Override
    public void setZone(Zone zone) {
        this.zone = zone;
    }

    @Override
    public Zone getZone() {
        Zone result = this.zone;
        return result;
    }

    @Override
    public void setCroppingPlanEntry(CroppingPlanEntry croppingPlanEntry) {
        this.croppingPlanEntry = croppingPlanEntry;
    }

    @Override
    public CroppingPlanEntry getCroppingPlanEntry() {
        CroppingPlanEntry result = this.croppingPlanEntry;
        return result;
    }

} //MeasurementSessionAbstract
