package fr.inra.agrosyst.api.entities.managementmode;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class StrategyAbstract extends AbstractTopiaEntity implements Strategy {

    /**
     * Nom de l'attribut en BD : explanation
     */
    protected String explanation;

    /**
     * Nom de l'attribut en BD : croppingPlanManagmentName
     */
    protected String croppingPlanManagmentName;

    /**
     * Nom de l'attribut en BD : multiannual
     */
    protected boolean multiannual;

    /**
     * Nom de l'attribut en BD : croppingPlanEntry
     */
    protected CroppingPlanEntry croppingPlanEntry;

    /**
     * Nom de l'attribut en BD : rules
     */
    protected Collection<DecisionRule> rules;

    /**
     * Nom de l'attribut en BD : strategyType
     */
    protected StrategyType strategyType;

    private static final long serialVersionUID = 3762817297718786101L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_EXPLANATION, String.class, explanation);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_MANAGMENT_NAME, String.class, croppingPlanManagmentName);
        visitor.visit(this, PROPERTY_MULTIANNUAL, boolean.class, multiannual);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_ENTRY, CroppingPlanEntry.class, croppingPlanEntry);
        visitor.visit(this, PROPERTY_RULES, Collection.class, DecisionRule.class, rules);
        visitor.visit(this, PROPERTY_STRATEGY_TYPE, StrategyType.class, strategyType);
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @Override
    public String getExplanation() {
        String result = this.explanation;
        return result;
    }

    @Override
    public void setCroppingPlanManagmentName(String croppingPlanManagmentName) {
        this.croppingPlanManagmentName = croppingPlanManagmentName;
    }

    @Override
    public String getCroppingPlanManagmentName() {
        String result = this.croppingPlanManagmentName;
        return result;
    }

    @Override
    public void setMultiannual(boolean multiannual) {
        this.multiannual = multiannual;
    }

    @Override
    public boolean isMultiannual() {
        boolean result = this.multiannual;
        return result;
    }

    @Override
    public void setCroppingPlanEntry(CroppingPlanEntry croppingPlanEntry) {
        this.croppingPlanEntry = croppingPlanEntry;
    }

    @Override
    public CroppingPlanEntry getCroppingPlanEntry() {
        CroppingPlanEntry result = this.croppingPlanEntry;
        return result;
    }

    @Override
    public void addRules(DecisionRule rules) {
        if (this.rules == null) {
            this.rules = new LinkedList<DecisionRule>();
        }
        this.rules.add(rules);
    }

    @Override
    public void addAllRules(Iterable<DecisionRule> rules) {
        if (rules == null) {
            return;
        }
        for (DecisionRule item : rules) {
            addRules(item);
        }
    }

    @Override
    public void setRules(Collection<DecisionRule> rules) {
        this.rules = rules;
    }

    @Override
    public void removeRules(DecisionRule rules) {
        if (this.rules == null || !this.rules.remove(rules)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRules() {
        if (this.rules == null) {
            return;
        }
        this.rules.clear();
    }

    @Override
    public Collection<DecisionRule> getRules() {
        return rules;
    }

    @Override
    public DecisionRule getRulesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(rules, topiaId);
    }

    @Override
    public Collection<String> getRulesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.managementmode.DecisionRule> tmp = getRules();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRules() {
        if (rules == null) {
            return 0;
        }
        return rules.size();
    }

    @Override
    public boolean isRulesEmpty() {
        int size = sizeRules();
        return size == 0;
    }

    @Override
    public boolean isRulesNotEmpty() {
        boolean empty = isRulesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRules(DecisionRule rules) {
        boolean contains = this.rules !=null && this.rules.contains(rules);
        return contains;
    }

    @Override
    public void setStrategyType(StrategyType strategyType) {
        this.strategyType = strategyType;
    }

    @Override
    public StrategyType getStrategyType() {
        StrategyType result = this.strategyType;
        return result;
    }

} //StrategyAbstract
