package fr.inra.agrosyst.api.entities.managementmode;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class SectionAbstract extends AbstractTopiaEntity implements Section {

    /**
     * Nom de l'attribut en BD : agronomicObjective
     */
    protected String agronomicObjective;

    /**
     * Nom de l'attribut en BD : expectedResult
     */
    protected String expectedResult;

    /**
     * Nom de l'attribut en BD : sectionType
     */
    protected SectionType sectionType;

    /**
     * Nom de l'attribut en BD : strategies
     */
    protected List<Strategy> strategies;

    /**
     * Nom de l'attribut en BD : bioAgressor
     */
    protected RefBioAgressor bioAgressor;

    /**
     * Nom de l'attribut en BD : categoryObjective
     */
    protected CategoryObjective categoryObjective;

    /**
     * Nom de l'attribut en BD : categoryStrategy
     */
    protected CategoryStrategy categoryStrategy;

    /**
     * Nom de l'attribut en BD : bioAgressorType
     */
    protected BioAgressorType bioAgressorType;

    private static final long serialVersionUID = 7377232860046255717L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_AGRONOMIC_OBJECTIVE, String.class, agronomicObjective);
        visitor.visit(this, PROPERTY_EXPECTED_RESULT, String.class, expectedResult);
        visitor.visit(this, PROPERTY_SECTION_TYPE, SectionType.class, sectionType);
        visitor.visit(this, PROPERTY_STRATEGIES, List.class, Strategy.class, strategies);
        visitor.visit(this, PROPERTY_BIO_AGRESSOR, RefBioAgressor.class, bioAgressor);
        visitor.visit(this, PROPERTY_CATEGORY_OBJECTIVE, CategoryObjective.class, categoryObjective);
        visitor.visit(this, PROPERTY_CATEGORY_STRATEGY, CategoryStrategy.class, categoryStrategy);
        visitor.visit(this, PROPERTY_BIO_AGRESSOR_TYPE, BioAgressorType.class, bioAgressorType);
    }

    @Override
    public void setAgronomicObjective(String agronomicObjective) {
        this.agronomicObjective = agronomicObjective;
    }

    @Override
    public String getAgronomicObjective() {
        String result = this.agronomicObjective;
        return result;
    }

    @Override
    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    public String getExpectedResult() {
        String result = this.expectedResult;
        return result;
    }

    @Override
    public void setSectionType(SectionType sectionType) {
        this.sectionType = sectionType;
    }

    @Override
    public SectionType getSectionType() {
        SectionType result = this.sectionType;
        return result;
    }

    @Override
    public void addStrategies(Strategy strategies) {
        if (this.strategies == null) {
            this.strategies = new LinkedList<Strategy>();
        }
        this.strategies.add(strategies);
    }

    @Override
    public void addStrategies(int index, Strategy strategies) {
        if (this.strategies == null) {
            this.strategies = new LinkedList<Strategy>();
        }
        this.strategies.add(index, strategies);
    }

    @Override
    public void addAllStrategies(Iterable<Strategy> strategies) {
        if (strategies == null) {
            return;
        }
        for (Strategy item : strategies) {
            addStrategies(item);
        }
    }

    @Override
    public void setStrategies(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public void removeStrategies(Strategy strategies) {
        if (this.strategies == null || !this.strategies.remove(strategies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void removeStrategies(int index) {
        if (this.strategies == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        Strategy oldValue = this.strategies.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearStrategies() {
        if (this.strategies == null) {
            return;
        }
        this.strategies.clear();
    }

    @Override
    public List<Strategy> getStrategies() {
        return strategies;
    }

    @Override
    public Strategy getStrategies(int index) {
        return TopiaEntityHelper.getEntityByIndex(strategies, index);
    }

    @Override
    public Strategy getStrategiesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(strategies, topiaId);
    }

    @Override
    public List<String> getStrategiesTopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<fr.inra.agrosyst.api.entities.managementmode.Strategy> tmp = getStrategies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeStrategies() {
        if (strategies == null) {
            return 0;
        }
        return strategies.size();
    }

    @Override
    public boolean isStrategiesEmpty() {
        int size = sizeStrategies();
        return size == 0;
    }

    @Override
    public boolean isStrategiesNotEmpty() {
        boolean empty = isStrategiesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsStrategies(Strategy strategies) {
        boolean contains = this.strategies !=null && this.strategies.contains(strategies);
        return contains;
    }

    @Override
    public void setBioAgressor(RefBioAgressor bioAgressor) {
        this.bioAgressor = bioAgressor;
    }

    @Override
    public RefBioAgressor getBioAgressor() {
        RefBioAgressor result = this.bioAgressor;
        return result;
    }

    @Override
    public void setCategoryObjective(CategoryObjective categoryObjective) {
        this.categoryObjective = categoryObjective;
    }

    @Override
    public CategoryObjective getCategoryObjective() {
        CategoryObjective result = this.categoryObjective;
        return result;
    }

    @Override
    public void setCategoryStrategy(CategoryStrategy categoryStrategy) {
        this.categoryStrategy = categoryStrategy;
    }

    @Override
    public CategoryStrategy getCategoryStrategy() {
        CategoryStrategy result = this.categoryStrategy;
        return result;
    }

    @Override
    public void setBioAgressorType(BioAgressorType bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    @Override
    public BioAgressorType getBioAgressorType() {
        BioAgressorType result = this.bioAgressorType;
        return result;
    }

} //SectionAbstract
