package fr.inra.agrosyst.api.entities.managementmode;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.GrowingSystem;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class ManagementModeAbstract extends AbstractTopiaEntity implements ManagementMode {

    /**
     * Nom de l'attribut en BD : versionNumber
     */
    protected Integer versionNumber;

    /**
     * Nom de l'attribut en BD : mainChanges
     */
    protected String mainChanges;

    /**
     * Nom de l'attribut en BD : changeReason
     */
    protected String changeReason;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : changeReasonFromPlanned
     */
    protected String changeReasonFromPlanned;

    /**
     * Nom de l'attribut en BD : mainChangesFromPlanned
     */
    protected String mainChangesFromPlanned;

    /**
     * Nom de l'attribut en BD : historical
     */
    protected String historical;

    /**
     * Nom de l'attribut en BD : category
     */
    protected ManagementModeCategory category;

    /**
     * Nom de l'attribut en BD : sections
     */
    protected Collection<Section> sections;

    /**
     * Nom de l'attribut en BD : growingSystem
     */
    protected GrowingSystem growingSystem;

    private static final long serialVersionUID = 3546074954924647985L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_VERSION_NUMBER, Integer.class, versionNumber);
        visitor.visit(this, PROPERTY_MAIN_CHANGES, String.class, mainChanges);
        visitor.visit(this, PROPERTY_CHANGE_REASON, String.class, changeReason);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_CHANGE_REASON_FROM_PLANNED, String.class, changeReasonFromPlanned);
        visitor.visit(this, PROPERTY_MAIN_CHANGES_FROM_PLANNED, String.class, mainChangesFromPlanned);
        visitor.visit(this, PROPERTY_HISTORICAL, String.class, historical);
        visitor.visit(this, PROPERTY_CATEGORY, ManagementModeCategory.class, category);
        visitor.visit(this, PROPERTY_SECTIONS, Collection.class, Section.class, sections);
        visitor.visit(this, PROPERTY_GROWING_SYSTEM, GrowingSystem.class, growingSystem);
    }

    @Override
    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Override
    public Integer getVersionNumber() {
        Integer result = this.versionNumber;
        return result;
    }

    @Override
    public void setMainChanges(String mainChanges) {
        this.mainChanges = mainChanges;
    }

    @Override
    public String getMainChanges() {
        String result = this.mainChanges;
        return result;
    }

    @Override
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    @Override
    public String getChangeReason() {
        String result = this.changeReason;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void setChangeReasonFromPlanned(String changeReasonFromPlanned) {
        this.changeReasonFromPlanned = changeReasonFromPlanned;
    }

    @Override
    public String getChangeReasonFromPlanned() {
        String result = this.changeReasonFromPlanned;
        return result;
    }

    @Override
    public void setMainChangesFromPlanned(String mainChangesFromPlanned) {
        this.mainChangesFromPlanned = mainChangesFromPlanned;
    }

    @Override
    public String getMainChangesFromPlanned() {
        String result = this.mainChangesFromPlanned;
        return result;
    }

    @Override
    public void setHistorical(String historical) {
        this.historical = historical;
    }

    @Override
    public String getHistorical() {
        String result = this.historical;
        return result;
    }

    @Override
    public void setCategory(ManagementModeCategory category) {
        this.category = category;
    }

    @Override
    public ManagementModeCategory getCategory() {
        ManagementModeCategory result = this.category;
        return result;
    }

    @Override
    public void addSections(Section sections) {
        if (this.sections == null) {
            this.sections = new LinkedList<Section>();
        }
        this.sections.add(sections);
    }

    @Override
    public void addAllSections(Iterable<Section> sections) {
        if (sections == null) {
            return;
        }
        for (Section item : sections) {
            addSections(item);
        }
    }

    @Override
    public void setSections(Collection<Section> sections) {
        this.sections = sections;
    }

    @Override
    public void removeSections(Section sections) {
        if (this.sections == null || !this.sections.remove(sections)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSections() {
        if (this.sections == null) {
            return;
        }
        this.sections.clear();
    }

    @Override
    public Collection<Section> getSections() {
        return sections;
    }

    @Override
    public Section getSectionsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(sections, topiaId);
    }

    @Override
    public Collection<String> getSectionsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.managementmode.Section> tmp = getSections();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSections() {
        if (sections == null) {
            return 0;
        }
        return sections.size();
    }

    @Override
    public boolean isSectionsEmpty() {
        int size = sizeSections();
        return size == 0;
    }

    @Override
    public boolean isSectionsNotEmpty() {
        boolean empty = isSectionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSections(Section sections) {
        boolean contains = this.sections !=null && this.sections.contains(sections);
        return contains;
    }

    @Override
    public void setGrowingSystem(GrowingSystem growingSystem) {
        this.growingSystem = growingSystem;
    }

    @Override
    public GrowingSystem getGrowingSystem() {
        GrowingSystem result = this.growingSystem;
        return result;
    }

} //ManagementModeAbstract
