package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Zone;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:19 CET 2015")
public abstract class EffectiveSeasonalCropCycleAbstract extends AbstractTopiaEntity implements EffectiveSeasonalCropCycle {

    /**
     * Nom de l'attribut en BD : zone
     */
    protected Zone zone;

    /**
     * Nom de l'attribut en BD : nodes
     */
    protected Collection<EffectiveCropCycleNode> nodes;

    private static final long serialVersionUID = 3990533633422408036L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ZONE, Zone.class, zone);
        visitor.visit(this, PROPERTY_NODES, Collection.class, EffectiveCropCycleNode.class, nodes);
    }

    @Override
    public void setZone(Zone zone) {
        this.zone = zone;
    }

    @Override
    public Zone getZone() {
        Zone result = this.zone;
        return result;
    }

    @Override
    public void addNodes(EffectiveCropCycleNode nodes) {
        if (this.nodes == null) {
            this.nodes = new LinkedList<EffectiveCropCycleNode>();
        }
        this.nodes.add(nodes);
    }

    @Override
    public void addAllNodes(Iterable<EffectiveCropCycleNode> nodes) {
        if (nodes == null) {
            return;
        }
        for (EffectiveCropCycleNode item : nodes) {
            addNodes(item);
        }
    }

    @Override
    public void setNodes(Collection<EffectiveCropCycleNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public void removeNodes(EffectiveCropCycleNode nodes) {
        if (this.nodes == null || !this.nodes.remove(nodes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearNodes() {
        if (this.nodes == null) {
            return;
        }
        this.nodes.clear();
    }

    @Override
    public Collection<EffectiveCropCycleNode> getNodes() {
        return nodes;
    }

    @Override
    public EffectiveCropCycleNode getNodesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(nodes, topiaId);
    }

    @Override
    public Collection<String> getNodesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode> tmp = getNodes();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeNodes() {
        if (nodes == null) {
            return 0;
        }
        return nodes.size();
    }

    @Override
    public boolean isNodesEmpty() {
        int size = sizeNodes();
        return size == 0;
    }

    @Override
    public boolean isNodesNotEmpty() {
        boolean empty = isNodesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsNodes(EffectiveCropCycleNode nodes) {
        boolean contains = this.nodes !=null && this.nodes.contains(nodes);
        return contains;
    }

} //EffectiveSeasonalCropCycleAbstract
