package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class EffectivePerennialCropCycleAbstract extends AbstractTopiaEntity implements EffectivePerennialCropCycle {

    /**
     * Nom de l'attribut en BD : plantingYear
     */
    protected Integer plantingYear;

    /**
     * Nom de l'attribut en BD : plantingDensity
     */
    protected Double plantingDensity;

    /**
     * Nom de l'attribut en BD : plantingInterFurrow
     */
    protected Integer plantingInterFurrow;

    /**
     * Nom de l'attribut en BD : plantingSpacing
     */
    protected Integer plantingSpacing;

    /**
     * Nom de l'attribut en BD : plantingDeathRate
     */
    protected Double plantingDeathRate;

    /**
     * Nom de l'attribut en BD : plantingDeathRateMeasureYear
     */
    protected Integer plantingDeathRateMeasureYear;

    /**
     * Nom de l'attribut en BD : pollinator
     */
    protected boolean pollinator;

    /**
     * Nom de l'attribut en BD : pollinatorPercent
     */
    protected Double pollinatorPercent;

    /**
     * Nom de l'attribut en BD : otherCharacteristics
     */
    protected String otherCharacteristics;

    /**
     * Nom de l'attribut en BD : foliageHeight
     */
    protected Double foliageHeight;

    /**
     * Nom de l'attribut en BD : foliageThickness
     */
    protected Double foliageThickness;

    /**
     * Nom de l'attribut en BD : edaplosIssuerId
     */
    protected String edaplosIssuerId;

    /**
     * Nom de l'attribut en BD : orientation
     */
    protected RefOrientationEDI orientation;

    /**
     * Nom de l'attribut en BD : pollinatorSpreadMode
     */
    protected PollinatorSpreadMode pollinatorSpreadMode;

    /**
     * Nom de l'attribut en BD : weedType
     */
    protected WeedType weedType;

    /**
     * Nom de l'attribut en BD : orchardFrutalForm
     */
    protected OrchardFrutalForm orchardFrutalForm;

    /**
     * Nom de l'attribut en BD : vineFrutalForm
     */
    protected VineFrutalForm vineFrutalForm;

    /**
     * Nom de l'attribut en BD : zone
     */
    protected Zone zone;

    /**
     * Nom de l'attribut en BD : croppingPlanEntry
     */
    protected CroppingPlanEntry croppingPlanEntry;

    /**
     * Nom de l'attribut en BD : phase
     */
    protected EffectiveCropCyclePhase phase;

    /**
     * Nom de l'attribut en BD : species
     */
    protected Collection<EffectiveCropCycleSpecies> species;

    private static final long serialVersionUID = 7017508054672827952L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_PLANTING_YEAR, Integer.class, plantingYear);
        visitor.visit(this, PROPERTY_PLANTING_DENSITY, Double.class, plantingDensity);
        visitor.visit(this, PROPERTY_PLANTING_INTER_FURROW, Integer.class, plantingInterFurrow);
        visitor.visit(this, PROPERTY_PLANTING_SPACING, Integer.class, plantingSpacing);
        visitor.visit(this, PROPERTY_PLANTING_DEATH_RATE, Double.class, plantingDeathRate);
        visitor.visit(this, PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, Integer.class, plantingDeathRateMeasureYear);
        visitor.visit(this, PROPERTY_POLLINATOR, boolean.class, pollinator);
        visitor.visit(this, PROPERTY_POLLINATOR_PERCENT, Double.class, pollinatorPercent);
        visitor.visit(this, PROPERTY_OTHER_CHARACTERISTICS, String.class, otherCharacteristics);
        visitor.visit(this, PROPERTY_FOLIAGE_HEIGHT, Double.class, foliageHeight);
        visitor.visit(this, PROPERTY_FOLIAGE_THICKNESS, Double.class, foliageThickness);
        visitor.visit(this, PROPERTY_EDAPLOS_ISSUER_ID, String.class, edaplosIssuerId);
        visitor.visit(this, PROPERTY_ORIENTATION, RefOrientationEDI.class, orientation);
        visitor.visit(this, PROPERTY_POLLINATOR_SPREAD_MODE, PollinatorSpreadMode.class, pollinatorSpreadMode);
        visitor.visit(this, PROPERTY_WEED_TYPE, WeedType.class, weedType);
        visitor.visit(this, PROPERTY_ORCHARD_FRUTAL_FORM, OrchardFrutalForm.class, orchardFrutalForm);
        visitor.visit(this, PROPERTY_VINE_FRUTAL_FORM, VineFrutalForm.class, vineFrutalForm);
        visitor.visit(this, PROPERTY_ZONE, Zone.class, zone);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_ENTRY, CroppingPlanEntry.class, croppingPlanEntry);
        visitor.visit(this, PROPERTY_PHASE, EffectiveCropCyclePhase.class, phase);
        visitor.visit(this, PROPERTY_SPECIES, Collection.class, EffectiveCropCycleSpecies.class, species);
    }

    @Override
    public void setPlantingYear(Integer plantingYear) {
        this.plantingYear = plantingYear;
    }

    @Override
    public Integer getPlantingYear() {
        Integer result = this.plantingYear;
        return result;
    }

    @Override
    public void setPlantingDensity(Double plantingDensity) {
        this.plantingDensity = plantingDensity;
    }

    @Override
    public Double getPlantingDensity() {
        Double result = this.plantingDensity;
        return result;
    }

    @Override
    public void setPlantingInterFurrow(Integer plantingInterFurrow) {
        this.plantingInterFurrow = plantingInterFurrow;
    }

    @Override
    public Integer getPlantingInterFurrow() {
        Integer result = this.plantingInterFurrow;
        return result;
    }

    @Override
    public void setPlantingSpacing(Integer plantingSpacing) {
        this.plantingSpacing = plantingSpacing;
    }

    @Override
    public Integer getPlantingSpacing() {
        Integer result = this.plantingSpacing;
        return result;
    }

    @Override
    public void setPlantingDeathRate(Double plantingDeathRate) {
        this.plantingDeathRate = plantingDeathRate;
    }

    @Override
    public Double getPlantingDeathRate() {
        Double result = this.plantingDeathRate;
        return result;
    }

    @Override
    public void setPlantingDeathRateMeasureYear(Integer plantingDeathRateMeasureYear) {
        this.plantingDeathRateMeasureYear = plantingDeathRateMeasureYear;
    }

    @Override
    public Integer getPlantingDeathRateMeasureYear() {
        Integer result = this.plantingDeathRateMeasureYear;
        return result;
    }

    @Override
    public void setPollinator(boolean pollinator) {
        this.pollinator = pollinator;
    }

    @Override
    public boolean isPollinator() {
        boolean result = this.pollinator;
        return result;
    }

    @Override
    public void setPollinatorPercent(Double pollinatorPercent) {
        this.pollinatorPercent = pollinatorPercent;
    }

    @Override
    public Double getPollinatorPercent() {
        Double result = this.pollinatorPercent;
        return result;
    }

    @Override
    public void setOtherCharacteristics(String otherCharacteristics) {
        this.otherCharacteristics = otherCharacteristics;
    }

    @Override
    public String getOtherCharacteristics() {
        String result = this.otherCharacteristics;
        return result;
    }

    @Override
    public void setFoliageHeight(Double foliageHeight) {
        this.foliageHeight = foliageHeight;
    }

    @Override
    public Double getFoliageHeight() {
        Double result = this.foliageHeight;
        return result;
    }

    @Override
    public void setFoliageThickness(Double foliageThickness) {
        this.foliageThickness = foliageThickness;
    }

    @Override
    public Double getFoliageThickness() {
        Double result = this.foliageThickness;
        return result;
    }

    @Override
    public void setEdaplosIssuerId(String edaplosIssuerId) {
        this.edaplosIssuerId = edaplosIssuerId;
    }

    @Override
    public String getEdaplosIssuerId() {
        String result = this.edaplosIssuerId;
        return result;
    }

    @Override
    public void setOrientation(RefOrientationEDI orientation) {
        this.orientation = orientation;
    }

    @Override
    public RefOrientationEDI getOrientation() {
        RefOrientationEDI result = this.orientation;
        return result;
    }

    @Override
    public void setPollinatorSpreadMode(PollinatorSpreadMode pollinatorSpreadMode) {
        this.pollinatorSpreadMode = pollinatorSpreadMode;
    }

    @Override
    public PollinatorSpreadMode getPollinatorSpreadMode() {
        PollinatorSpreadMode result = this.pollinatorSpreadMode;
        return result;
    }

    @Override
    public void setWeedType(WeedType weedType) {
        this.weedType = weedType;
    }

    @Override
    public WeedType getWeedType() {
        WeedType result = this.weedType;
        return result;
    }

    @Override
    public void setOrchardFrutalForm(OrchardFrutalForm orchardFrutalForm) {
        this.orchardFrutalForm = orchardFrutalForm;
    }

    @Override
    public OrchardFrutalForm getOrchardFrutalForm() {
        OrchardFrutalForm result = this.orchardFrutalForm;
        return result;
    }

    @Override
    public void setVineFrutalForm(VineFrutalForm vineFrutalForm) {
        this.vineFrutalForm = vineFrutalForm;
    }

    @Override
    public VineFrutalForm getVineFrutalForm() {
        VineFrutalForm result = this.vineFrutalForm;
        return result;
    }

    @Override
    public void setZone(Zone zone) {
        this.zone = zone;
    }

    @Override
    public Zone getZone() {
        Zone result = this.zone;
        return result;
    }

    @Override
    public void setCroppingPlanEntry(CroppingPlanEntry croppingPlanEntry) {
        this.croppingPlanEntry = croppingPlanEntry;
    }

    @Override
    public CroppingPlanEntry getCroppingPlanEntry() {
        CroppingPlanEntry result = this.croppingPlanEntry;
        return result;
    }

    @Override
    public void setPhase(EffectiveCropCyclePhase phase) {
        this.phase = phase;
    }

    @Override
    public EffectiveCropCyclePhase getPhase() {
        EffectiveCropCyclePhase result = this.phase;
        return result;
    }

    @Override
    public void addSpecies(EffectiveCropCycleSpecies species) {
        if (this.species == null) {
            this.species = new LinkedList<EffectiveCropCycleSpecies>();
        }
        this.species.add(species);
    }

    @Override
    public void addAllSpecies(Iterable<EffectiveCropCycleSpecies> species) {
        if (species == null) {
            return;
        }
        for (EffectiveCropCycleSpecies item : species) {
            addSpecies(item);
        }
    }

    @Override
    public void setSpecies(Collection<EffectiveCropCycleSpecies> species) {
        this.species = species;
    }

    @Override
    public void removeSpecies(EffectiveCropCycleSpecies species) {
        if (this.species == null || !this.species.remove(species)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSpecies() {
        if (this.species == null) {
            return;
        }
        this.species.clear();
    }

    @Override
    public Collection<EffectiveCropCycleSpecies> getSpecies() {
        return species;
    }

    @Override
    public EffectiveCropCycleSpecies getSpeciesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(species, topiaId);
    }

    @Override
    public Collection<String> getSpeciesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies> tmp = getSpecies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSpecies() {
        if (species == null) {
            return 0;
        }
        return species.size();
    }

    @Override
    public boolean isSpeciesEmpty() {
        int size = sizeSpecies();
        return size == 0;
    }

    @Override
    public boolean isSpeciesNotEmpty() {
        boolean empty = isSpeciesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSpecies(EffectiveCropCycleSpecies species) {
        boolean contains = this.species !=null && this.species.contains(species);
        return contains;
    }

} //EffectivePerennialCropCycleAbstract
