package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class EffectiveInterventionAbstract extends AbstractTopiaEntity implements EffectiveIntervention {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : startInterventionDate
     */
    protected Date startInterventionDate;

    /**
     * Nom de l'attribut en BD : intermediateCrop
     */
    protected boolean intermediateCrop;

    /**
     * Nom de l'attribut en BD : tillageDepth
     */
    protected Integer tillageDepth;

    /**
     * Nom de l'attribut en BD : otherToolSettings
     */
    protected String otherToolSettings;

    /**
     * Nom de l'attribut en BD : workRate
     */
    protected Double workRate;

    /**
     * Nom de l'attribut en BD : progressionSpeed
     */
    protected Integer progressionSpeed;

    /**
     * Nom de l'attribut en BD : involvedPeopleCount
     */
    protected Double involvedPeopleCount;

    /**
     * Nom de l'attribut en BD : endInterventionDate
     */
    protected Date endInterventionDate;

    /**
     * Nom de l'attribut en BD : spatialFrequency
     */
    protected double spatialFrequency;

    /**
     * Nom de l'attribut en BD : transitCount
     */
    protected int transitCount;

    /**
     * Nom de l'attribut en BD : transitVolume
     */
    protected Double transitVolume;

    /**
     * Nom de l'attribut en BD : nbBalls
     */
    protected Integer nbBalls;

    /**
     * Nom de l'attribut en BD : edaplosIssuerId
     */
    protected String edaplosIssuerId;

    /**
     * Nom de l'attribut en BD : effectiveCropCycleNode
     */
    protected EffectiveCropCycleNode effectiveCropCycleNode;

    /**
     * Nom de l'attribut en BD : effectiveCropCyclePhase
     */
    protected EffectiveCropCyclePhase effectiveCropCyclePhase;

    /**
     * Nom de l'attribut en BD : toolCouplings
     */
    protected Collection<ToolsCoupling> toolCouplings;

    /**
     * Nom de l'attribut en BD : speciesStades
     */
    protected Collection<EffectiveSpeciesStade> speciesStades;

    /**
     * Nom de l'attribut en BD : type
     */
    protected AgrosystInterventionType type;

    /**
     * Nom de l'attribut en BD : measurements
     */
    protected Collection<Measurement> measurements;

    /**
     * Nom de l'attribut en BD : invlovedRules
     */
    protected Collection<EffectiveInvolvedRule> invlovedRules;

    /**
     * Nom de l'attribut en BD : workRateUnit
     */
    protected MaterielWorkRateUnit workRateUnit;

    /**
     * Nom de l'attribut en BD : transitVolumeUnit
     */
    protected MaterielTransportUnit transitVolumeUnit;

    private static final long serialVersionUID = 3774410319866717239L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_START_INTERVENTION_DATE, Date.class, startInterventionDate);
        visitor.visit(this, PROPERTY_INTERMEDIATE_CROP, boolean.class, intermediateCrop);
        visitor.visit(this, PROPERTY_TILLAGE_DEPTH, Integer.class, tillageDepth);
        visitor.visit(this, PROPERTY_OTHER_TOOL_SETTINGS, String.class, otherToolSettings);
        visitor.visit(this, PROPERTY_WORK_RATE, Double.class, workRate);
        visitor.visit(this, PROPERTY_PROGRESSION_SPEED, Integer.class, progressionSpeed);
        visitor.visit(this, PROPERTY_INVOLVED_PEOPLE_COUNT, Double.class, involvedPeopleCount);
        visitor.visit(this, PROPERTY_END_INTERVENTION_DATE, Date.class, endInterventionDate);
        visitor.visit(this, PROPERTY_SPATIAL_FREQUENCY, double.class, spatialFrequency);
        visitor.visit(this, PROPERTY_TRANSIT_COUNT, int.class, transitCount);
        visitor.visit(this, PROPERTY_TRANSIT_VOLUME, Double.class, transitVolume);
        visitor.visit(this, PROPERTY_NB_BALLS, Integer.class, nbBalls);
        visitor.visit(this, PROPERTY_EDAPLOS_ISSUER_ID, String.class, edaplosIssuerId);
        visitor.visit(this, PROPERTY_EFFECTIVE_CROP_CYCLE_NODE, EffectiveCropCycleNode.class, effectiveCropCycleNode);
        visitor.visit(this, PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE, EffectiveCropCyclePhase.class, effectiveCropCyclePhase);
        visitor.visit(this, PROPERTY_TOOL_COUPLINGS, Collection.class, ToolsCoupling.class, toolCouplings);
        visitor.visit(this, PROPERTY_SPECIES_STADES, Collection.class, EffectiveSpeciesStade.class, speciesStades);
        visitor.visit(this, PROPERTY_TYPE, AgrosystInterventionType.class, type);
        visitor.visit(this, PROPERTY_MEASUREMENTS, Collection.class, Measurement.class, measurements);
        visitor.visit(this, PROPERTY_INVLOVED_RULES, Collection.class, EffectiveInvolvedRule.class, invlovedRules);
        visitor.visit(this, PROPERTY_WORK_RATE_UNIT, MaterielWorkRateUnit.class, workRateUnit);
        visitor.visit(this, PROPERTY_TRANSIT_VOLUME_UNIT, MaterielTransportUnit.class, transitVolumeUnit);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setStartInterventionDate(Date startInterventionDate) {
        this.startInterventionDate = startInterventionDate;
    }

    @Override
    public Date getStartInterventionDate() {
        Date result = this.startInterventionDate;
        return result;
    }

    @Override
    public void setIntermediateCrop(boolean intermediateCrop) {
        this.intermediateCrop = intermediateCrop;
    }

    @Override
    public boolean isIntermediateCrop() {
        boolean result = this.intermediateCrop;
        return result;
    }

    @Override
    public void setTillageDepth(Integer tillageDepth) {
        this.tillageDepth = tillageDepth;
    }

    @Override
    public Integer getTillageDepth() {
        Integer result = this.tillageDepth;
        return result;
    }

    @Override
    public void setOtherToolSettings(String otherToolSettings) {
        this.otherToolSettings = otherToolSettings;
    }

    @Override
    public String getOtherToolSettings() {
        String result = this.otherToolSettings;
        return result;
    }

    @Override
    public void setWorkRate(Double workRate) {
        this.workRate = workRate;
    }

    @Override
    public Double getWorkRate() {
        Double result = this.workRate;
        return result;
    }

    @Override
    public void setProgressionSpeed(Integer progressionSpeed) {
        this.progressionSpeed = progressionSpeed;
    }

    @Override
    public Integer getProgressionSpeed() {
        Integer result = this.progressionSpeed;
        return result;
    }

    @Override
    public void setInvolvedPeopleCount(Double involvedPeopleCount) {
        this.involvedPeopleCount = involvedPeopleCount;
    }

    @Override
    public Double getInvolvedPeopleCount() {
        Double result = this.involvedPeopleCount;
        return result;
    }

    @Override
    public void setEndInterventionDate(Date endInterventionDate) {
        this.endInterventionDate = endInterventionDate;
    }

    @Override
    public Date getEndInterventionDate() {
        Date result = this.endInterventionDate;
        return result;
    }

    @Override
    public void setSpatialFrequency(double spatialFrequency) {
        this.spatialFrequency = spatialFrequency;
    }

    @Override
    public double getSpatialFrequency() {
        double result = this.spatialFrequency;
        return result;
    }

    @Override
    public void setTransitCount(int transitCount) {
        this.transitCount = transitCount;
    }

    @Override
    public int getTransitCount() {
        int result = this.transitCount;
        return result;
    }

    @Override
    public void setTransitVolume(Double transitVolume) {
        this.transitVolume = transitVolume;
    }

    @Override
    public Double getTransitVolume() {
        Double result = this.transitVolume;
        return result;
    }

    @Override
    public void setNbBalls(Integer nbBalls) {
        this.nbBalls = nbBalls;
    }

    @Override
    public Integer getNbBalls() {
        Integer result = this.nbBalls;
        return result;
    }

    @Override
    public void setEdaplosIssuerId(String edaplosIssuerId) {
        this.edaplosIssuerId = edaplosIssuerId;
    }

    @Override
    public String getEdaplosIssuerId() {
        String result = this.edaplosIssuerId;
        return result;
    }

    @Override
    public void setEffectiveCropCycleNode(EffectiveCropCycleNode effectiveCropCycleNode) {
        this.effectiveCropCycleNode = effectiveCropCycleNode;
    }

    @Override
    public EffectiveCropCycleNode getEffectiveCropCycleNode() {
        EffectiveCropCycleNode result = this.effectiveCropCycleNode;
        return result;
    }

    @Override
    public void setEffectiveCropCyclePhase(EffectiveCropCyclePhase effectiveCropCyclePhase) {
        this.effectiveCropCyclePhase = effectiveCropCyclePhase;
    }

    @Override
    public EffectiveCropCyclePhase getEffectiveCropCyclePhase() {
        EffectiveCropCyclePhase result = this.effectiveCropCyclePhase;
        return result;
    }

    @Override
    public void addToolCouplings(ToolsCoupling toolCouplings) {
        if (this.toolCouplings == null) {
            this.toolCouplings = new LinkedList<ToolsCoupling>();
        }
        this.toolCouplings.add(toolCouplings);
    }

    @Override
    public void addAllToolCouplings(Iterable<ToolsCoupling> toolCouplings) {
        if (toolCouplings == null) {
            return;
        }
        for (ToolsCoupling item : toolCouplings) {
            addToolCouplings(item);
        }
    }

    @Override
    public void setToolCouplings(Collection<ToolsCoupling> toolCouplings) {
        this.toolCouplings = toolCouplings;
    }

    @Override
    public void removeToolCouplings(ToolsCoupling toolCouplings) {
        if (this.toolCouplings == null || !this.toolCouplings.remove(toolCouplings)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearToolCouplings() {
        if (this.toolCouplings == null) {
            return;
        }
        this.toolCouplings.clear();
    }

    @Override
    public Collection<ToolsCoupling> getToolCouplings() {
        return toolCouplings;
    }

    @Override
    public ToolsCoupling getToolCouplingsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(toolCouplings, topiaId);
    }

    @Override
    public Collection<String> getToolCouplingsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.ToolsCoupling> tmp = getToolCouplings();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeToolCouplings() {
        if (toolCouplings == null) {
            return 0;
        }
        return toolCouplings.size();
    }

    @Override
    public boolean isToolCouplingsEmpty() {
        int size = sizeToolCouplings();
        return size == 0;
    }

    @Override
    public boolean isToolCouplingsNotEmpty() {
        boolean empty = isToolCouplingsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsToolCouplings(ToolsCoupling toolCouplings) {
        boolean contains = this.toolCouplings !=null && this.toolCouplings.contains(toolCouplings);
        return contains;
    }

    @Override
    public void addSpeciesStades(EffectiveSpeciesStade speciesStades) {
        if (this.speciesStades == null) {
            this.speciesStades = new LinkedList<EffectiveSpeciesStade>();
        }
        this.speciesStades.add(speciesStades);
    }

    @Override
    public void addAllSpeciesStades(Iterable<EffectiveSpeciesStade> speciesStades) {
        if (speciesStades == null) {
            return;
        }
        for (EffectiveSpeciesStade item : speciesStades) {
            addSpeciesStades(item);
        }
    }

    @Override
    public void setSpeciesStades(Collection<EffectiveSpeciesStade> speciesStades) {
        this.speciesStades = speciesStades;
    }

    @Override
    public void removeSpeciesStades(EffectiveSpeciesStade speciesStades) {
        if (this.speciesStades == null || !this.speciesStades.remove(speciesStades)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSpeciesStades() {
        if (this.speciesStades == null) {
            return;
        }
        this.speciesStades.clear();
    }

    @Override
    public Collection<EffectiveSpeciesStade> getSpeciesStades() {
        return speciesStades;
    }

    @Override
    public EffectiveSpeciesStade getSpeciesStadesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(speciesStades, topiaId);
    }

    @Override
    public Collection<String> getSpeciesStadesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade> tmp = getSpeciesStades();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSpeciesStades() {
        if (speciesStades == null) {
            return 0;
        }
        return speciesStades.size();
    }

    @Override
    public boolean isSpeciesStadesEmpty() {
        int size = sizeSpeciesStades();
        return size == 0;
    }

    @Override
    public boolean isSpeciesStadesNotEmpty() {
        boolean empty = isSpeciesStadesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSpeciesStades(EffectiveSpeciesStade speciesStades) {
        boolean contains = this.speciesStades !=null && this.speciesStades.contains(speciesStades);
        return contains;
    }

    @Override
    public void setType(AgrosystInterventionType type) {
        this.type = type;
    }

    @Override
    public AgrosystInterventionType getType() {
        AgrosystInterventionType result = this.type;
        return result;
    }

    @Override
    public void addMeasurements(Measurement measurements) {
        if (this.measurements == null) {
            this.measurements = new LinkedList<Measurement>();
        }
        measurements.setEffectiveIntervention(this);
        this.measurements.add(measurements);
    }

    @Override
    public void addAllMeasurements(Iterable<Measurement> measurements) {
        if (measurements == null) {
            return;
        }
        for (Measurement item : measurements) {
            addMeasurements(item);
        }
    }

    @Override
    public void setMeasurements(Collection<Measurement> measurements) {
        this.measurements = measurements;
    }

    @Override
    public void removeMeasurements(Measurement measurements) {
        if (this.measurements == null || !this.measurements.remove(measurements)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        measurements.setEffectiveIntervention(null);
    }

    @Override
    public void clearMeasurements() {
        if (this.measurements == null) {
            return;
        }
        for (Measurement item : this.measurements) {
            item.setEffectiveIntervention(null);
        }
        this.measurements.clear();
    }

    @Override
    public Collection<Measurement> getMeasurements() {
        return measurements;
    }

    @Override
    public Measurement getMeasurementsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(measurements, topiaId);
    }

    @Override
    public Collection<String> getMeasurementsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.measure.Measurement> tmp = getMeasurements();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMeasurements() {
        if (measurements == null) {
            return 0;
        }
        return measurements.size();
    }

    @Override
    public boolean isMeasurementsEmpty() {
        int size = sizeMeasurements();
        return size == 0;
    }

    @Override
    public boolean isMeasurementsNotEmpty() {
        boolean empty = isMeasurementsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMeasurements(Measurement measurements) {
        boolean contains = this.measurements !=null && this.measurements.contains(measurements);
        return contains;
    }

    @Override
    public void addInvlovedRules(EffectiveInvolvedRule invlovedRules) {
        if (this.invlovedRules == null) {
            this.invlovedRules = new LinkedList<EffectiveInvolvedRule>();
        }
        this.invlovedRules.add(invlovedRules);
    }

    @Override
    public void addAllInvlovedRules(Iterable<EffectiveInvolvedRule> invlovedRules) {
        if (invlovedRules == null) {
            return;
        }
        for (EffectiveInvolvedRule item : invlovedRules) {
            addInvlovedRules(item);
        }
    }

    @Override
    public void setInvlovedRules(Collection<EffectiveInvolvedRule> invlovedRules) {
        this.invlovedRules = invlovedRules;
    }

    @Override
    public void removeInvlovedRules(EffectiveInvolvedRule invlovedRules) {
        if (this.invlovedRules == null || !this.invlovedRules.remove(invlovedRules)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearInvlovedRules() {
        if (this.invlovedRules == null) {
            return;
        }
        this.invlovedRules.clear();
    }

    @Override
    public Collection<EffectiveInvolvedRule> getInvlovedRules() {
        return invlovedRules;
    }

    @Override
    public EffectiveInvolvedRule getInvlovedRulesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(invlovedRules, topiaId);
    }

    @Override
    public Collection<String> getInvlovedRulesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.effective.EffectiveInvolvedRule> tmp = getInvlovedRules();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeInvlovedRules() {
        if (invlovedRules == null) {
            return 0;
        }
        return invlovedRules.size();
    }

    @Override
    public boolean isInvlovedRulesEmpty() {
        int size = sizeInvlovedRules();
        return size == 0;
    }

    @Override
    public boolean isInvlovedRulesNotEmpty() {
        boolean empty = isInvlovedRulesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsInvlovedRules(EffectiveInvolvedRule invlovedRules) {
        boolean contains = this.invlovedRules !=null && this.invlovedRules.contains(invlovedRules);
        return contains;
    }

    @Override
    public void setWorkRateUnit(MaterielWorkRateUnit workRateUnit) {
        this.workRateUnit = workRateUnit;
    }

    @Override
    public MaterielWorkRateUnit getWorkRateUnit() {
        MaterielWorkRateUnit result = this.workRateUnit;
        return result;
    }

    @Override
    public void setTransitVolumeUnit(MaterielTransportUnit transitVolumeUnit) {
        this.transitVolumeUnit = transitVolumeUnit;
    }

    @Override
    public MaterielTransportUnit getTransitVolumeUnit() {
        MaterielTransportUnit result = this.transitVolumeUnit;
        return result;
    }

} //EffectiveInterventionAbstract
