package fr.inra.agrosyst.api.entities.action;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class SeedingActionAbstract extends AbstractActionImpl implements SeedingAction {

    /**
     * Nom de l'attribut en BD : yealdTarget
     */
    protected Double yealdTarget;

    /**
     * Nom de l'attribut en BD : seedType
     */
    protected SeedType seedType;

    /**
     * Nom de l'attribut en BD : seedingSpecies
     */
    protected Collection<SeedingActionSpecies> seedingSpecies;

    /**
     * Nom de l'attribut en BD : yealdUnit
     */
    protected YealdUnit yealdUnit;

    private static final long serialVersionUID = 3617909146305706039L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_YEALD_TARGET, Double.class, yealdTarget);
        visitor.visit(this, PROPERTY_SEED_TYPE, SeedType.class, seedType);
        visitor.visit(this, PROPERTY_SEEDING_SPECIES, Collection.class, SeedingActionSpecies.class, seedingSpecies);
        visitor.visit(this, PROPERTY_YEALD_UNIT, YealdUnit.class, yealdUnit);
    }

    @Override
    public void setYealdTarget(Double yealdTarget) {
        this.yealdTarget = yealdTarget;
    }

    @Override
    public Double getYealdTarget() {
        Double result = this.yealdTarget;
        return result;
    }

    @Override
    public void setSeedType(SeedType seedType) {
        this.seedType = seedType;
    }

    @Override
    public SeedType getSeedType() {
        SeedType result = this.seedType;
        return result;
    }

    @Override
    public void addSeedingSpecies(SeedingActionSpecies seedingSpecies) {
        if (this.seedingSpecies == null) {
            this.seedingSpecies = new LinkedList<SeedingActionSpecies>();
        }
        this.seedingSpecies.add(seedingSpecies);
    }

    @Override
    public void addAllSeedingSpecies(Iterable<SeedingActionSpecies> seedingSpecies) {
        if (seedingSpecies == null) {
            return;
        }
        for (SeedingActionSpecies item : seedingSpecies) {
            addSeedingSpecies(item);
        }
    }

    @Override
    public void setSeedingSpecies(Collection<SeedingActionSpecies> seedingSpecies) {
        this.seedingSpecies = seedingSpecies;
    }

    @Override
    public void removeSeedingSpecies(SeedingActionSpecies seedingSpecies) {
        if (this.seedingSpecies == null || !this.seedingSpecies.remove(seedingSpecies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSeedingSpecies() {
        if (this.seedingSpecies == null) {
            return;
        }
        this.seedingSpecies.clear();
    }

    @Override
    public Collection<SeedingActionSpecies> getSeedingSpecies() {
        return seedingSpecies;
    }

    @Override
    public SeedingActionSpecies getSeedingSpeciesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(seedingSpecies, topiaId);
    }

    @Override
    public Collection<String> getSeedingSpeciesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.action.SeedingActionSpecies> tmp = getSeedingSpecies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSeedingSpecies() {
        if (seedingSpecies == null) {
            return 0;
        }
        return seedingSpecies.size();
    }

    @Override
    public boolean isSeedingSpeciesEmpty() {
        int size = sizeSeedingSpecies();
        return size == 0;
    }

    @Override
    public boolean isSeedingSpeciesNotEmpty() {
        boolean empty = isSeedingSpeciesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSeedingSpecies(SeedingActionSpecies seedingSpecies) {
        boolean contains = this.seedingSpecies !=null && this.seedingSpecies.contains(seedingSpecies);
        return contains;
    }

    @Override
    public void setYealdUnit(YealdUnit yealdUnit) {
        this.yealdUnit = yealdUnit;
    }

    @Override
    public YealdUnit getYealdUnit() {
        YealdUnit result = this.yealdUnit;
        return result;
    }

} //SeedingActionAbstract
