package fr.inra.agrosyst.api.entities.action;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class PhytoProductInputAbstract extends AbstractInputImpl implements PhytoProductInput {

    /**
     * Nom de l'attribut en BD : productType
     */
    protected String productType;

    /**
     * Nom de l'attribut en BD : phytoProduct
     */
    protected RefActaTraitementsProduit phytoProduct;

    /**
     * Nom de l'attribut en BD : targets
     */
    protected Collection<RefBioAgressor> targets;

    /**
     * Nom de l'attribut en BD : phytoProductUnit
     */
    protected PhytoProductUnit phytoProductUnit;

    private static final long serialVersionUID = 4049125524979921457L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_PRODUCT_TYPE, String.class, productType);
        visitor.visit(this, PROPERTY_PHYTO_PRODUCT, RefActaTraitementsProduit.class, phytoProduct);
        visitor.visit(this, PROPERTY_TARGETS, Collection.class, RefBioAgressor.class, targets);
        visitor.visit(this, PROPERTY_PHYTO_PRODUCT_UNIT, PhytoProductUnit.class, phytoProductUnit);
    }

    @Override
    public void setProductType(String productType) {
        this.productType = productType;
    }

    @Override
    public String getProductType() {
        String result = this.productType;
        return result;
    }

    @Override
    public void setPhytoProduct(RefActaTraitementsProduit phytoProduct) {
        this.phytoProduct = phytoProduct;
    }

    @Override
    public RefActaTraitementsProduit getPhytoProduct() {
        RefActaTraitementsProduit result = this.phytoProduct;
        return result;
    }

    @Override
    public void addTargets(RefBioAgressor targets) {
        if (this.targets == null) {
            this.targets = new LinkedList<RefBioAgressor>();
        }
        this.targets.add(targets);
    }

    @Override
    public void addAllTargets(Iterable<RefBioAgressor> targets) {
        if (targets == null) {
            return;
        }
        for (RefBioAgressor item : targets) {
            addTargets(item);
        }
    }

    @Override
    public void setTargets(Collection<RefBioAgressor> targets) {
        this.targets = targets;
    }

    @Override
    public void removeTargets(RefBioAgressor targets) {
        if (this.targets == null || !this.targets.remove(targets)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearTargets() {
        if (this.targets == null) {
            return;
        }
        this.targets.clear();
    }

    @Override
    public Collection<RefBioAgressor> getTargets() {
        return targets;
    }

    @Override
    public RefBioAgressor getTargetsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(targets, topiaId);
    }

    @Override
    public Collection<String> getTargetsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.referential.RefBioAgressor> tmp = getTargets();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeTargets() {
        if (targets == null) {
            return 0;
        }
        return targets.size();
    }

    @Override
    public boolean isTargetsEmpty() {
        int size = sizeTargets();
        return size == 0;
    }

    @Override
    public boolean isTargetsNotEmpty() {
        boolean empty = isTargetsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsTargets(RefBioAgressor targets) {
        boolean contains = this.targets !=null && this.targets.contains(targets);
        return contains;
    }

    @Override
    public void setPhytoProductUnit(PhytoProductUnit phytoProductUnit) {
        this.phytoProductUnit = phytoProductUnit;
    }

    @Override
    public PhytoProductUnit getPhytoProductUnit() {
        PhytoProductUnit result = this.phytoProductUnit;
        return result;
    }

} //PhytoProductInputAbstract
