package fr.inra.agrosyst.api.entities.action;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class HarvestingActionAbstract extends AbstractActionImpl implements HarvestingAction {

    /**
     * Nom de l'attribut en BD : moisturePercent
     */
    protected Double moisturePercent;

    /**
     * Nom de l'attribut en BD : exportedWaste
     */
    protected boolean exportedWaste;

    /**
     * Nom de l'attribut en BD : harvestingYealds
     */
    protected Collection<HarvestingYeald> harvestingYealds;

    private static final long serialVersionUID = 7075212623955113573L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_MOISTURE_PERCENT, Double.class, moisturePercent);
        visitor.visit(this, PROPERTY_EXPORTED_WASTE, boolean.class, exportedWaste);
        visitor.visit(this, PROPERTY_HARVESTING_YEALDS, Collection.class, HarvestingYeald.class, harvestingYealds);
    }

    @Override
    public void setMoisturePercent(Double moisturePercent) {
        this.moisturePercent = moisturePercent;
    }

    @Override
    public Double getMoisturePercent() {
        Double result = this.moisturePercent;
        return result;
    }

    @Override
    public void setExportedWaste(boolean exportedWaste) {
        this.exportedWaste = exportedWaste;
    }

    @Override
    public boolean isExportedWaste() {
        boolean result = this.exportedWaste;
        return result;
    }

    @Override
    public void addHarvestingYealds(HarvestingYeald harvestingYealds) {
        if (this.harvestingYealds == null) {
            this.harvestingYealds = new LinkedList<HarvestingYeald>();
        }
        this.harvestingYealds.add(harvestingYealds);
    }

    @Override
    public void addAllHarvestingYealds(Iterable<HarvestingYeald> harvestingYealds) {
        if (harvestingYealds == null) {
            return;
        }
        for (HarvestingYeald item : harvestingYealds) {
            addHarvestingYealds(item);
        }
    }

    @Override
    public void setHarvestingYealds(Collection<HarvestingYeald> harvestingYealds) {
        this.harvestingYealds = harvestingYealds;
    }

    @Override
    public void removeHarvestingYealds(HarvestingYeald harvestingYealds) {
        if (this.harvestingYealds == null || !this.harvestingYealds.remove(harvestingYealds)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearHarvestingYealds() {
        if (this.harvestingYealds == null) {
            return;
        }
        this.harvestingYealds.clear();
    }

    @Override
    public Collection<HarvestingYeald> getHarvestingYealds() {
        return harvestingYealds;
    }

    @Override
    public HarvestingYeald getHarvestingYealdsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(harvestingYealds, topiaId);
    }

    @Override
    public Collection<String> getHarvestingYealdsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.action.HarvestingYeald> tmp = getHarvestingYealds();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeHarvestingYealds() {
        if (harvestingYealds == null) {
            return 0;
        }
        return harvestingYealds.size();
    }

    @Override
    public boolean isHarvestingYealdsEmpty() {
        int size = sizeHarvestingYealds();
        return size == 0;
    }

    @Override
    public boolean isHarvestingYealdsNotEmpty() {
        boolean empty = isHarvestingYealdsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsHarvestingYealds(HarvestingYeald harvestingYealds) {
        boolean contains = this.harvestingYealds !=null && this.harvestingYealds.contains(harvestingYealds);
        return contains;
    }

} //HarvestingActionAbstract
