package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class ZoneAbstract extends AbstractTopiaEntity implements Zone {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : area
     */
    protected double area;

    /**
     * Nom de l'attribut en BD : latitude
     */
    protected Double latitude;

    /**
     * Nom de l'attribut en BD : longitude
     */
    protected Double longitude;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : lineage
     */
    protected Collection<String> lineage;

    /**
     * Nom de l'attribut en BD : type
     */
    protected ZoneType type;

    /**
     * Nom de l'attribut en BD : plot
     */
    protected Plot plot;

    private static final long serialVersionUID = 3702634420704196153L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_AREA, double.class, area);
        visitor.visit(this, PROPERTY_LATITUDE, Double.class, latitude);
        visitor.visit(this, PROPERTY_LONGITUDE, Double.class, longitude);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_LINEAGE, Collection.class, String.class, lineage);
        visitor.visit(this, PROPERTY_TYPE, ZoneType.class, type);
        visitor.visit(this, PROPERTY_PLOT, Plot.class, plot);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setArea(double area) {
        this.area = area;
    }

    @Override
    public double getArea() {
        double result = this.area;
        return result;
    }

    @Override
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public Double getLatitude() {
        Double result = this.latitude;
        return result;
    }

    @Override
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getLongitude() {
        Double result = this.longitude;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void addLineage(String lineage) {
        if (this.lineage == null) {
            this.lineage = new LinkedList<String>();
        }
        this.lineage.add(lineage);
    }

    @Override
    public void addAllLineage(Iterable<String> lineage) {
        if (lineage == null) {
            return;
        }
        for (String item : lineage) {
            addLineage(item);
        }
    }

    @Override
    public void setLineage(Collection<String> lineage) {
        this.lineage = lineage;
    }

    @Override
    public void removeLineage(String lineage) {
        if (this.lineage == null || !this.lineage.remove(lineage)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearLineage() {
        if (this.lineage == null) {
            return;
        }
        this.lineage.clear();
    }

    @Override
    public Collection<String> getLineage() {
        return lineage;
    }

    @Override
    public int sizeLineage() {
        if (lineage == null) {
            return 0;
        }
        return lineage.size();
    }

    @Override
    public boolean isLineageEmpty() {
        int size = sizeLineage();
        return size == 0;
    }

    @Override
    public boolean isLineageNotEmpty() {
        boolean empty = isLineageEmpty();
        return ! empty;
    }

    @Override
    public boolean containsLineage(String lineage) {
        boolean contains = this.lineage !=null && this.lineage.contains(lineage);
        return contains;
    }

    @Override
    public void setType(ZoneType type) {
        this.type = type;
    }

    @Override
    public ZoneType getType() {
        ZoneType result = this.type;
        return result;
    }

    @Override
    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    @Override
    public Plot getPlot() {
        Plot result = this.plot;
        return result;
    }

} //ZoneAbstract
