package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class ToolsCouplingAbstract extends AbstractTopiaEntity implements ToolsCoupling {

    /**
     * Nom de l'attribut en BD : toolsCouplingName
     */
    protected String toolsCouplingName;

    /**
     * Nom de l'attribut en BD : workforce
     */
    protected Integer workforce;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : validated
     */
    protected boolean validated;

    /**
     * Nom de l'attribut en BD : workRate
     */
    protected Double workRate;

    /**
     * Nom de l'attribut en BD : transitVolume
     */
    protected Double transitVolume;

    /**
     * Nom de l'attribut en BD : manualIntervention
     */
    protected boolean manualIntervention;

    /**
     * Nom de l'attribut en BD : tractor
     */
    protected Equipment tractor;

    /**
     * Nom de l'attribut en BD : domain
     */
    protected Domain domain;

    /**
     * Nom de l'attribut en BD : equipments
     */
    protected Collection<Equipment> equipments;

    /**
     * Nom de l'attribut en BD : mainsActions
     */
    protected Collection<RefInterventionAgrosystTravailEDI> mainsActions;

    /**
     * Nom de l'attribut en BD : workRateUnit
     */
    protected MaterielWorkRateUnit workRateUnit;

    private static final long serialVersionUID = 7149517401404749874L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_TOOLS_COUPLING_NAME, String.class, toolsCouplingName);
        visitor.visit(this, PROPERTY_WORKFORCE, Integer.class, workforce);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_VALIDATED, boolean.class, validated);
        visitor.visit(this, PROPERTY_WORK_RATE, Double.class, workRate);
        visitor.visit(this, PROPERTY_TRANSIT_VOLUME, Double.class, transitVolume);
        visitor.visit(this, PROPERTY_MANUAL_INTERVENTION, boolean.class, manualIntervention);
        visitor.visit(this, PROPERTY_TRACTOR, Equipment.class, tractor);
        visitor.visit(this, PROPERTY_DOMAIN, Domain.class, domain);
        visitor.visit(this, PROPERTY_EQUIPMENTS, Collection.class, Equipment.class, equipments);
        visitor.visit(this, PROPERTY_MAINS_ACTIONS, Collection.class, RefInterventionAgrosystTravailEDI.class, mainsActions);
        visitor.visit(this, PROPERTY_WORK_RATE_UNIT, MaterielWorkRateUnit.class, workRateUnit);
    }

    @Override
    public void setToolsCouplingName(String toolsCouplingName) {
        this.toolsCouplingName = toolsCouplingName;
    }

    @Override
    public String getToolsCouplingName() {
        String result = this.toolsCouplingName;
        return result;
    }

    @Override
    public void setWorkforce(Integer workforce) {
        this.workforce = workforce;
    }

    @Override
    public Integer getWorkforce() {
        Integer result = this.workforce;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public boolean isValidated() {
        boolean result = this.validated;
        return result;
    }

    @Override
    public void setWorkRate(Double workRate) {
        this.workRate = workRate;
    }

    @Override
    public Double getWorkRate() {
        Double result = this.workRate;
        return result;
    }

    @Override
    public void setTransitVolume(Double transitVolume) {
        this.transitVolume = transitVolume;
    }

    @Override
    public Double getTransitVolume() {
        Double result = this.transitVolume;
        return result;
    }

    @Override
    public void setManualIntervention(boolean manualIntervention) {
        this.manualIntervention = manualIntervention;
    }

    @Override
    public boolean isManualIntervention() {
        boolean result = this.manualIntervention;
        return result;
    }

    @Override
    public void setTractor(Equipment tractor) {
        this.tractor = tractor;
    }

    @Override
    public Equipment getTractor() {
        Equipment result = this.tractor;
        return result;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Domain getDomain() {
        Domain result = this.domain;
        return result;
    }

    @Override
    public void addEquipments(Equipment equipments) {
        if (this.equipments == null) {
            this.equipments = new LinkedList<Equipment>();
        }
        this.equipments.add(equipments);
    }

    @Override
    public void addAllEquipments(Iterable<Equipment> equipments) {
        if (equipments == null) {
            return;
        }
        for (Equipment item : equipments) {
            addEquipments(item);
        }
    }

    @Override
    public void setEquipments(Collection<Equipment> equipments) {
        this.equipments = equipments;
    }

    @Override
    public void removeEquipments(Equipment equipments) {
        if (this.equipments == null || !this.equipments.remove(equipments)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearEquipments() {
        if (this.equipments == null) {
            return;
        }
        this.equipments.clear();
    }

    @Override
    public Collection<Equipment> getEquipments() {
        return equipments;
    }

    @Override
    public Equipment getEquipmentsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(equipments, topiaId);
    }

    @Override
    public Collection<String> getEquipmentsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Equipment> tmp = getEquipments();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeEquipments() {
        if (equipments == null) {
            return 0;
        }
        return equipments.size();
    }

    @Override
    public boolean isEquipmentsEmpty() {
        int size = sizeEquipments();
        return size == 0;
    }

    @Override
    public boolean isEquipmentsNotEmpty() {
        boolean empty = isEquipmentsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsEquipments(Equipment equipments) {
        boolean contains = this.equipments !=null && this.equipments.contains(equipments);
        return contains;
    }

    @Override
    public void addMainsActions(RefInterventionAgrosystTravailEDI mainsActions) {
        if (this.mainsActions == null) {
            this.mainsActions = new LinkedList<RefInterventionAgrosystTravailEDI>();
        }
        this.mainsActions.add(mainsActions);
    }

    @Override
    public void addAllMainsActions(Iterable<RefInterventionAgrosystTravailEDI> mainsActions) {
        if (mainsActions == null) {
            return;
        }
        for (RefInterventionAgrosystTravailEDI item : mainsActions) {
            addMainsActions(item);
        }
    }

    @Override
    public void setMainsActions(Collection<RefInterventionAgrosystTravailEDI> mainsActions) {
        this.mainsActions = mainsActions;
    }

    @Override
    public void removeMainsActions(RefInterventionAgrosystTravailEDI mainsActions) {
        if (this.mainsActions == null || !this.mainsActions.remove(mainsActions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearMainsActions() {
        if (this.mainsActions == null) {
            return;
        }
        this.mainsActions.clear();
    }

    @Override
    public Collection<RefInterventionAgrosystTravailEDI> getMainsActions() {
        return mainsActions;
    }

    @Override
    public RefInterventionAgrosystTravailEDI getMainsActionsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(mainsActions, topiaId);
    }

    @Override
    public Collection<String> getMainsActionsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI> tmp = getMainsActions();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMainsActions() {
        if (mainsActions == null) {
            return 0;
        }
        return mainsActions.size();
    }

    @Override
    public boolean isMainsActionsEmpty() {
        int size = sizeMainsActions();
        return size == 0;
    }

    @Override
    public boolean isMainsActionsNotEmpty() {
        boolean empty = isMainsActionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMainsActions(RefInterventionAgrosystTravailEDI mainsActions) {
        boolean contains = this.mainsActions !=null && this.mainsActions.contains(mainsActions);
        return contains;
    }

    @Override
    public void setWorkRateUnit(MaterielWorkRateUnit workRateUnit) {
        this.workRateUnit = workRateUnit;
    }

    @Override
    public MaterielWorkRateUnit getWorkRateUnit() {
        MaterielWorkRateUnit result = this.workRateUnit;
        return result;
    }

} //ToolsCouplingAbstract
