package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class PlotAbstract extends BasicPlotImpl implements Plot {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : validated
     */
    protected boolean validated;

    /**
     * Nom de l'attribut en BD : deletedZones
     */
    protected boolean deletedZones;

    /**
     * Nom de l'attribut en BD : lineage
     */
    protected Collection<String> lineage;

    /**
     * Nom de l'attribut en BD : eDaplosIssuerId
     */
    protected String eDaplosIssuerId;

    /**
     * Nom de l'attribut en BD : domain
     */
    protected Domain domain;

    /**
     * Nom de l'attribut en BD : growingSystem
     */
    protected GrowingSystem growingSystem;

    /**
     * Nom de l'attribut en BD : ground
     */
    protected Ground ground;

    private static final long serialVersionUID = 7075770982538032696L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_VALIDATED, boolean.class, validated);
        visitor.visit(this, PROPERTY_DELETED_ZONES, boolean.class, deletedZones);
        visitor.visit(this, PROPERTY_LINEAGE, Collection.class, String.class, lineage);
        visitor.visit(this, PROPERTY_E_DAPLOS_ISSUER_ID, String.class, eDaplosIssuerId);
        visitor.visit(this, PROPERTY_DOMAIN, Domain.class, domain);
        visitor.visit(this, PROPERTY_GROWING_SYSTEM, GrowingSystem.class, growingSystem);
        visitor.visit(this, PROPERTY_GROUND, Ground.class, ground);
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public boolean isValidated() {
        boolean result = this.validated;
        return result;
    }

    @Override
    public void setDeletedZones(boolean deletedZones) {
        this.deletedZones = deletedZones;
    }

    @Override
    public boolean isDeletedZones() {
        boolean result = this.deletedZones;
        return result;
    }

    @Override
    public void addLineage(String lineage) {
        if (this.lineage == null) {
            this.lineage = new LinkedList<String>();
        }
        this.lineage.add(lineage);
    }

    @Override
    public void addAllLineage(Iterable<String> lineage) {
        if (lineage == null) {
            return;
        }
        for (String item : lineage) {
            addLineage(item);
        }
    }

    @Override
    public void setLineage(Collection<String> lineage) {
        this.lineage = lineage;
    }

    @Override
    public void removeLineage(String lineage) {
        if (this.lineage == null || !this.lineage.remove(lineage)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearLineage() {
        if (this.lineage == null) {
            return;
        }
        this.lineage.clear();
    }

    @Override
    public Collection<String> getLineage() {
        return lineage;
    }

    @Override
    public int sizeLineage() {
        if (lineage == null) {
            return 0;
        }
        return lineage.size();
    }

    @Override
    public boolean isLineageEmpty() {
        int size = sizeLineage();
        return size == 0;
    }

    @Override
    public boolean isLineageNotEmpty() {
        boolean empty = isLineageEmpty();
        return ! empty;
    }

    @Override
    public boolean containsLineage(String lineage) {
        boolean contains = this.lineage !=null && this.lineage.contains(lineage);
        return contains;
    }

    @Override
    public void seteDaplosIssuerId(String eDaplosIssuerId) {
        this.eDaplosIssuerId = eDaplosIssuerId;
    }

    @Override
    public String geteDaplosIssuerId() {
        String result = this.eDaplosIssuerId;
        return result;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Domain getDomain() {
        Domain result = this.domain;
        return result;
    }

    @Override
    public void setGrowingSystem(GrowingSystem growingSystem) {
        this.growingSystem = growingSystem;
    }

    @Override
    public GrowingSystem getGrowingSystem() {
        GrowingSystem result = this.growingSystem;
        return result;
    }

    @Override
    public void setGround(Ground ground) {
        this.ground = ground;
    }

    @Override
    public Ground getGround() {
        Ground result = this.ground;
        return result;
    }

} //PlotAbstract
