package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class NetworkAbstract extends AbstractTopiaEntity implements Network {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : managers
     */
    protected Collection<NetworkManager> managers;

    /**
     * Nom de l'attribut en BD : parents
     */
    protected Collection<Network> parents;

    private static final long serialVersionUID = 3846697926599926834L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_MANAGERS, Collection.class, NetworkManager.class, managers);
        visitor.visit(this, PROPERTY_PARENTS, Collection.class, Network.class, parents);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String result = this.description;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void addManagers(NetworkManager managers) {
        if (this.managers == null) {
            this.managers = new LinkedList<NetworkManager>();
        }
        this.managers.add(managers);
    }

    @Override
    public void addAllManagers(Iterable<NetworkManager> managers) {
        if (managers == null) {
            return;
        }
        for (NetworkManager item : managers) {
            addManagers(item);
        }
    }

    @Override
    public void setManagers(Collection<NetworkManager> managers) {
        this.managers = managers;
    }

    @Override
    public void removeManagers(NetworkManager managers) {
        if (this.managers == null || !this.managers.remove(managers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearManagers() {
        if (this.managers == null) {
            return;
        }
        this.managers.clear();
    }

    @Override
    public Collection<NetworkManager> getManagers() {
        return managers;
    }

    @Override
    public NetworkManager getManagersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(managers, topiaId);
    }

    @Override
    public Collection<String> getManagersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.NetworkManager> tmp = getManagers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeManagers() {
        if (managers == null) {
            return 0;
        }
        return managers.size();
    }

    @Override
    public boolean isManagersEmpty() {
        int size = sizeManagers();
        return size == 0;
    }

    @Override
    public boolean isManagersNotEmpty() {
        boolean empty = isManagersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsManagers(NetworkManager managers) {
        boolean contains = this.managers !=null && this.managers.contains(managers);
        return contains;
    }

    @Override
    public void addParents(Network parents) {
        if (this.parents == null) {
            this.parents = new LinkedList<Network>();
        }
        this.parents.add(parents);
    }

    @Override
    public void addAllParents(Iterable<Network> parents) {
        if (parents == null) {
            return;
        }
        for (Network item : parents) {
            addParents(item);
        }
    }

    @Override
    public void setParents(Collection<Network> parents) {
        this.parents = parents;
    }

    @Override
    public void removeParents(Network parents) {
        if (this.parents == null || !this.parents.remove(parents)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearParents() {
        if (this.parents == null) {
            return;
        }
        this.parents.clear();
    }

    @Override
    public Collection<Network> getParents() {
        return parents;
    }

    @Override
    public Network getParentsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(parents, topiaId);
    }

    @Override
    public Collection<String> getParentsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Network> tmp = getParents();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeParents() {
        if (parents == null) {
            return 0;
        }
        return parents.size();
    }

    @Override
    public boolean isParentsEmpty() {
        int size = sizeParents();
        return size == 0;
    }

    @Override
    public boolean isParentsNotEmpty() {
        boolean empty = isParentsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsParents(Network parents) {
        boolean contains = this.parents !=null && this.parents.contains(parents);
        return contains;
    }

} //NetworkAbstract
