package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class GrowingSystemAbstract extends AbstractTopiaEntity implements GrowingSystem {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : dephyNumber
     */
    protected String dephyNumber;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : affectedAreaRate
     */
    protected Double affectedAreaRate;

    /**
     * Nom de l'attribut en BD : affectedWorkForceRate
     */
    protected Integer affectedWorkForceRate;

    /**
     * Nom de l'attribut en BD : domainsToolsUsageRate
     */
    protected Integer domainsToolsUsageRate;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : startingDate
     */
    protected Date startingDate;

    /**
     * Nom de l'attribut en BD : endingDate
     */
    protected Date endingDate;

    /**
     * Nom de l'attribut en BD : endActivityComment
     */
    protected String endActivityComment;

    /**
     * Nom de l'attribut en BD : conductModeComment
     */
    protected String conductModeComment;

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : plotOutputReason
     */
    protected String plotOutputReason;

    /**
     * Nom de l'attribut en BD : validated
     */
    protected boolean validated;

    /**
     * Nom de l'attribut en BD : validationDate
     */
    protected Date validationDate;

    /**
     * Nom de l'attribut en BD : updateDate
     */
    protected Date updateDate;

    /**
     * Nom de l'attribut en BD : cycleManagementComment
     */
    protected String cycleManagementComment;

    /**
     * Nom de l'attribut en BD : cultureManagementComment
     */
    protected String cultureManagementComment;

    /**
     * Nom de l'attribut en BD : groundWorkComment
     */
    protected String groundWorkComment;

    /**
     * Nom de l'attribut en BD : parcelsManagementComment
     */
    protected String parcelsManagementComment;

    /**
     * Nom de l'attribut en BD : networks
     */
    protected Collection<Network> networks;

    /**
     * Nom de l'attribut en BD : sector
     */
    protected Sector sector;

    /**
     * Nom de l'attribut en BD : growingPlan
     */
    protected GrowingPlan growingPlan;

    /**
     * Nom de l'attribut en BD : typeAgriculture
     */
    protected RefTypeAgriculture typeAgriculture;

    /**
     * Nom de l'attribut en BD : categoryStrategy
     */
    protected CategoryStrategy categoryStrategy;

    /**
     * Nom de l'attribut en BD : characteristics
     */
    protected Collection<RefTraitSdC> characteristics;

    private static final long serialVersionUID = 7292226321860015457L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DEPHY_NUMBER, String.class, dephyNumber);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_AFFECTED_AREA_RATE, Double.class, affectedAreaRate);
        visitor.visit(this, PROPERTY_AFFECTED_WORK_FORCE_RATE, Integer.class, affectedWorkForceRate);
        visitor.visit(this, PROPERTY_DOMAINS_TOOLS_USAGE_RATE, Integer.class, domainsToolsUsageRate);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_STARTING_DATE, Date.class, startingDate);
        visitor.visit(this, PROPERTY_ENDING_DATE, Date.class, endingDate);
        visitor.visit(this, PROPERTY_END_ACTIVITY_COMMENT, String.class, endActivityComment);
        visitor.visit(this, PROPERTY_CONDUCT_MODE_COMMENT, String.class, conductModeComment);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_PLOT_OUTPUT_REASON, String.class, plotOutputReason);
        visitor.visit(this, PROPERTY_VALIDATED, boolean.class, validated);
        visitor.visit(this, PROPERTY_VALIDATION_DATE, Date.class, validationDate);
        visitor.visit(this, PROPERTY_UPDATE_DATE, Date.class, updateDate);
        visitor.visit(this, PROPERTY_CYCLE_MANAGEMENT_COMMENT, String.class, cycleManagementComment);
        visitor.visit(this, PROPERTY_CULTURE_MANAGEMENT_COMMENT, String.class, cultureManagementComment);
        visitor.visit(this, PROPERTY_GROUND_WORK_COMMENT, String.class, groundWorkComment);
        visitor.visit(this, PROPERTY_PARCELS_MANAGEMENT_COMMENT, String.class, parcelsManagementComment);
        visitor.visit(this, PROPERTY_NETWORKS, Collection.class, Network.class, networks);
        visitor.visit(this, PROPERTY_SECTOR, Sector.class, sector);
        visitor.visit(this, PROPERTY_GROWING_PLAN, GrowingPlan.class, growingPlan);
        visitor.visit(this, PROPERTY_TYPE_AGRICULTURE, RefTypeAgriculture.class, typeAgriculture);
        visitor.visit(this, PROPERTY_CATEGORY_STRATEGY, CategoryStrategy.class, categoryStrategy);
        visitor.visit(this, PROPERTY_CHARACTERISTICS, Collection.class, RefTraitSdC.class, characteristics);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setDephyNumber(String dephyNumber) {
        this.dephyNumber = dephyNumber;
    }

    @Override
    public String getDephyNumber() {
        String result = this.dephyNumber;
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String result = this.description;
        return result;
    }

    @Override
    public void setAffectedAreaRate(Double affectedAreaRate) {
        this.affectedAreaRate = affectedAreaRate;
    }

    @Override
    public Double getAffectedAreaRate() {
        Double result = this.affectedAreaRate;
        return result;
    }

    @Override
    public void setAffectedWorkForceRate(Integer affectedWorkForceRate) {
        this.affectedWorkForceRate = affectedWorkForceRate;
    }

    @Override
    public Integer getAffectedWorkForceRate() {
        Integer result = this.affectedWorkForceRate;
        return result;
    }

    @Override
    public void setDomainsToolsUsageRate(Integer domainsToolsUsageRate) {
        this.domainsToolsUsageRate = domainsToolsUsageRate;
    }

    @Override
    public Integer getDomainsToolsUsageRate() {
        Integer result = this.domainsToolsUsageRate;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    @Override
    public Date getStartingDate() {
        Date result = this.startingDate;
        return result;
    }

    @Override
    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    @Override
    public Date getEndingDate() {
        Date result = this.endingDate;
        return result;
    }

    @Override
    public void setEndActivityComment(String endActivityComment) {
        this.endActivityComment = endActivityComment;
    }

    @Override
    public String getEndActivityComment() {
        String result = this.endActivityComment;
        return result;
    }

    @Override
    public void setConductModeComment(String conductModeComment) {
        this.conductModeComment = conductModeComment;
    }

    @Override
    public String getConductModeComment() {
        String result = this.conductModeComment;
        return result;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void setPlotOutputReason(String plotOutputReason) {
        this.plotOutputReason = plotOutputReason;
    }

    @Override
    public String getPlotOutputReason() {
        String result = this.plotOutputReason;
        return result;
    }

    @Override
    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public boolean isValidated() {
        boolean result = this.validated;
        return result;
    }

    @Override
    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    @Override
    public Date getValidationDate() {
        Date result = this.validationDate;
        return result;
    }

    @Override
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public Date getUpdateDate() {
        Date result = this.updateDate;
        return result;
    }

    @Override
    public void setCycleManagementComment(String cycleManagementComment) {
        this.cycleManagementComment = cycleManagementComment;
    }

    @Override
    public String getCycleManagementComment() {
        String result = this.cycleManagementComment;
        return result;
    }

    @Override
    public void setCultureManagementComment(String cultureManagementComment) {
        this.cultureManagementComment = cultureManagementComment;
    }

    @Override
    public String getCultureManagementComment() {
        String result = this.cultureManagementComment;
        return result;
    }

    @Override
    public void setGroundWorkComment(String groundWorkComment) {
        this.groundWorkComment = groundWorkComment;
    }

    @Override
    public String getGroundWorkComment() {
        String result = this.groundWorkComment;
        return result;
    }

    @Override
    public void setParcelsManagementComment(String parcelsManagementComment) {
        this.parcelsManagementComment = parcelsManagementComment;
    }

    @Override
    public String getParcelsManagementComment() {
        String result = this.parcelsManagementComment;
        return result;
    }

    @Override
    public void addNetworks(Network networks) {
        if (this.networks == null) {
            this.networks = new LinkedList<Network>();
        }
        this.networks.add(networks);
    }

    @Override
    public void addAllNetworks(Iterable<Network> networks) {
        if (networks == null) {
            return;
        }
        for (Network item : networks) {
            addNetworks(item);
        }
    }

    @Override
    public void setNetworks(Collection<Network> networks) {
        this.networks = networks;
    }

    @Override
    public void removeNetworks(Network networks) {
        if (this.networks == null || !this.networks.remove(networks)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearNetworks() {
        if (this.networks == null) {
            return;
        }
        this.networks.clear();
    }

    @Override
    public Collection<Network> getNetworks() {
        return networks;
    }

    @Override
    public Network getNetworksByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(networks, topiaId);
    }

    @Override
    public Collection<String> getNetworksTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.Network> tmp = getNetworks();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeNetworks() {
        if (networks == null) {
            return 0;
        }
        return networks.size();
    }

    @Override
    public boolean isNetworksEmpty() {
        int size = sizeNetworks();
        return size == 0;
    }

    @Override
    public boolean isNetworksNotEmpty() {
        boolean empty = isNetworksEmpty();
        return ! empty;
    }

    @Override
    public boolean containsNetworks(Network networks) {
        boolean contains = this.networks !=null && this.networks.contains(networks);
        return contains;
    }

    @Override
    public void setSector(Sector sector) {
        this.sector = sector;
    }

    @Override
    public Sector getSector() {
        Sector result = this.sector;
        return result;
    }

    @Override
    public void setGrowingPlan(GrowingPlan growingPlan) {
        this.growingPlan = growingPlan;
    }

    @Override
    public GrowingPlan getGrowingPlan() {
        GrowingPlan result = this.growingPlan;
        return result;
    }

    @Override
    public void setTypeAgriculture(RefTypeAgriculture typeAgriculture) {
        this.typeAgriculture = typeAgriculture;
    }

    @Override
    public RefTypeAgriculture getTypeAgriculture() {
        RefTypeAgriculture result = this.typeAgriculture;
        return result;
    }

    @Override
    public void setCategoryStrategy(CategoryStrategy categoryStrategy) {
        this.categoryStrategy = categoryStrategy;
    }

    @Override
    public CategoryStrategy getCategoryStrategy() {
        CategoryStrategy result = this.categoryStrategy;
        return result;
    }

    @Override
    public void addCharacteristics(RefTraitSdC characteristics) {
        if (this.characteristics == null) {
            this.characteristics = new LinkedList<RefTraitSdC>();
        }
        this.characteristics.add(characteristics);
    }

    @Override
    public void addAllCharacteristics(Iterable<RefTraitSdC> characteristics) {
        if (characteristics == null) {
            return;
        }
        for (RefTraitSdC item : characteristics) {
            addCharacteristics(item);
        }
    }

    @Override
    public void setCharacteristics(Collection<RefTraitSdC> characteristics) {
        this.characteristics = characteristics;
    }

    @Override
    public void removeCharacteristics(RefTraitSdC characteristics) {
        if (this.characteristics == null || !this.characteristics.remove(characteristics)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearCharacteristics() {
        if (this.characteristics == null) {
            return;
        }
        this.characteristics.clear();
    }

    @Override
    public Collection<RefTraitSdC> getCharacteristics() {
        return characteristics;
    }

    @Override
    public RefTraitSdC getCharacteristicsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(characteristics, topiaId);
    }

    @Override
    public Collection<String> getCharacteristicsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.referential.RefTraitSdC> tmp = getCharacteristics();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeCharacteristics() {
        if (characteristics == null) {
            return 0;
        }
        return characteristics.size();
    }

    @Override
    public boolean isCharacteristicsEmpty() {
        int size = sizeCharacteristics();
        return size == 0;
    }

    @Override
    public boolean isCharacteristicsNotEmpty() {
        boolean empty = isCharacteristicsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsCharacteristics(RefTraitSdC characteristics) {
        boolean contains = this.characteristics !=null && this.characteristics.contains(characteristics);
        return contains;
    }

} //GrowingSystemAbstract
