package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Entities.java 4795 2015-02-17 06:32:47Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/entities/Entities.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefVariete;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Entities {

    public static final Function<TopiaEntity, String> GET_TOPIA_ID = TopiaEntities.getTopiaIdFunction();

    public static final Function<String, String> ESCAPE_TOPIA_ID = new Function<String, String>() {
        @Override
        public String apply(String input) {
            int partsSeparatorIndex = input.indexOf('_');
            Preconditions.checkState(partsSeparatorIndex != -1, "The given id is not a TopiaId: " + input);
            String result = input.substring(0, partsSeparatorIndex).replaceAll("[.]", "-");
            result += input.substring(partsSeparatorIndex);
            return result;
        }
    };

    public static final Function<String, String> UNESCAPE_TOPIA_ID = new Function<String, String>() {
        @Override
        public String apply(String input) {
            int partsSeparatorIndex = input.lastIndexOf('_');
            String result;
            if (partsSeparatorIndex == -1 || StringUtils.startsWith(input, "new-node-")) {
                result = input;
            } else {
                result = input.substring(0, partsSeparatorIndex).replaceAll("[-]", ".");
                result += input.substring(partsSeparatorIndex);
            }
            return result;
        }
    };

    protected static final Set<Class<? extends TopiaEntity>> IGNORED_ABSTRACT_CLASSES = ImmutableSet.of(
            BasicPlot.class, AbstractAction.class, AbstractInput.class, PhytoProductInput.class, Measurement.class,
            PracticedCropCycle.class, RefMateriel.class, RefBioAgressor.class, RefVariete.class);

    protected static final Predicate<AgrosystEntityEnum> IS_ENTITY_AN_ABSTRACT_ENTITY = new Predicate<AgrosystEntityEnum>() {
        @Override
        public boolean apply(AgrosystEntityEnum input) {
            return !IGNORED_ABSTRACT_CLASSES.contains(input.getContract());
        }
    };

    public static Map<Class<? extends TopiaEntity>, Class<? extends TopiaEntity>> getAllAgrosystTypesAndImplementation() {
        Map<Class<? extends TopiaEntity>, Class<? extends TopiaEntity>> result = Maps.newHashMap();
        List<AgrosystEntityEnum> contracts = Arrays.asList(AgrosystEntityEnum.getContracts());
        Iterable<AgrosystEntityEnum> filtered = Iterables.filter(contracts, IS_ENTITY_AN_ABSTRACT_ENTITY);
        for (AgrosystEntityEnum entityEnum : filtered) {
            Class<? extends TopiaEntity> contract = entityEnum.getContract();
            Class<? extends TopiaEntity> implementation = entityEnum.getImplementation();
            result.put(contract, implementation);
        }
        return result;
    }

}
