package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class DomainAbstract extends AbstractTopiaEntity implements Domain {

    /**
     * Le nom
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Contact principal
     * Nom de l'attribut en BD : mainContact
     */
    protected String mainContact;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : campaign
     */
    protected int campaign;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Code de liaison des domaines dupliqués. (Initialisé avec le topiaId du premier domain dupliqué).
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : croppingPlanComment
     */
    protected String croppingPlanComment;

    /**
     * Nom de l'attribut en BD : otherActivitiesComment
     */
    protected String otherActivitiesComment;

    /**
     * Nom de l'attribut en BD : statusComment
     */
    protected String statusComment;

    /**
     * Nom de l'attribut en BD : partnersNumber
     */
    protected Integer partnersNumber;

    /**
     * Nom de l'attribut en BD : permanentEmployeesWorkForce
     */
    protected Double permanentEmployeesWorkForce;

    /**
     * Nom de l'attribut en BD : temporaryEmployeesWorkForce
     */
    protected Double temporaryEmployeesWorkForce;

    /**
     * Nom de l'attribut en BD : otherWorkForce
     */
    protected Double otherWorkForce;

    /**
     * Nom de l'attribut en BD : familyWorkForceWage
     */
    protected Integer familyWorkForceWage;

    /**
     * Nom de l'attribut en BD : wageCosts
     */
    protected Integer wageCosts;

    /**
     * Nom de l'attribut en BD : workforceComment
     */
    protected String workforceComment;

    /**
     * Nom de l'attribut en BD : cropsWorkForce
     */
    protected Double cropsWorkForce;

    /**
     * Nom de l'attribut en BD : orientation
     */
    protected String orientation;

    /**
     * Nom de l'attribut en BD : usedAgriculturalArea
     */
    protected Double usedAgriculturalArea;

    /**
     * Nom de l'attribut en BD : msaFee
     */
    protected Double msaFee;

    /**
     * Nom de l'attribut en BD : averageTenantFarming
     */
    protected Double averageTenantFarming;

    /**
     * Nom de l'attribut en BD : decoupledAssistance
     */
    protected Double decoupledAssistance;

    /**
     * Nom de l'attribut en BD : experimentalAgriculturalArea
     */
    protected Double experimentalAgriculturalArea;

    /**
     * Nom de l'attribut en BD : homogenizationExperimentalAgriculturalArea
     */
    protected Double homogenizationExperimentalAgriculturalArea;

    /**
     * Nom de l'attribut en BD : speciesToArea
     */
    protected String speciesToArea;

    /**
     * Nom de l'attribut en BD : siret
     */
    protected String siret;

    /**
     * Nom de l'attribut en BD : validationDate
     */
    protected Date validationDate;

    /**
     * Nom de l'attribut en BD : validated
     */
    protected boolean validated;

    /**
     * Nom de l'attribut en BD : updateDate
     */
    protected Date updateDate;

    /**
     * Nom de l'attribut en BD : type
     */
    protected DomainType type;

    /**
     * Nom de l'attribut en BD : location
     */
    protected RefLocation location;

    /**
     * Nom de l'attribut en BD : legalStatus
     */
    protected RefLegalStatus legalStatus;

    /**
     * Nom de l'attribut en BD : zoning
     */
    protected Zoning zoning;

    /**
     * Nom de l'attribut en BD : otex18
     */
    protected RefOTEX otex18;

    /**
     * Nom de l'attribut en BD : otex70
     */
    protected RefOTEX otex70;

    /**
     * Nom de l'attribut en BD : weatherStations
     */
    protected Collection<WeatherStation> weatherStations;

    /**
     * Nom de l'attribut en BD : defaultWeatherStation
     */
    protected WeatherStation defaultWeatherStation;

    private static final long serialVersionUID = 3559360371055802166L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_MAIN_CONTACT, String.class, mainContact);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_CAMPAIGN, int.class, campaign);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_COMMENT, String.class, croppingPlanComment);
        visitor.visit(this, PROPERTY_OTHER_ACTIVITIES_COMMENT, String.class, otherActivitiesComment);
        visitor.visit(this, PROPERTY_STATUS_COMMENT, String.class, statusComment);
        visitor.visit(this, PROPERTY_PARTNERS_NUMBER, Integer.class, partnersNumber);
        visitor.visit(this, PROPERTY_PERMANENT_EMPLOYEES_WORK_FORCE, Double.class, permanentEmployeesWorkForce);
        visitor.visit(this, PROPERTY_TEMPORARY_EMPLOYEES_WORK_FORCE, Double.class, temporaryEmployeesWorkForce);
        visitor.visit(this, PROPERTY_OTHER_WORK_FORCE, Double.class, otherWorkForce);
        visitor.visit(this, PROPERTY_FAMILY_WORK_FORCE_WAGE, Integer.class, familyWorkForceWage);
        visitor.visit(this, PROPERTY_WAGE_COSTS, Integer.class, wageCosts);
        visitor.visit(this, PROPERTY_WORKFORCE_COMMENT, String.class, workforceComment);
        visitor.visit(this, PROPERTY_CROPS_WORK_FORCE, Double.class, cropsWorkForce);
        visitor.visit(this, PROPERTY_ORIENTATION, String.class, orientation);
        visitor.visit(this, PROPERTY_USED_AGRICULTURAL_AREA, Double.class, usedAgriculturalArea);
        visitor.visit(this, PROPERTY_MSA_FEE, Double.class, msaFee);
        visitor.visit(this, PROPERTY_AVERAGE_TENANT_FARMING, Double.class, averageTenantFarming);
        visitor.visit(this, PROPERTY_DECOUPLED_ASSISTANCE, Double.class, decoupledAssistance);
        visitor.visit(this, PROPERTY_EXPERIMENTAL_AGRICULTURAL_AREA, Double.class, experimentalAgriculturalArea);
        visitor.visit(this, PROPERTY_HOMOGENIZATION_EXPERIMENTAL_AGRICULTURAL_AREA, Double.class, homogenizationExperimentalAgriculturalArea);
        visitor.visit(this, PROPERTY_SPECIES_TO_AREA, String.class, speciesToArea);
        visitor.visit(this, PROPERTY_SIRET, String.class, siret);
        visitor.visit(this, PROPERTY_VALIDATION_DATE, Date.class, validationDate);
        visitor.visit(this, PROPERTY_VALIDATED, boolean.class, validated);
        visitor.visit(this, PROPERTY_UPDATE_DATE, Date.class, updateDate);
        visitor.visit(this, PROPERTY_TYPE, DomainType.class, type);
        visitor.visit(this, PROPERTY_LOCATION, RefLocation.class, location);
        visitor.visit(this, PROPERTY_LEGAL_STATUS, RefLegalStatus.class, legalStatus);
        visitor.visit(this, PROPERTY_ZONING, Zoning.class, zoning);
        visitor.visit(this, PROPERTY_OTEX18, RefOTEX.class, otex18);
        visitor.visit(this, PROPERTY_OTEX70, RefOTEX.class, otex70);
        visitor.visit(this, PROPERTY_WEATHER_STATIONS, Collection.class, WeatherStation.class, weatherStations);
        visitor.visit(this, PROPERTY_DEFAULT_WEATHER_STATION, WeatherStation.class, defaultWeatherStation);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setMainContact(String mainContact) {
        this.mainContact = mainContact;
    }

    @Override
    public String getMainContact() {
        String result = this.mainContact;
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String result = this.description;
        return result;
    }

    @Override
    public void setCampaign(int campaign) {
        this.campaign = campaign;
    }

    @Override
    public int getCampaign() {
        int result = this.campaign;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void setCroppingPlanComment(String croppingPlanComment) {
        this.croppingPlanComment = croppingPlanComment;
    }

    @Override
    public String getCroppingPlanComment() {
        String result = this.croppingPlanComment;
        return result;
    }

    @Override
    public void setOtherActivitiesComment(String otherActivitiesComment) {
        this.otherActivitiesComment = otherActivitiesComment;
    }

    @Override
    public String getOtherActivitiesComment() {
        String result = this.otherActivitiesComment;
        return result;
    }

    @Override
    public void setStatusComment(String statusComment) {
        this.statusComment = statusComment;
    }

    @Override
    public String getStatusComment() {
        String result = this.statusComment;
        return result;
    }

    @Override
    public void setPartnersNumber(Integer partnersNumber) {
        this.partnersNumber = partnersNumber;
    }

    @Override
    public Integer getPartnersNumber() {
        Integer result = this.partnersNumber;
        return result;
    }

    @Override
    public void setPermanentEmployeesWorkForce(Double permanentEmployeesWorkForce) {
        this.permanentEmployeesWorkForce = permanentEmployeesWorkForce;
    }

    @Override
    public Double getPermanentEmployeesWorkForce() {
        Double result = this.permanentEmployeesWorkForce;
        return result;
    }

    @Override
    public void setTemporaryEmployeesWorkForce(Double temporaryEmployeesWorkForce) {
        this.temporaryEmployeesWorkForce = temporaryEmployeesWorkForce;
    }

    @Override
    public Double getTemporaryEmployeesWorkForce() {
        Double result = this.temporaryEmployeesWorkForce;
        return result;
    }

    @Override
    public void setOtherWorkForce(Double otherWorkForce) {
        this.otherWorkForce = otherWorkForce;
    }

    @Override
    public Double getOtherWorkForce() {
        Double result = this.otherWorkForce;
        return result;
    }

    @Override
    public void setFamilyWorkForceWage(Integer familyWorkForceWage) {
        this.familyWorkForceWage = familyWorkForceWage;
    }

    @Override
    public Integer getFamilyWorkForceWage() {
        Integer result = this.familyWorkForceWage;
        return result;
    }

    @Override
    public void setWageCosts(Integer wageCosts) {
        this.wageCosts = wageCosts;
    }

    @Override
    public Integer getWageCosts() {
        Integer result = this.wageCosts;
        return result;
    }

    @Override
    public void setWorkforceComment(String workforceComment) {
        this.workforceComment = workforceComment;
    }

    @Override
    public String getWorkforceComment() {
        String result = this.workforceComment;
        return result;
    }

    @Override
    public void setCropsWorkForce(Double cropsWorkForce) {
        this.cropsWorkForce = cropsWorkForce;
    }

    @Override
    public Double getCropsWorkForce() {
        Double result = this.cropsWorkForce;
        return result;
    }

    @Override
    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    @Override
    public String getOrientation() {
        String result = this.orientation;
        return result;
    }

    @Override
    public void setUsedAgriculturalArea(Double usedAgriculturalArea) {
        this.usedAgriculturalArea = usedAgriculturalArea;
    }

    @Override
    public Double getUsedAgriculturalArea() {
        Double result = this.usedAgriculturalArea;
        return result;
    }

    @Override
    public void setMsaFee(Double msaFee) {
        this.msaFee = msaFee;
    }

    @Override
    public Double getMsaFee() {
        Double result = this.msaFee;
        return result;
    }

    @Override
    public void setAverageTenantFarming(Double averageTenantFarming) {
        this.averageTenantFarming = averageTenantFarming;
    }

    @Override
    public Double getAverageTenantFarming() {
        Double result = this.averageTenantFarming;
        return result;
    }

    @Override
    public void setDecoupledAssistance(Double decoupledAssistance) {
        this.decoupledAssistance = decoupledAssistance;
    }

    @Override
    public Double getDecoupledAssistance() {
        Double result = this.decoupledAssistance;
        return result;
    }

    @Override
    public void setExperimentalAgriculturalArea(Double experimentalAgriculturalArea) {
        this.experimentalAgriculturalArea = experimentalAgriculturalArea;
    }

    @Override
    public Double getExperimentalAgriculturalArea() {
        Double result = this.experimentalAgriculturalArea;
        return result;
    }

    @Override
    public void setHomogenizationExperimentalAgriculturalArea(Double homogenizationExperimentalAgriculturalArea) {
        this.homogenizationExperimentalAgriculturalArea = homogenizationExperimentalAgriculturalArea;
    }

    @Override
    public Double getHomogenizationExperimentalAgriculturalArea() {
        Double result = this.homogenizationExperimentalAgriculturalArea;
        return result;
    }

    @Override
    public void setSpeciesToArea(String speciesToArea) {
        this.speciesToArea = speciesToArea;
    }

    @Override
    public String getSpeciesToArea() {
        String result = this.speciesToArea;
        return result;
    }

    @Override
    public void setSiret(String siret) {
        this.siret = siret;
    }

    @Override
    public String getSiret() {
        String result = this.siret;
        return result;
    }

    @Override
    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    @Override
    public Date getValidationDate() {
        Date result = this.validationDate;
        return result;
    }

    @Override
    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public boolean isValidated() {
        boolean result = this.validated;
        return result;
    }

    @Override
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public Date getUpdateDate() {
        Date result = this.updateDate;
        return result;
    }

    @Override
    public void setType(DomainType type) {
        this.type = type;
    }

    @Override
    public DomainType getType() {
        DomainType result = this.type;
        return result;
    }

    @Override
    public void setLocation(RefLocation location) {
        this.location = location;
    }

    @Override
    public RefLocation getLocation() {
        RefLocation result = this.location;
        return result;
    }

    @Override
    public void setLegalStatus(RefLegalStatus legalStatus) {
        this.legalStatus = legalStatus;
    }

    @Override
    public RefLegalStatus getLegalStatus() {
        RefLegalStatus result = this.legalStatus;
        return result;
    }

    @Override
    public void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    @Override
    public Zoning getZoning() {
        Zoning result = this.zoning;
        return result;
    }

    @Override
    public void setOtex18(RefOTEX otex18) {
        this.otex18 = otex18;
    }

    @Override
    public RefOTEX getOtex18() {
        RefOTEX result = this.otex18;
        return result;
    }

    @Override
    public void setOtex70(RefOTEX otex70) {
        this.otex70 = otex70;
    }

    @Override
    public RefOTEX getOtex70() {
        RefOTEX result = this.otex70;
        return result;
    }

    @Override
    public void addWeatherStations(WeatherStation weatherStations) {
        if (this.weatherStations == null) {
            this.weatherStations = new LinkedList<WeatherStation>();
        }
        this.weatherStations.add(weatherStations);
    }

    @Override
    public void addAllWeatherStations(Iterable<WeatherStation> weatherStations) {
        if (weatherStations == null) {
            return;
        }
        for (WeatherStation item : weatherStations) {
            addWeatherStations(item);
        }
    }

    @Override
    public void setWeatherStations(Collection<WeatherStation> weatherStations) {
        this.weatherStations = weatherStations;
    }

    @Override
    public void removeWeatherStations(WeatherStation weatherStations) {
        if (this.weatherStations == null || !this.weatherStations.remove(weatherStations)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearWeatherStations() {
        if (this.weatherStations == null) {
            return;
        }
        this.weatherStations.clear();
    }

    @Override
    public Collection<WeatherStation> getWeatherStations() {
        return weatherStations;
    }

    @Override
    public WeatherStation getWeatherStationsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(weatherStations, topiaId);
    }

    @Override
    public Collection<String> getWeatherStationsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.WeatherStation> tmp = getWeatherStations();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWeatherStations() {
        if (weatherStations == null) {
            return 0;
        }
        return weatherStations.size();
    }

    @Override
    public boolean isWeatherStationsEmpty() {
        int size = sizeWeatherStations();
        return size == 0;
    }

    @Override
    public boolean isWeatherStationsNotEmpty() {
        boolean empty = isWeatherStationsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWeatherStations(WeatherStation weatherStations) {
        boolean contains = this.weatherStations !=null && this.weatherStations.contains(weatherStations);
        return contains;
    }

    @Override
    public void setDefaultWeatherStation(WeatherStation defaultWeatherStation) {
        this.defaultWeatherStation = defaultWeatherStation;
    }

    @Override
    public WeatherStation getDefaultWeatherStation() {
        WeatherStation result = this.defaultWeatherStation;
        return result;
    }

} //DomainAbstract
