package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class CroppingPlanEntryAbstract extends AbstractTopiaEntity implements CroppingPlanEntry {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : sellingPrice
     */
    protected Double sellingPrice;

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : validated
     */
    protected boolean validated;

    /**
     * Nom de l'attribut en BD : domain
     */
    protected Domain domain;

    /**
     * Nom de l'attribut en BD : croppingPlanSpecies
     */
    protected List<CroppingPlanSpecies> croppingPlanSpecies;

    /**
     * Nom de l'attribut en BD : type
     */
    protected CroppingEntryType type;

    private static final long serialVersionUID = 7004846967859012147L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_SELLING_PRICE, Double.class, sellingPrice);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_VALIDATED, boolean.class, validated);
        visitor.visit(this, PROPERTY_DOMAIN, Domain.class, domain);
        visitor.visit(this, PROPERTY_CROPPING_PLAN_SPECIES, List.class, CroppingPlanSpecies.class, croppingPlanSpecies);
        visitor.visit(this, PROPERTY_TYPE, CroppingEntryType.class, type);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setSellingPrice(Double sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    @Override
    public Double getSellingPrice() {
        Double result = this.sellingPrice;
        return result;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        String result = this.code;
        return result;
    }

    @Override
    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public boolean isValidated() {
        boolean result = this.validated;
        return result;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Domain getDomain() {
        Domain result = this.domain;
        return result;
    }

    @Override
    public void addCroppingPlanSpecies(CroppingPlanSpecies croppingPlanSpecies) {
        if (this.croppingPlanSpecies == null) {
            this.croppingPlanSpecies = new LinkedList<CroppingPlanSpecies>();
        }
        croppingPlanSpecies.setCroppingPlanEntry(this);
        this.croppingPlanSpecies.add(croppingPlanSpecies);
    }

    @Override
    public void addCroppingPlanSpecies(int index, CroppingPlanSpecies croppingPlanSpecies) {
        if (this.croppingPlanSpecies == null) {
            this.croppingPlanSpecies = new LinkedList<CroppingPlanSpecies>();
        }
        croppingPlanSpecies.setCroppingPlanEntry(this);
        this.croppingPlanSpecies.add(index, croppingPlanSpecies);
    }

    @Override
    public void addAllCroppingPlanSpecies(Iterable<CroppingPlanSpecies> croppingPlanSpecies) {
        if (croppingPlanSpecies == null) {
            return;
        }
        for (CroppingPlanSpecies item : croppingPlanSpecies) {
            addCroppingPlanSpecies(item);
        }
    }

    @Override
    public void setCroppingPlanSpecies(List<CroppingPlanSpecies> croppingPlanSpecies) {
        this.croppingPlanSpecies = croppingPlanSpecies;
    }

    @Override
    public void removeCroppingPlanSpecies(CroppingPlanSpecies croppingPlanSpecies) {
        if (this.croppingPlanSpecies == null || !this.croppingPlanSpecies.remove(croppingPlanSpecies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        croppingPlanSpecies.setCroppingPlanEntry(null);
    }

    @Override
    public void removeCroppingPlanSpecies(int index) {
        if (this.croppingPlanSpecies == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        CroppingPlanSpecies oldValue = this.croppingPlanSpecies.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        oldValue.setCroppingPlanEntry(null);
    }

    @Override
    public void clearCroppingPlanSpecies() {
        if (this.croppingPlanSpecies == null) {
            return;
        }
        for (CroppingPlanSpecies item : this.croppingPlanSpecies) {
            item.setCroppingPlanEntry(null);
        }
        this.croppingPlanSpecies.clear();
    }

    @Override
    public List<CroppingPlanSpecies> getCroppingPlanSpecies() {
        return croppingPlanSpecies;
    }

    @Override
    public CroppingPlanSpecies getCroppingPlanSpecies(int index) {
        return TopiaEntityHelper.getEntityByIndex(croppingPlanSpecies, index);
    }

    @Override
    public CroppingPlanSpecies getCroppingPlanSpeciesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(croppingPlanSpecies, topiaId);
    }

    @Override
    public List<String> getCroppingPlanSpeciesTopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<fr.inra.agrosyst.api.entities.CroppingPlanSpecies> tmp = getCroppingPlanSpecies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeCroppingPlanSpecies() {
        if (croppingPlanSpecies == null) {
            return 0;
        }
        return croppingPlanSpecies.size();
    }

    @Override
    public boolean isCroppingPlanSpeciesEmpty() {
        int size = sizeCroppingPlanSpecies();
        return size == 0;
    }

    @Override
    public boolean isCroppingPlanSpeciesNotEmpty() {
        boolean empty = isCroppingPlanSpeciesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsCroppingPlanSpecies(CroppingPlanSpecies croppingPlanSpecies) {
        boolean contains = this.croppingPlanSpecies !=null && this.croppingPlanSpecies.contains(croppingPlanSpecies);
        return contains;
    }

    @Override
    public void setType(CroppingEntryType type) {
        this.type = type;
    }

    @Override
    public CroppingEntryType getType() {
        CroppingEntryType result = this.type;
        return result;
    }

} //CroppingPlanEntryAbstract
