package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 17 16:16:20 CET 2015")
public abstract class BasicPlotAbstract extends AbstractTopiaEntity implements BasicPlot {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : area
     */
    protected double area;

    /**
     * Nom de l'attribut en BD : pacIlotNumber
     */
    protected int pacIlotNumber;

    /**
     * Nom de l'attribut en BD : latitude
     */
    protected Double latitude;

    /**
     * Nom de l'attribut en BD : longitude
     */
    protected Double longitude;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : activityEndComment
     */
    protected String activityEndComment;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : outOfZoning
     */
    protected boolean outOfZoning;

    /**
     * Nom de l'attribut en BD : zoningComment
     */
    protected String zoningComment;

    /**
     * Nom de l'attribut en BD : irrigationSystem
     */
    protected boolean irrigationSystem;

    /**
     * Nom de l'attribut en BD : fertigationSystem
     */
    protected boolean fertigationSystem;

    /**
     * Nom de l'attribut en BD : waterOrigin
     */
    protected String waterOrigin;

    /**
     * Nom de l'attribut en BD : drainage
     */
    protected boolean drainage;

    /**
     * Nom de l'attribut en BD : drainageYear
     */
    protected Integer drainageYear;

    /**
     * Nom de l'attribut en BD : frostProtection
     */
    protected boolean frostProtection;

    /**
     * Protection anti-grele.
     * Nom de l'attribut en BD : hailProtection
     */
    protected boolean hailProtection;

    /**
     * Nom de l'attribut en BD : rainproofProtection
     */
    protected boolean rainproofProtection;

    /**
     * Nom de l'attribut en BD : pestProtection
     */
    protected boolean pestProtection;

    /**
     * Nom de l'attribut en BD : otherEquipment
     */
    protected String otherEquipment;

    /**
     * Nom de l'attribut en BD : equipmentComment
     */
    protected String equipmentComment;

    /**
     * Nom de l'attribut en BD : solStoniness
     */
    protected Double solStoniness;

    /**
     * Nom de l'attribut en BD : solMaxDepth
     */
    protected Integer solMaxDepth;

    /**
     * Nom de l'attribut en BD : solOrganicMaterialPercent
     */
    protected Double solOrganicMaterialPercent;

    /**
     * Nom de l'attribut en BD : solHydromorphisms
     */
    protected boolean solHydromorphisms;

    /**
     * Calcaire total.
     * Nom de l'attribut en BD : solTotalLimestone
     */
    protected Double solTotalLimestone;

    /**
     * Calcaire.
     * Nom de l'attribut en BD : solLimestone
     */
    protected boolean solLimestone;

    /**
     * Calcaire actif.
     * Nom de l'attribut en BD : solActiveLimestone
     */
    protected Double solActiveLimestone;

    /**
     * Battance
     * Nom de l'attribut en BD : solBattance
     */
    protected boolean solBattance;

    /**
     * Nom de l'attribut en BD : solComment
     */
    protected String solComment;

    /**
     * Nom de l'attribut en BD : adjacentComment
     */
    protected String adjacentComment;

    /**
     * Nom de l'attribut en BD : waterFlowDistance
     */
    protected WaterFlowDistance waterFlowDistance;

    /**
     * Nom de l'attribut en BD : plotZonings
     */
    protected Collection<RefParcelleZonageEDI> plotZonings;

    /**
     * Nom de l'attribut en BD : irrigationSystemType
     */
    protected IrrigationSystemType irrigationSystemType;

    /**
     * Nom de l'attribut en BD : pompEngineType
     */
    protected PompEngineType pompEngineType;

    /**
     * Nom de l'attribut en BD : hosesPositionning
     */
    protected HosesPositionning hosesPositionning;

    /**
     * Nom de l'attribut en BD : frostProtectionType
     */
    protected FrostProtectionType frostProtectionType;

    /**
     * Nom de l'attribut en BD : surfaceTexture
     */
    protected RefSolTextureGeppa surfaceTexture;

    /**
     * Nom de l'attribut en BD : solDepth
     */
    protected RefSolProfondeurIndigo solDepth;

    /**
     * Nom de l'attribut en BD : solWaterPh
     */
    protected SolWaterPh solWaterPh;

    /**
     * Nom de l'attribut en BD : solHorizon
     */
    protected Collection<SolHorizon> solHorizon;

    /**
     * Nom de l'attribut en BD : maxSlope
     */
    protected MaxSlope maxSlope;

    /**
     * Nom de l'attribut en BD : adjacentElements
     */
    protected Collection<RefElementVoisinage> adjacentElements;

    /**
     * Nom de l'attribut en BD : subSoilTexture
     */
    protected RefSolTextureGeppa subSoilTexture;

    /**
     * Nom de l'attribut en BD : bufferStrip
     */
    protected BufferStrip bufferStrip;

    /**
     * Nom de l'attribut en BD : location
     */
    protected RefLocation location;

    private static final long serialVersionUID = 7306639824100091440L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_AREA, double.class, area);
        visitor.visit(this, PROPERTY_PAC_ILOT_NUMBER, int.class, pacIlotNumber);
        visitor.visit(this, PROPERTY_LATITUDE, Double.class, latitude);
        visitor.visit(this, PROPERTY_LONGITUDE, Double.class, longitude);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_ACTIVITY_END_COMMENT, String.class, activityEndComment);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_OUT_OF_ZONING, boolean.class, outOfZoning);
        visitor.visit(this, PROPERTY_ZONING_COMMENT, String.class, zoningComment);
        visitor.visit(this, PROPERTY_IRRIGATION_SYSTEM, boolean.class, irrigationSystem);
        visitor.visit(this, PROPERTY_FERTIGATION_SYSTEM, boolean.class, fertigationSystem);
        visitor.visit(this, PROPERTY_WATER_ORIGIN, String.class, waterOrigin);
        visitor.visit(this, PROPERTY_DRAINAGE, boolean.class, drainage);
        visitor.visit(this, PROPERTY_DRAINAGE_YEAR, Integer.class, drainageYear);
        visitor.visit(this, PROPERTY_FROST_PROTECTION, boolean.class, frostProtection);
        visitor.visit(this, PROPERTY_HAIL_PROTECTION, boolean.class, hailProtection);
        visitor.visit(this, PROPERTY_RAINPROOF_PROTECTION, boolean.class, rainproofProtection);
        visitor.visit(this, PROPERTY_PEST_PROTECTION, boolean.class, pestProtection);
        visitor.visit(this, PROPERTY_OTHER_EQUIPMENT, String.class, otherEquipment);
        visitor.visit(this, PROPERTY_EQUIPMENT_COMMENT, String.class, equipmentComment);
        visitor.visit(this, PROPERTY_SOL_STONINESS, Double.class, solStoniness);
        visitor.visit(this, PROPERTY_SOL_MAX_DEPTH, Integer.class, solMaxDepth);
        visitor.visit(this, PROPERTY_SOL_ORGANIC_MATERIAL_PERCENT, Double.class, solOrganicMaterialPercent);
        visitor.visit(this, PROPERTY_SOL_HYDROMORPHISMS, boolean.class, solHydromorphisms);
        visitor.visit(this, PROPERTY_SOL_TOTAL_LIMESTONE, Double.class, solTotalLimestone);
        visitor.visit(this, PROPERTY_SOL_LIMESTONE, boolean.class, solLimestone);
        visitor.visit(this, PROPERTY_SOL_ACTIVE_LIMESTONE, Double.class, solActiveLimestone);
        visitor.visit(this, PROPERTY_SOL_BATTANCE, boolean.class, solBattance);
        visitor.visit(this, PROPERTY_SOL_COMMENT, String.class, solComment);
        visitor.visit(this, PROPERTY_ADJACENT_COMMENT, String.class, adjacentComment);
        visitor.visit(this, PROPERTY_WATER_FLOW_DISTANCE, WaterFlowDistance.class, waterFlowDistance);
        visitor.visit(this, PROPERTY_PLOT_ZONINGS, Collection.class, RefParcelleZonageEDI.class, plotZonings);
        visitor.visit(this, PROPERTY_IRRIGATION_SYSTEM_TYPE, IrrigationSystemType.class, irrigationSystemType);
        visitor.visit(this, PROPERTY_POMP_ENGINE_TYPE, PompEngineType.class, pompEngineType);
        visitor.visit(this, PROPERTY_HOSES_POSITIONNING, HosesPositionning.class, hosesPositionning);
        visitor.visit(this, PROPERTY_FROST_PROTECTION_TYPE, FrostProtectionType.class, frostProtectionType);
        visitor.visit(this, PROPERTY_SURFACE_TEXTURE, RefSolTextureGeppa.class, surfaceTexture);
        visitor.visit(this, PROPERTY_SOL_DEPTH, RefSolProfondeurIndigo.class, solDepth);
        visitor.visit(this, PROPERTY_SOL_WATER_PH, SolWaterPh.class, solWaterPh);
        visitor.visit(this, PROPERTY_SOL_HORIZON, Collection.class, SolHorizon.class, solHorizon);
        visitor.visit(this, PROPERTY_MAX_SLOPE, MaxSlope.class, maxSlope);
        visitor.visit(this, PROPERTY_ADJACENT_ELEMENTS, Collection.class, RefElementVoisinage.class, adjacentElements);
        visitor.visit(this, PROPERTY_SUB_SOIL_TEXTURE, RefSolTextureGeppa.class, subSoilTexture);
        visitor.visit(this, PROPERTY_BUFFER_STRIP, BufferStrip.class, bufferStrip);
        visitor.visit(this, PROPERTY_LOCATION, RefLocation.class, location);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setArea(double area) {
        this.area = area;
    }

    @Override
    public double getArea() {
        double result = this.area;
        return result;
    }

    @Override
    public void setPacIlotNumber(int pacIlotNumber) {
        this.pacIlotNumber = pacIlotNumber;
    }

    @Override
    public int getPacIlotNumber() {
        int result = this.pacIlotNumber;
        return result;
    }

    @Override
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public Double getLatitude() {
        Double result = this.latitude;
        return result;
    }

    @Override
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getLongitude() {
        Double result = this.longitude;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setActivityEndComment(String activityEndComment) {
        this.activityEndComment = activityEndComment;
    }

    @Override
    public String getActivityEndComment() {
        String result = this.activityEndComment;
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        boolean result = this.active;
        return result;
    }

    @Override
    public void setOutOfZoning(boolean outOfZoning) {
        this.outOfZoning = outOfZoning;
    }

    @Override
    public boolean isOutOfZoning() {
        boolean result = this.outOfZoning;
        return result;
    }

    @Override
    public void setZoningComment(String zoningComment) {
        this.zoningComment = zoningComment;
    }

    @Override
    public String getZoningComment() {
        String result = this.zoningComment;
        return result;
    }

    @Override
    public void setIrrigationSystem(boolean irrigationSystem) {
        this.irrigationSystem = irrigationSystem;
    }

    @Override
    public boolean isIrrigationSystem() {
        boolean result = this.irrigationSystem;
        return result;
    }

    @Override
    public void setFertigationSystem(boolean fertigationSystem) {
        this.fertigationSystem = fertigationSystem;
    }

    @Override
    public boolean isFertigationSystem() {
        boolean result = this.fertigationSystem;
        return result;
    }

    @Override
    public void setWaterOrigin(String waterOrigin) {
        this.waterOrigin = waterOrigin;
    }

    @Override
    public String getWaterOrigin() {
        String result = this.waterOrigin;
        return result;
    }

    @Override
    public void setDrainage(boolean drainage) {
        this.drainage = drainage;
    }

    @Override
    public boolean isDrainage() {
        boolean result = this.drainage;
        return result;
    }

    @Override
    public void setDrainageYear(Integer drainageYear) {
        this.drainageYear = drainageYear;
    }

    @Override
    public Integer getDrainageYear() {
        Integer result = this.drainageYear;
        return result;
    }

    @Override
    public void setFrostProtection(boolean frostProtection) {
        this.frostProtection = frostProtection;
    }

    @Override
    public boolean isFrostProtection() {
        boolean result = this.frostProtection;
        return result;
    }

    @Override
    public void setHailProtection(boolean hailProtection) {
        this.hailProtection = hailProtection;
    }

    @Override
    public boolean isHailProtection() {
        boolean result = this.hailProtection;
        return result;
    }

    @Override
    public void setRainproofProtection(boolean rainproofProtection) {
        this.rainproofProtection = rainproofProtection;
    }

    @Override
    public boolean isRainproofProtection() {
        boolean result = this.rainproofProtection;
        return result;
    }

    @Override
    public void setPestProtection(boolean pestProtection) {
        this.pestProtection = pestProtection;
    }

    @Override
    public boolean isPestProtection() {
        boolean result = this.pestProtection;
        return result;
    }

    @Override
    public void setOtherEquipment(String otherEquipment) {
        this.otherEquipment = otherEquipment;
    }

    @Override
    public String getOtherEquipment() {
        String result = this.otherEquipment;
        return result;
    }

    @Override
    public void setEquipmentComment(String equipmentComment) {
        this.equipmentComment = equipmentComment;
    }

    @Override
    public String getEquipmentComment() {
        String result = this.equipmentComment;
        return result;
    }

    @Override
    public void setSolStoniness(Double solStoniness) {
        this.solStoniness = solStoniness;
    }

    @Override
    public Double getSolStoniness() {
        Double result = this.solStoniness;
        return result;
    }

    @Override
    public void setSolMaxDepth(Integer solMaxDepth) {
        this.solMaxDepth = solMaxDepth;
    }

    @Override
    public Integer getSolMaxDepth() {
        Integer result = this.solMaxDepth;
        return result;
    }

    @Override
    public void setSolOrganicMaterialPercent(Double solOrganicMaterialPercent) {
        this.solOrganicMaterialPercent = solOrganicMaterialPercent;
    }

    @Override
    public Double getSolOrganicMaterialPercent() {
        Double result = this.solOrganicMaterialPercent;
        return result;
    }

    @Override
    public void setSolHydromorphisms(boolean solHydromorphisms) {
        this.solHydromorphisms = solHydromorphisms;
    }

    @Override
    public boolean isSolHydromorphisms() {
        boolean result = this.solHydromorphisms;
        return result;
    }

    @Override
    public void setSolTotalLimestone(Double solTotalLimestone) {
        this.solTotalLimestone = solTotalLimestone;
    }

    @Override
    public Double getSolTotalLimestone() {
        Double result = this.solTotalLimestone;
        return result;
    }

    @Override
    public void setSolLimestone(boolean solLimestone) {
        this.solLimestone = solLimestone;
    }

    @Override
    public boolean isSolLimestone() {
        boolean result = this.solLimestone;
        return result;
    }

    @Override
    public void setSolActiveLimestone(Double solActiveLimestone) {
        this.solActiveLimestone = solActiveLimestone;
    }

    @Override
    public Double getSolActiveLimestone() {
        Double result = this.solActiveLimestone;
        return result;
    }

    @Override
    public void setSolBattance(boolean solBattance) {
        this.solBattance = solBattance;
    }

    @Override
    public boolean isSolBattance() {
        boolean result = this.solBattance;
        return result;
    }

    @Override
    public void setSolComment(String solComment) {
        this.solComment = solComment;
    }

    @Override
    public String getSolComment() {
        String result = this.solComment;
        return result;
    }

    @Override
    public void setAdjacentComment(String adjacentComment) {
        this.adjacentComment = adjacentComment;
    }

    @Override
    public String getAdjacentComment() {
        String result = this.adjacentComment;
        return result;
    }

    @Override
    public void setWaterFlowDistance(WaterFlowDistance waterFlowDistance) {
        this.waterFlowDistance = waterFlowDistance;
    }

    @Override
    public WaterFlowDistance getWaterFlowDistance() {
        WaterFlowDistance result = this.waterFlowDistance;
        return result;
    }

    @Override
    public void addPlotZonings(RefParcelleZonageEDI plotZonings) {
        if (this.plotZonings == null) {
            this.plotZonings = new LinkedList<RefParcelleZonageEDI>();
        }
        this.plotZonings.add(plotZonings);
    }

    @Override
    public void addAllPlotZonings(Iterable<RefParcelleZonageEDI> plotZonings) {
        if (plotZonings == null) {
            return;
        }
        for (RefParcelleZonageEDI item : plotZonings) {
            addPlotZonings(item);
        }
    }

    @Override
    public void setPlotZonings(Collection<RefParcelleZonageEDI> plotZonings) {
        this.plotZonings = plotZonings;
    }

    @Override
    public void removePlotZonings(RefParcelleZonageEDI plotZonings) {
        if (this.plotZonings == null || !this.plotZonings.remove(plotZonings)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearPlotZonings() {
        if (this.plotZonings == null) {
            return;
        }
        this.plotZonings.clear();
    }

    @Override
    public Collection<RefParcelleZonageEDI> getPlotZonings() {
        return plotZonings;
    }

    @Override
    public RefParcelleZonageEDI getPlotZoningsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(plotZonings, topiaId);
    }

    @Override
    public Collection<String> getPlotZoningsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI> tmp = getPlotZonings();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizePlotZonings() {
        if (plotZonings == null) {
            return 0;
        }
        return plotZonings.size();
    }

    @Override
    public boolean isPlotZoningsEmpty() {
        int size = sizePlotZonings();
        return size == 0;
    }

    @Override
    public boolean isPlotZoningsNotEmpty() {
        boolean empty = isPlotZoningsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPlotZonings(RefParcelleZonageEDI plotZonings) {
        boolean contains = this.plotZonings !=null && this.plotZonings.contains(plotZonings);
        return contains;
    }

    @Override
    public void setIrrigationSystemType(IrrigationSystemType irrigationSystemType) {
        this.irrigationSystemType = irrigationSystemType;
    }

    @Override
    public IrrigationSystemType getIrrigationSystemType() {
        IrrigationSystemType result = this.irrigationSystemType;
        return result;
    }

    @Override
    public void setPompEngineType(PompEngineType pompEngineType) {
        this.pompEngineType = pompEngineType;
    }

    @Override
    public PompEngineType getPompEngineType() {
        PompEngineType result = this.pompEngineType;
        return result;
    }

    @Override
    public void setHosesPositionning(HosesPositionning hosesPositionning) {
        this.hosesPositionning = hosesPositionning;
    }

    @Override
    public HosesPositionning getHosesPositionning() {
        HosesPositionning result = this.hosesPositionning;
        return result;
    }

    @Override
    public void setFrostProtectionType(FrostProtectionType frostProtectionType) {
        this.frostProtectionType = frostProtectionType;
    }

    @Override
    public FrostProtectionType getFrostProtectionType() {
        FrostProtectionType result = this.frostProtectionType;
        return result;
    }

    @Override
    public void setSurfaceTexture(RefSolTextureGeppa surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
    }

    @Override
    public RefSolTextureGeppa getSurfaceTexture() {
        RefSolTextureGeppa result = this.surfaceTexture;
        return result;
    }

    @Override
    public void setSolDepth(RefSolProfondeurIndigo solDepth) {
        this.solDepth = solDepth;
    }

    @Override
    public RefSolProfondeurIndigo getSolDepth() {
        RefSolProfondeurIndigo result = this.solDepth;
        return result;
    }

    @Override
    public void setSolWaterPh(SolWaterPh solWaterPh) {
        this.solWaterPh = solWaterPh;
    }

    @Override
    public SolWaterPh getSolWaterPh() {
        SolWaterPh result = this.solWaterPh;
        return result;
    }

    @Override
    public void addSolHorizon(SolHorizon solHorizon) {
        if (this.solHorizon == null) {
            this.solHorizon = new LinkedList<SolHorizon>();
        }
        this.solHorizon.add(solHorizon);
    }

    @Override
    public void addAllSolHorizon(Iterable<SolHorizon> solHorizon) {
        if (solHorizon == null) {
            return;
        }
        for (SolHorizon item : solHorizon) {
            addSolHorizon(item);
        }
    }

    @Override
    public void setSolHorizon(Collection<SolHorizon> solHorizon) {
        this.solHorizon = solHorizon;
    }

    @Override
    public void removeSolHorizon(SolHorizon solHorizon) {
        if (this.solHorizon == null || !this.solHorizon.remove(solHorizon)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSolHorizon() {
        if (this.solHorizon == null) {
            return;
        }
        this.solHorizon.clear();
    }

    @Override
    public Collection<SolHorizon> getSolHorizon() {
        return solHorizon;
    }

    @Override
    public SolHorizon getSolHorizonByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(solHorizon, topiaId);
    }

    @Override
    public Collection<String> getSolHorizonTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.SolHorizon> tmp = getSolHorizon();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSolHorizon() {
        if (solHorizon == null) {
            return 0;
        }
        return solHorizon.size();
    }

    @Override
    public boolean isSolHorizonEmpty() {
        int size = sizeSolHorizon();
        return size == 0;
    }

    @Override
    public boolean isSolHorizonNotEmpty() {
        boolean empty = isSolHorizonEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSolHorizon(SolHorizon solHorizon) {
        boolean contains = this.solHorizon !=null && this.solHorizon.contains(solHorizon);
        return contains;
    }

    @Override
    public void setMaxSlope(MaxSlope maxSlope) {
        this.maxSlope = maxSlope;
    }

    @Override
    public MaxSlope getMaxSlope() {
        MaxSlope result = this.maxSlope;
        return result;
    }

    @Override
    public void addAdjacentElements(RefElementVoisinage adjacentElements) {
        if (this.adjacentElements == null) {
            this.adjacentElements = new LinkedList<RefElementVoisinage>();
        }
        this.adjacentElements.add(adjacentElements);
    }

    @Override
    public void addAllAdjacentElements(Iterable<RefElementVoisinage> adjacentElements) {
        if (adjacentElements == null) {
            return;
        }
        for (RefElementVoisinage item : adjacentElements) {
            addAdjacentElements(item);
        }
    }

    @Override
    public void setAdjacentElements(Collection<RefElementVoisinage> adjacentElements) {
        this.adjacentElements = adjacentElements;
    }

    @Override
    public void removeAdjacentElements(RefElementVoisinage adjacentElements) {
        if (this.adjacentElements == null || !this.adjacentElements.remove(adjacentElements)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearAdjacentElements() {
        if (this.adjacentElements == null) {
            return;
        }
        this.adjacentElements.clear();
    }

    @Override
    public Collection<RefElementVoisinage> getAdjacentElements() {
        return adjacentElements;
    }

    @Override
    public RefElementVoisinage getAdjacentElementsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(adjacentElements, topiaId);
    }

    @Override
    public Collection<String> getAdjacentElementsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<fr.inra.agrosyst.api.entities.referential.RefElementVoisinage> tmp = getAdjacentElements();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeAdjacentElements() {
        if (adjacentElements == null) {
            return 0;
        }
        return adjacentElements.size();
    }

    @Override
    public boolean isAdjacentElementsEmpty() {
        int size = sizeAdjacentElements();
        return size == 0;
    }

    @Override
    public boolean isAdjacentElementsNotEmpty() {
        boolean empty = isAdjacentElementsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsAdjacentElements(RefElementVoisinage adjacentElements) {
        boolean contains = this.adjacentElements !=null && this.adjacentElements.contains(adjacentElements);
        return contains;
    }

    @Override
    public void setSubSoilTexture(RefSolTextureGeppa subSoilTexture) {
        this.subSoilTexture = subSoilTexture;
    }

    @Override
    public RefSolTextureGeppa getSubSoilTexture() {
        RefSolTextureGeppa result = this.subSoilTexture;
        return result;
    }

    @Override
    public void setBufferStrip(BufferStrip bufferStrip) {
        this.bufferStrip = bufferStrip;
    }

    @Override
    public BufferStrip getBufferStrip() {
        BufferStrip result = this.bufferStrip;
        return result;
    }

    @Override
    public void setLocation(RefLocation location) {
        this.location = location;
    }

    @Override
    public RefLocation getLocation() {
        RefLocation result = this.location;
        return result;
    }

} //BasicPlotAbstract
