package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.BiologicalControlAction;
import fr.inra.agrosyst.api.entities.action.BiologicalProductInput;
import fr.inra.agrosyst.api.entities.action.CarriageAction;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.action.IrrigationAction;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralProductInput;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.OtherAction;
import fr.inra.agrosyst.api.entities.action.OtherProductInput;
import fr.inra.agrosyst.api.entities.action.PesticideProductInput;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingAction;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingProductInput;
import fr.inra.agrosyst.api.entities.action.TillageAction;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInvolvedRule;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceFile;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCultureAEE;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShape;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburant;
import fr.inra.agrosyst.api.entities.referential.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referential.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referential.RefGesSemence;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActa;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburant;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngrais;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutil;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemence;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermission;
import fr.inra.agrosyst.api.entities.security.HashedValue;
import fr.inra.agrosyst.api.entities.security.StoredToken;
import fr.inra.agrosyst.api.entities.security.TrackedEvent;
import fr.inra.agrosyst.api.entities.security.UserRole;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityEnumTransformer", date = "Thu Dec 17 16:16:20 CET 2015")

public enum AgrosystEntityEnum implements TopiaEntityEnum {
    AttachmentContent(AttachmentContent.class, null, "attachmentcontent", new String[]{"content", "attachmentMetadata"}),
    AttachmentMetadata(AttachmentMetadata.class, null, "attachmentmetadata", new String[]{"name", "size", "objectReferenceId", "author"}),
    BasicPlot(BasicPlot.class, null, "basicplot", new String[]{"name", "waterFlowDistance", "maxSlope", "bufferStrip"}),
    CroppingPlanEntry(CroppingPlanEntry.class, null, "croppingplanentry", new String[]{"name", "code", "domain", "type"}, "code", "domain"),
    CroppingPlanSpecies(CroppingPlanSpecies.class, null, "croppingplanspecies", new String[]{"code", "croppingPlanEntry", "species"}),
    Domain(Domain.class, null, "domain", new String[]{"name", "mainContact", "campaign", "code", "updateDate", "type", "location"}, "campaign", "code"),
    Equipment(Equipment.class, null, "equipment", new String[]{"name", "code", "domain"}),
    GeoPoint(GeoPoint.class, null, "geopoint", new String[]{"name", "longitude", "latitude", "domain"}),
    Ground(Ground.class, null, "ground", new String[]{"domain", "refSolArvalis"}),
    GrowingPlan(GrowingPlan.class, null, "growingplan", new String[]{"name", "code", "updateDate", "domain", "type"}, "code", "domain"),
    GrowingSystem(GrowingSystem.class, null, "growingsystem", new String[]{"name", "code", "updateDate", "sector", "growingPlan"}, "code", "growingPlan"),
    Network(Network.class, null, "network", new String[]{"name", "managers"}, "name"),
    NetworkManager(NetworkManager.class, null, "networkmanager", new String[]{"agrosystUser"}),
    Plot(Plot.class, null, "plot", new String[]{"code", "domain", "name", "waterFlowDistance", "maxSlope", "bufferStrip"}),
    Price(Price.class, null, "price", new String[]{"category", "displayName", "type", "priceUnit"}, "objectId", "sourceUnit", "domain", "practicedSystem", "type", "priceUnit"),
    SolHorizon(SolHorizon.class, null, "solhorizon", ArrayUtils.EMPTY_STRING_ARRAY),
    ToolsCoupling(ToolsCoupling.class, null, "toolscoupling", new String[]{"toolsCouplingName", "code", "domain", "mainsActions"}),
    WeatherStation(WeatherStation.class, null, "weatherstation", new String[]{"refStationMeteo"}),
    Zone(Zone.class, null, "zone", new String[]{"code", "plot"}, "code", "plot"),
    AbstractAction(AbstractAction.class, null, "abstractaction", new String[]{"mainAction"}),
    AbstractInput(AbstractInput.class, null, "abstractinput", new String[]{"inputType"}),
    BiologicalControlAction(BiologicalControlAction.class, null, "biologicalcontrolaction", new String[]{"mainAction"}),
    BiologicalProductInput(BiologicalProductInput.class, null, "biologicalproductinput", new String[]{"inputType"}),
    CarriageAction(CarriageAction.class, null, "carriageaction", new String[]{"mainAction"}),
    HarvestingAction(HarvestingAction.class, null, "harvestingaction", new String[]{"mainAction"}),
    HarvestingYeald(HarvestingYeald.class, null, "harvestingyeald", new String[]{"yealdCategory", "yealdUnit"}),
    IrrigationAction(IrrigationAction.class, null, "irrigationaction", new String[]{"mainAction"}),
    MaintenancePruningVinesAction(MaintenancePruningVinesAction.class, null, "maintenancepruningvinesaction", new String[]{"mainAction"}),
    MineralFertilizersSpreadingAction(MineralFertilizersSpreadingAction.class, null, "mineralfertilizersspreadingaction", new String[]{"mainAction"}),
    MineralProductInput(MineralProductInput.class, null, "mineralproductinput", new String[]{"inputType"}),
    OrganicFertilizersSpreadingAction(OrganicFertilizersSpreadingAction.class, null, "organicfertilizersspreadingaction", new String[]{"mainAction"}),
    OrganicProductInput(OrganicProductInput.class, null, "organicproductinput", new String[]{"inputType"}),
    OtherAction(OtherAction.class, null, "otheraction", new String[]{"mainAction"}),
    OtherProductInput(OtherProductInput.class, null, "otherproductinput", new String[]{"inputType"}),
    PesticideProductInput(PesticideProductInput.class, null, "pesticideproductinput", new String[]{"inputType"}),
    PesticidesSpreadingAction(PesticidesSpreadingAction.class, null, "pesticidesspreadingaction", new String[]{"mainAction"}),
    PhytoProductInput(PhytoProductInput.class, null, "phytoproductinput", new String[]{"inputType"}),
    SeedingAction(SeedingAction.class, null, "seedingaction", new String[]{"mainAction"}),
    SeedingActionSpecies(SeedingActionSpecies.class, null, "seedingactionspecies", ArrayUtils.EMPTY_STRING_ARRAY),
    SeedingProductInput(SeedingProductInput.class, null, "seedingproductinput", new String[]{"inputType"}),
    TillageAction(TillageAction.class, null, "tillageaction", new String[]{"mainAction"}),
    EffectiveCropCycleConnection(EffectiveCropCycleConnection.class, null, "effectivecropcycleconnection", new String[]{"target"}),
    EffectiveCropCycleNode(EffectiveCropCycleNode.class, null, "effectivecropcyclenode", new String[]{"croppingPlanEntry"}),
    EffectiveCropCyclePhase(EffectiveCropCyclePhase.class, null, "effectivecropcyclephase", new String[]{"type"}),
    EffectiveCropCycleSpecies(EffectiveCropCycleSpecies.class, null, "effectivecropcyclespecies", new String[]{"croppingPlanSpecies"}),
    EffectiveIntervention(EffectiveIntervention.class, null, "effectiveintervention", new String[]{"name", "startInterventionDate", "endInterventionDate", "type"}),
    EffectiveInvolvedRule(EffectiveInvolvedRule.class, null, "effectiveinvolvedrule", new String[]{"compliance", "decisionRule"}),
    EffectivePerennialCropCycle(EffectivePerennialCropCycle.class, null, "effectiveperennialcropcycle", new String[]{"weedType", "zone", "croppingPlanEntry", "phase"}),
    EffectiveSeasonalCropCycle(EffectiveSeasonalCropCycle.class, null, "effectiveseasonalcropcycle", new String[]{"zone"}),
    EffectiveSpeciesStade(EffectiveSpeciesStade.class, null, "effectivespeciesstade", new String[]{"croppingPlanSpecies"}),
    Message(Message.class, null, "message", new String[]{"title"}),
    DecisionRule(DecisionRule.class, null, "decisionrule", new String[]{"code", "versionNumber", "domainCode", "name", "interventionType"}, "code", "versionNumber"),
    ManagementMode(ManagementMode.class, null, "managementmode", new String[]{"category", "growingSystem"}, "category", "growingSystem"),
    Section(Section.class, null, "section", new String[]{"sectionType"}),
    Strategy(Strategy.class, null, "strategy", new String[]{"explanation"}),
    Measure(Measure.class, null, "measure", new String[]{"measurementType"}),
    Measurement(Measurement.class, null, "measurement", new String[]{"measurementType"}),
    MeasurementSession(MeasurementSession.class, null, "measurementsession", new String[]{"startDate", "zone"}),
    Observation(Observation.class, null, "observation", new String[]{"measurementType"}),
    Performance(Performance.class, null, "performance", new String[]{"name", "updateDate", "author", "computeStatus"}),
    PerformanceFile(PerformanceFile.class, null, "performancefile", new String[]{"performance"}),
    PracticedCropCycle(PracticedCropCycle.class, null, "practicedcropcycle", new String[]{"practicedSystem"}),
    PracticedCropCycleConnection(PracticedCropCycleConnection.class, null, "practicedcropcycleconnection", new String[]{"target", "source"}),
    PracticedCropCycleNode(PracticedCropCycleNode.class, null, "practicedcropcyclenode", new String[]{"rank", "y", "croppingPlanEntryCode", "practicedSeasonalCropCycle"}),
    PracticedCropCyclePhase(PracticedCropCyclePhase.class, null, "practicedcropcyclephase", new String[]{"type"}),
    PracticedCropCycleSpecies(PracticedCropCycleSpecies.class, null, "practicedcropcyclespecies", new String[]{"croppingPlanSpeciesCode"}),
    PracticedIntervention(PracticedIntervention.class, null, "practicedintervention", new String[]{"name", "startingPeriodDate", "endingPeriodDate", "type"}),
    PracticedPerennialCropCycle(PracticedPerennialCropCycle.class, null, "practicedperennialcropcycle", new String[]{"croppingPlanEntryCode", "solOccupationPercent", "weedType", "cropCyclePhases", "practicedSystem"}),
    PracticedPlot(PracticedPlot.class, null, "practicedplot", new String[]{"practicedSystem", "name", "waterFlowDistance", "maxSlope", "bufferStrip"}),
    PracticedSeasonalCropCycle(PracticedSeasonalCropCycle.class, null, "practicedseasonalcropcycle", new String[]{"practicedSystem"}),
    PracticedSpeciesStade(PracticedSpeciesStade.class, null, "practicedspeciesstade", ArrayUtils.EMPTY_STRING_ARRAY),
    PracticedSystem(PracticedSystem.class, null, "practicedsystem", new String[]{"name", "campaigns", "updateDate", "growingSystem"}),
    RefActaDosageSPC(RefActaDosageSPC.class, null, "refactadosagespc", new String[]{"id_produit", "id_traitement", "id_culture", "dosage_spc_commentaire"}, "id_produit", "id_traitement", "id_culture", "dosage_spc_valeur", "dosage_spc_commentaire"),
    RefActaGroupeCultures(RefActaGroupeCultures.class, null, "refactagroupecultures", new String[]{"id_culture", "id_groupe_culture"}, "id_culture", "id_groupe_culture"),
    RefActaSubstanceActive(RefActaSubstanceActive.class, null, "refactasubstanceactive", new String[]{"id_produit", "nom_commun_sa"}, "id_produit", "nom_commun_sa"),
    RefActaTraitementsProduit(RefActaTraitementsProduit.class, null, "refactatraitementsproduit", new String[]{"id_produit", "id_traitement"}, "id_produit", "id_traitement"),
    RefActaTraitementsProduitsCateg(RefActaTraitementsProduitsCateg.class, null, "refactatraitementsproduitscateg", new String[]{"id_traitement"}, "id_traitement"),
    RefAdventice(RefAdventice.class, null, "refadventice", new String[]{"identifiant"}, "identifiant"),
    RefBioAgressor(RefBioAgressor.class, null, "refbioagressor", ArrayUtils.EMPTY_STRING_ARRAY),
    RefClonePlantGrape(RefClonePlantGrape.class, null, "refcloneplantgrape", new String[]{"codeClone", "codeVar"}, "codeClone"),
    RefCouvSolAnnuelle(RefCouvSolAnnuelle.class, null, "refcouvsolannuelle", new String[]{"debut_inter", "fin_inter", "vitesseCouv", "periodeSemis"}, "debut_inter", "fin_inter", "vitesseCouv", "periodeSemis"),
    RefCouvSolPerenne(RefCouvSolPerenne.class, null, "refcouvsolperenne", new String[]{"debut_inter", "fin_inter", "vitesseCouv", "phase"}, "debut_inter", "fin_inter", "vitesseCouv", "phase"),
    RefCultureAEE(RefCultureAEE.class, null, "refcultureaee", new String[]{"code_espece_botanique"}, "code_espece_botanique"),
    RefCultureEdiGroupeCouvSol(RefCultureEdiGroupeCouvSol.class, null, "refcultureedigroupecouvsol", new String[]{"code_espece_botanique", "code_qualifiant_aee", "code_type_saisonnier_aee", "code_destination_aee", "vitesseCouv", "typeCulture"}, "code_espece_botanique", "code_qualifiant_aee", "code_type_saisonnier_aee", "code_destination_aee"),
    RefDepartmentShape(RefDepartmentShape.class, null, "refdepartmentshape", new String[]{"department"}, "department"),
    RefElementVoisinage(RefElementVoisinage.class, null, "refelementvoisinage", new String[]{"id_ref_infrastructure"}, "id_ref_infrastructure"),
    RefEspece(RefEspece.class, null, "refespece", new String[]{"code_espece_botanique", "libelle_espece_botanique", "code_qualifiant_AEE", "code_type_saisonnier_AEE", "code_destination_AEE"}, "code_espece_botanique", "code_qualifiant_AEE", "code_type_saisonnier_AEE", "code_destination_AEE"),
    RefEspeceToVariete(RefEspeceToVariete.class, null, "refespecetovariete", new String[]{"code_espece_edi", "code_espece_autre_referentiel", "referentiel_source"}, "code_espece_edi", "code_espece_autre_referentiel"),
    RefFertiEngraisorg(RefFertiEngraisorg.class, null, "reffertiengraisorg", new String[]{"id_engraisorg"}, "id_engraisorg"),
    RefFertiMinUNIFA(RefFertiMinUNIFA.class, null, "reffertiminunifa", new String[]{"categ", "forme"}, "categ", "forme", "n", "p2O5", "k2O", "bore", "calcium", "fer", "manganese", "molybdene", "mgO", "oxyde_de_sodium", "sO3", "cuivre", "zinc"),
    RefFertiOrga(RefFertiOrga.class, null, "reffertiorga", new String[]{"idtypeeffluent"}, "idtypeeffluent"),
    RefGesCarburant(RefGesCarburant.class, null, "refgescarburant", new String[]{"libelle_carburant"}, "libelle_carburant"),
    RefGesEngrais(RefGesEngrais.class, null, "refgesengrais", new String[]{"type_engrais"}, "type_engrais"),
    RefGesPhyto(RefGesPhyto.class, null, "refgesphyto", new String[]{"intitule"}, "intitule"),
    RefGesSemence(RefGesSemence.class, null, "refgessemence", new String[]{"code_culture"}, "code_culture"),
    RefInterventionAgrosystTravailEDI(RefInterventionAgrosystTravailEDI.class, null, "refinterventionagrosysttravailedi", new String[]{"reference_code"}, "reference_code"),
    RefLegalStatus(RefLegalStatus.class, null, "reflegalstatus", ArrayUtils.EMPTY_STRING_ARRAY, "code_INSEE"),
    RefLienCulturesEdiActa(RefLienCulturesEdiActa.class, null, "reflienculturesediacta", new String[]{"code_espece_botanique", "code_qualifiant_aee", "code_type_saisonnier_aee", "code_destination_aee"}, "code_espece_botanique", "code_qualifiant_aee", "code_type_saisonnier_aee", "code_destination_aee"),
    RefLocation(RefLocation.class, null, "reflocation", new String[]{"codeInsee", "commune", "departement"}, "codeInsee"),
    RefMateriel(RefMateriel.class, null, "refmateriel", new String[]{"typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"}, "typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"),
    RefMaterielAutomoteur(RefMaterielAutomoteur.class, null, "refmaterielautomoteur", new String[]{"typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"}, "typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"),
    RefMaterielIrrigation(RefMaterielIrrigation.class, null, "refmaterielirrigation", new String[]{"typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"}, "typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"),
    RefMaterielOutil(RefMaterielOutil.class, null, "refmaterieloutil", new String[]{"typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"}, "typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"),
    RefMaterielTraction(RefMaterielTraction.class, null, "refmaterieltraction", new String[]{"typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"}, "typeMateriel1", "typeMateriel2", "typeMateriel3", "typeMateriel4", "uniteParAn"),
    RefMesure(RefMesure.class, null, "refmesure", new String[]{"variable_mesuree", "categorie_de_mesure"}, "variable_mesuree", "categorie_de_mesure", "type_variable_mesuree"),
    RefNrjCarburant(RefNrjCarburant.class, null, "refnrjcarburant", new String[]{"libelle_carburant"}, "libelle_carburant"),
    RefNrjEngrais(RefNrjEngrais.class, null, "refnrjengrais", new String[]{"type_engrais"}, "type_engrais"),
    RefNrjGesOutil(RefNrjGesOutil.class, null, "refnrjgesoutil", new String[]{"code_type_materiel"}, "code_type_materiel"),
    RefNrjPhyto(RefNrjPhyto.class, null, "refnrjphyto", new String[]{"intitule"}, "intitule"),
    RefNrjSemence(RefNrjSemence.class, null, "refnrjsemence", new String[]{"code_culture"}, "code_culture"),
    RefNuisibleEDI(RefNuisibleEDI.class, null, "refnuisibleedi", new String[]{"reference_id"}, "reference_id"),
    RefOTEX(RefOTEX.class, null, "refotex", new String[]{"code_OTEX_70_postes"}, "code_OTEX_70_postes"),
    RefOrientationEDI(RefOrientationEDI.class, null, "reforientationedi", new String[]{"reference_code", "reference_label"}, "reference_code"),
    RefParcelleZonageEDI(RefParcelleZonageEDI.class, null, "refparcellezonageedi", new String[]{"code_engagement_parcelle", "libelle_engagement_parcelle"}, "code_engagement_parcelle"),
    RefPhytoSubstanceActiveIphy(RefPhytoSubstanceActiveIphy.class, null, "refphytosubstanceactiveiphy", new String[]{"nom_sa"}, "nom_sa"),
    RefProtocoleVgObs(RefProtocoleVgObs.class, null, "refprotocolevgobs", new String[]{"protocole_code_protocole", "ligne_code_ligne_protocole", "releve_no_releve"}, "protocole_code_protocole", "ligne_code_ligne_protocole", "releve_no_releve", "releve_qualifiant_unite_mesure_code", "classe_no_classe"),
    RefSaActaIphy(RefSaActaIphy.class, null, "refsaactaiphy", new String[]{"nom_sa_acta"}, "nom_sa_acta"),
    RefSolArvalis(RefSolArvalis.class, null, "refsolarvalis", new String[]{"id_type_sol"}, "id_type_sol"),
    RefSolCaracteristiqueIndigo(RefSolCaracteristiqueIndigo.class, null, "refsolcaracteristiqueindigo", new String[]{"abbreviation_INDIGO", "classe_de_profondeur_INDIGO"}, "abbreviation_INDIGO", "classe_de_profondeur_INDIGO"),
    RefSolProfondeurIndigo(RefSolProfondeurIndigo.class, null, "refsolprofondeurindigo", new String[]{"classe_de_profondeur_INDIGO", "profondeur", "libelle_classe", "profondeur_par_defaut"}, "classe_de_profondeur_INDIGO"),
    RefSolTextureGeppa(RefSolTextureGeppa.class, null, "refsoltexturegeppa", new String[]{"abbreviation_classes_texturales_GEPAA", "classes_texturales_GEPAA", "abbreviation_INDIGO", "classe_INDIGO"}, "abbreviation_classes_texturales_GEPAA"),
    RefStadeEDI(RefStadeEDI.class, null, "refstadeedi", new String[]{"aee"}, "aee"),
    RefStadeNuisibleEDI(RefStadeNuisibleEDI.class, null, "refstadenuisibleedi", new String[]{"reference_id"}, "reference_id"),
    RefStationMeteo(RefStationMeteo.class, null, "refstationmeteo", new String[]{"affectation"}, "affectation"),
    RefSupportOrganeEDI(RefSupportOrganeEDI.class, null, "refsupportorganeedi", new String[]{"reference_id"}, "reference_id"),
    RefTraitSdC(RefTraitSdC.class, null, "reftraitsdc", new String[]{"id_trait"}, "id_trait"),
    RefTypeAgriculture(RefTypeAgriculture.class, null, "reftypeagriculture", new String[]{"reference_id"}, "reference_id"),
    RefTypeNotationEDI(RefTypeNotationEDI.class, null, "reftypenotationedi", new String[]{"reference_id"}, "reference_id"),
    RefTypeTravailEDI(RefTypeTravailEDI.class, null, "reftypetravailedi", new String[]{"reference_id"}, "reference_id"),
    RefUniteEDI(RefUniteEDI.class, null, "refuniteedi", new String[]{"reference_id"}, "reference_id"),
    RefUnitesQualifiantEDI(RefUnitesQualifiantEDI.class, null, "refunitesqualifiantedi", new String[]{"reference_id"}, "reference_id"),
    RefValeurQualitativeEDI(RefValeurQualitativeEDI.class, null, "refvaleurqualitativeedi", new String[]{"reference_id"}, "reference_id"),
    RefVariete(RefVariete.class, null, "refvariete", ArrayUtils.EMPTY_STRING_ARRAY),
    RefVarieteGeves(RefVarieteGeves.class, null, "refvarietegeves", new String[]{"denomination", "num_Dossier"}, "num_Dossier"),
    RefVarietePlantGrape(RefVarietePlantGrape.class, null, "refvarieteplantgrape", new String[]{"codeVar", "variete", "utilisation"}, "codeVar"),
    RefZoneClimatiqueIphy(RefZoneClimatiqueIphy.class, null, "refzoneclimatiqueiphy", new String[]{"departement"}, "departement"),
    RefRcesoCaseGroundWater(RefRcesoCaseGroundWater.class, null, "refrcesocasegroundwater", new String[]{"climate", "applicationPeriod", "surface_texture", "subsoil_texture"}, "climate", "applicationPeriod", "surface_texture", "subsoil_texture"),
    RefRcesoFuzzySetGroundWater(RefRcesoFuzzySetGroundWater.class, null, "refrcesofuzzysetgroundwater", new String[]{"caseNumber", "variables", "fuzzySet"}, "caseNumber", "variables", "fuzzySet"),
    RefRcesoRulesGroundWater(RefRcesoRulesGroundWater.class, null, "refrcesorulesgroundwater", new String[]{"caseNumber", "fset_orgc", "fset_depth", "fset_koc", "fset_dt50"}, "caseNumber", "fset_orgc", "fset_depth", "fset_koc", "fset_dt50"),
    RefRcesuRunoffPotRulesParc(RefRcesuRunoffPotRulesParc.class, null, "refrcesurunoffpotrulesparc", new String[]{"soil_texture", "battance", "hydromorphisms", "slope"}, "soil_texture", "battance", "hydromorphisms", "slope"),
    AgrosystUser(AgrosystUser.class, null, "agrosystuser", new String[]{"email", "lastName", "firstName", "password"}, "email"),
    ComputedUserPermission(ComputedUserPermission.class, null, "computeduserpermission", new String[]{"userId", "object", "action", "dirty", "type"}),
    HashedValue(HashedValue.class, null, "hashedvalue", new String[]{"hashed", "raw"}),
    StoredToken(StoredToken.class, null, "storedtoken", new String[]{"token", "userId"}, "token"),
    TrackedEvent(TrackedEvent.class, null, "trackedevent", ArrayUtils.EMPTY_STRING_ARRAY),
    UserRole(UserRole.class, null, "userrole", new String[]{"agrosystUser", "type"});

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The optional name of database schema of the entity (if none was filled, will be {@code null}).
     */
    protected String dbSchemaName;

    /**
     * The name of the database table for the entity.
     */
    protected String dbTableName;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    AgrosystEntityEnum(Class<? extends TopiaEntity> contract, String dbSchemaName, String dbTableName, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String dbSchemaName() {
        return dbSchemaName;
    }

    @Override
    public String dbTableName() {
        return dbTableName;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        AgrosystEntityEnum constant = valueOf(klass);
        boolean result = constant.getContract() == contract;
        return result;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
            try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static AgrosystEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static AgrosystEntityEnum valueOf(final Class<?> klass) {
        if (klass.isInterface()) {
            return valueOf(klass.getSimpleName());
        }

        Class<?> contractClass = TopiaEntityHelper.getContractClass(AgrosystEntityEnum.values(), (Class) klass);

        if (contractClass != null) {

            return valueOf(contractClass.getSimpleName());
        }

        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(AgrosystEntityEnum.values()));
    }

    public static AgrosystEntityEnum[] getContracts() {
        AgrosystEntityEnum[] result = values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        AgrosystEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        AgrosystEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        AgrosystEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        AgrosystEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

} //AgrosystEntityEnum
