package fr.inra.agrosyst.api;

/*
 * #%L
 * Agrosyst :: API
 * $Id: NavigationContext.java 3427 2014-02-24 10:15:49Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/NavigationContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Set;

import com.google.common.collect.Sets;

/**
 * Cette classe sert de conteneur pour les filtres de navigation dans l'IHM
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class NavigationContext implements Serializable {

    private static final long serialVersionUID = -7985384395667071478L;

    protected Set<Integer> campaigns = Sets.newHashSet();

    protected Set<String> networks = Sets.newHashSet();
    protected Set<String> domains = Sets.newHashSet();
    protected Set<String> growingPlans = Sets.newHashSet();
    protected Set<String> growingSystems = Sets.newHashSet();

    public NavigationContext() {
        
    }

    /**
     * Create new navigation context instance by coping other navigation context values.
     * 
     * @param other other navigation context to copy
     */
    public NavigationContext(NavigationContext other) {
        this();
        campaigns.addAll(other.campaigns);
        networks.addAll(other.networks);
        domains.addAll(other.domains);
        growingPlans.addAll(other.growingPlans);
        growingSystems.addAll(other.growingSystems);
    }

    public int getCampaignsCount() {
        return campaigns == null ? 0 : campaigns.size();
    }

    public Set<Integer> getCampaigns() {
        return campaigns;
    }

    public void setCampaigns(Set<Integer> campaigns) {
        this.campaigns = campaigns;
    }

    public int getNetworksCount() {
        return networks == null ? 0 : networks.size();
    }

    public Set<String> getNetworks() {
        return networks;
    }

    public void setNetworks(Set<String> networks) {
        this.networks = networks;
    }

    public int getDomainsCount() {
        return domains == null ? 0 : domains.size();
    }

    public Set<String> getDomains() {
        return domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    public int getGrowingPlansCount() {
        return growingPlans == null ? 0 : growingPlans.size();
    }

    public Set<String> getGrowingPlans() {
        return growingPlans;
    }

    public void setGrowingPlans(Set<String> growingPlans) {
        this.growingPlans = growingPlans;
    }

    public int getGrowingSystemsCount() {
        return growingSystems == null ? 0 : growingSystems.size();
    }

    public Set<String> getGrowingSystems() {
        return growingSystems;
    }

    public void setGrowingSystems(Set<String> growingSystems) {
        this.growingSystems = growingSystems;
    }

}
