/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.tree;

import fr.ifremer.tutti.ui.swing.content.genericformat.tree.CruiseSelectTreeNode;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeNodeSupport;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.OperationSelectTreeNode;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nuiton.i18n.I18n;

public class ExportDataSelectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private final JCheckBox normalCheckBox = new JCheckBox();
    private final JCheckBox partialCheckBox = new JCheckBox();
    private Font normalFont;
    private Font boldFont;

    public ExportDataSelectTreeCellRenderer() {
        Object iconPainter = UIManager.getDefaults().get("CheckBox[Disabled+Selected].iconPainter");
        UIDefaults defaults = new UIDefaults();
        defaults.put("CheckBox[Disabled].iconPainter", iconPainter);
        this.partialCheckBox.putClientProperty("Nimbus.Overrides", defaults);
        this.partialCheckBox.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        this.partialCheckBox.setEnabled(false);
        this.normalFont = UIManager.getFont("CheckBox.font");
        this.boldFont = this.normalFont.deriveFont(1);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String text = null;
        String tip = null;
        boolean filled = false;
        JCheckBox checkBox = this.normalCheckBox;
        if (value != null && value instanceof DataSelectTreeNodeSupport) {
            DataSelectTreeNodeSupport node = (DataSelectTreeNodeSupport)value;
            text = node.getLabel() + " (identifiant : " + node.getId() + ") ";
            filled = node.isSelected();
            if (node instanceof CruiseSelectTreeNode) {
                CruiseSelectTreeNode cruiseSelectTreeNode = (CruiseSelectTreeNode)node;
                if (filled) {
                    tip = I18n.t((String)"tutti.selectNode.cruiseSelected", (Object[])new Object[]{cruiseSelectTreeNode.getNbChildSelected()});
                } else if (cruiseSelectTreeNode.isPartialSelected()) {
                    checkBox = this.partialCheckBox;
                    text = text + String.format(" ( %d / %d )", cruiseSelectTreeNode.getNbChildSelected(), cruiseSelectTreeNode.getNbChilds());
                    tip = I18n.t((String)"tutti.selectNode.cruisePartialSelected", (Object[])new Object[]{cruiseSelectTreeNode.getNbChildSelected(), cruiseSelectTreeNode.getNbChilds()});
                }
            } else if (node instanceof OperationSelectTreeNode) {
                text = I18n.t((String)"tutti.selectNode.operation", (Object[])new Object[]{text});
                if (filled) {
                    tip = I18n.t((String)"tutti.selectNode.operationSelected", (Object[])new Object[]{text});
                }
            }
        }
        Font font = filled ? this.boldFont : this.normalFont;
        checkBox.setFont(font);
        checkBox.setSelected(filled);
        checkBox.setBackground(label.getBackground());
        checkBox.setForeground(label.getForeground());
        checkBox.setText(text);
        checkBox.setToolTipText(tip);
        return checkBox;
    }
}

