/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.EntityParserFormatterSupport;
import java.util.List;
import java.util.Map;

public class VesselParserFormatter
extends EntityParserFormatterSupport<Vessel> {
    private final PersistenceService persistenceService;
    private final Map<String, String> idTranslationMap;

    public static VesselParserFormatter newFormatter() {
        return new VesselParserFormatter(false, null, null);
    }

    public static VesselParserFormatter newTechnicalFormatter() {
        return new VesselParserFormatter(true, null, null);
    }

    public static VesselParserFormatter newParser(PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        return new VesselParserFormatter(true, persistenceService, idTranslationMap);
    }

    protected VesselParserFormatter(boolean technical, PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        super("", technical, Vessel.class);
        this.persistenceService = persistenceService;
        this.idTranslationMap = idTranslationMap;
    }

    @Override
    protected List<Vessel> getEntities() {
        return this.persistenceService.getAllVessel();
    }

    @Override
    public String formatBusiness(Vessel value) {
        String result = (String)Vessels.GET_REGISTRATION_CODE_OR_INTERNATIONAL_REGISTRATION_CODE.apply((Object)value);
        return result;
    }

    @Override
    protected Vessel parseNotBlankValue(String value) {
        if (this.idTranslationMap.containsKey(value)) {
            value = this.idTranslationMap.get(value);
        }
        return (Vessel)super.parseNotBlankValue(value);
    }
}

