/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUIModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ProgramSelectTreeNode;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class GenericFormatExportUIHandler
extends AbstractTuttiUIHandler<GenericFormatExportUIModel, GenericFormatExportUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(GenericFormatExportUIHandler.class);

    public void beforeInit(GenericFormatExportUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.getDataContext().resetValidationDataContext();
        GenericFormatExportUIModel model = new GenericFormatExportUIModel();
        ui.setContextValue(model);
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> propertyNamesToCanExport = Sets.newHashSet((Object[])new String[]{"program", "dataSelected"});

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenericFormatExportUIModel source = (GenericFormatExportUIModel)((Object)evt.getSource());
                String propertyName = evt.getPropertyName();
                if (this.propertyNamesToCanExport.contains(propertyName)) {
                    boolean canExport = source.computeIsCanExport();
                    source.setCanExport(canExport);
                }
                if ("program".equals(propertyName)) {
                    Program program = (Program)evt.getNewValue();
                    GenericFormatExportUIHandler.this.onProgramChanged(program);
                }
            }
        });
    }

    public void afterInit(GenericFormatExportUI ui) {
        this.initUI(ui);
        GenericFormatExportUIModel model = (GenericFormatExportUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getProgramComboBox(), Lists.newArrayList((Iterable)this.getPersistenceService().getAllProgram()), model.getProgram());
        SwingValidator<GenericFormatExportUIModel> validator = ui.getValidator();
        this.registerValidators(validator);
        JTree tree = ui.getDataSelectionTree();
        tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(tree);
        DataSelectTreeModel.installDataSelectionHandler(tree);
        DataSelectTreeModel treeModel = ui.getTreeModel();
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DataSelectTreeModel source = (DataSelectTreeModel)e.getSource();
                boolean dataSelected = source.isDataSelected();
                ((GenericFormatExportUIModel)((Object)GenericFormatExportUIHandler.this.getModel())).setDataSelected(dataSelected);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        if (this.getDataContext().isProgramFilled()) {
            Program program = this.getDataContext().getProgram();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using selected program " + program));
            }
            model.setProgram(program);
        }
    }

    protected JComponent getComponentToFocus() {
        return ((GenericFormatExportUI)this.getUI()).getProgramComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public boolean quitUI() {
        return true;
    }

    public SwingValidator<GenericFormatExportUIModel> getValidator() {
        return ((GenericFormatExportUI)this.ui).getValidator();
    }

    protected void onProgramChanged(Program program) {
        ProgramSelectTreeNode root;
        if (log.isInfoEnabled()) {
            log.info((Object)("Program changed: " + program));
        }
        if (program == null) {
            root = null;
        } else {
            ProgramDataModel dataModel = this.getPersistenceService().loadProgram(program.getId(), true);
            root = new ProgramSelectTreeNode(dataModel);
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)((GenericFormatExportUI)this.ui).getDataSelectionTree().getModel();
        treeModel.setRoot(root);
        ((GenericFormatExportUIModel)((Object)this.getModel())).setRootNode(root);
    }
}

