/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.QueryExecutionStrategyUtil;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.executor.transform.SimpleResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

public class CandidateQuery
extends BaseQuery
implements ICandidateQuery {
    private ICustomDataSet customDataSet;
    private IResultIterator resultObjsIterator;
    private int groupingLevel;
    private IResultClass resultMetadata;
    private DataEngineSession session;

    public CandidateQuery(DataEngineSession session) {
        this.session = session;
    }

    @Override
    public void setCandidates(IResultIterator resultObjsIterator, int groupingLevel) throws DataException {
        assert (resultObjsIterator != null);
        this.resultObjsIterator = resultObjsIterator;
        this.groupingLevel = groupingLevel;
        this.resultMetadata = resultObjsIterator.getResultClass();
    }

    @Override
    public void setCandidates(ICustomDataSet customDataSet) throws DataException {
        assert (customDataSet != null);
        this.customDataSet = customDataSet;
        this.resultMetadata = customDataSet.getResultClass();
    }

    @Override
    public IResultClass getResultClass() {
        return this.resultMetadata;
    }

    @Override
    public IResultIterator execute(IEventHandler eventHandler) throws DataException {
        if (this.customDataSet == null) {
            return new CachedResultSet(this, this.resultMetadata, this.resultObjsIterator, this.groupingLevel, eventHandler, this.session);
        }
        if (!this.session.getDataSetCacheManager().doesSaveToCache()) {
            IQueryDefinition queryDefn;
            QueryExecutionStrategyUtil.Strategy strategy;
            if ((this.session.getEngineContext().getMode() == 3 || this.session.getEngineContext().getMode() == 1) && this.getQueryDefinition() instanceof IQueryDefinition && (strategy = QueryExecutionStrategyUtil.getQueryExecutionStrategy(this.session, queryDefn, (queryDefn = (IQueryDefinition)this.getQueryDefinition()).getDataSetName() == null ? null : ((DataEngineImpl)this.session.getEngine()).getDataSetDesign(queryDefn.getDataSetName()))) != QueryExecutionStrategyUtil.Strategy.Complex) {
                SimpleResultSet simpleResult = new SimpleResultSet(this, this.customDataSet, this.resultMetadata, eventHandler, this.getGrouping(), this.session, strategy == QueryExecutionStrategyUtil.Strategy.SimpleLookingFoward);
                return simpleResult.getResultSetIterator();
            }
            return new CachedResultSet(this, this.customDataSet, eventHandler, this.session);
        }
        return new CachedResultSet((BaseQuery)this, this.resultMetadata, new DataSetToCache(this.customDataSet, this.resultMetadata, this.session), eventHandler, this.session);
    }

    @Override
    public void close() {
    }
}

