/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.csv.VesselModel;
import fr.ifremer.tutti.service.referential.csv.VesselRow;
import java.nio.file.Path;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class CsvConsumerForTemporaryVessel
extends CsvComsumer<VesselRow, VesselModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForTemporaryVessel.class);

    public CsvConsumerForTemporaryVessel(Path file, char separator, boolean reportError) {
        super(file, VesselModel.forImport(separator), reportError);
    }

    public void checkRow(ImportRow<VesselRow> row, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Vessel, String> requestResult) {
        if (row.isValid()) {
            VesselRow bean = (VesselRow)row.getBean();
            String id = bean.getId();
            boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
            if (StringUtils.isBlank((CharSequence)id)) {
                this.checkAdd(bean, requestResult);
            } else {
                Vessel vessel = requestResult.getExistingEntityById(id);
                if (vessel == null) {
                    throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.notExistingId", (Object[])new Object[]{id}));
                }
                if (delete) {
                    this.checkDelete(bean, vessel, persistenceService, decoratorService, requestResult);
                } else {
                    this.checkUpdate(bean, vessel, requestResult);
                }
            }
        }
        this.reportError(row);
    }

    public void checkRowForGenericFormatImport(ImportRow<VesselRow> row, ReferentialImportRequest<Vessel, String> requestResult) {
        VesselRow bean = (VesselRow)row.getBean();
        String internationalRegistrationCode = bean.getInternationalRegistrationCode();
        if (row.isValid()) {
            String id = bean.getId();
            if (id == null) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.noId", (Object[])new Object[0]))));
            } else if (!Vessels.isTemporaryId((String)id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.idNotTemporary", (Object[])new Object[]{id}))));
            } else if (requestResult.isIdAlreadyAdded(id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.id.alreaydAdded", (Object[])new Object[]{id}))));
            }
            if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.noRegistrationCode", (Object[])new Object[0]))));
            } else if (requestResult.isNaturalIdAlreadyAdded(internationalRegistrationCode)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.name.alreaydAdded", (Object[])new Object[]{internationalRegistrationCode}))));
            }
        }
        this.reportError(row);
        if (row.isValid()) {
            Vessel entity = bean.toEntity();
            boolean toAdd = requestResult.addExistingNaturalId(internationalRegistrationCode);
            if (toAdd) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will add vessel with internationalRegistrationCode: " + internationalRegistrationCode));
                }
                requestResult.addEntityToAdd(entity);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will link vessel with internationalRegistrationCode: " + internationalRegistrationCode));
                }
                requestResult.addEntityToLink(entity);
            }
        }
    }

    protected void checkAdd(VesselRow bean, ReferentialImportRequest<Vessel, String> requestResult) {
        String internationalRegistrationCode = bean.getInternationalRegistrationCode();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (delete) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.cannotDeleteWithoutId", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.noRegistrationCode", (Object[])new Object[0]));
        }
        if (!requestResult.addExistingNaturalId(internationalRegistrationCode)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.existingRegistrationCode", (Object[])new Object[]{internationalRegistrationCode}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will add vessel with internationalRegistrationCode: " + internationalRegistrationCode));
        }
        requestResult.addEntityToAdd(bean.toEntity());
    }

    protected void checkDelete(VesselRow bean, Vessel vessel, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Vessel, String> requestResult) {
        String id = StringUtils.trimToNull((String)bean.getId());
        String internationalRegistrationCode = bean.getInternationalRegistrationCode();
        if (persistenceService.isTemporaryVesselUsed(id)) {
            String vesselRef = id + " :" + decoratorService.getDecoratorByType(Vessel.class).toString((Object)vessel);
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.error.vessel.used", (Object[])new Object[]{vesselRef}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete vessel with internationalRegistrationCode: " + internationalRegistrationCode));
        }
        requestResult.addIdToDelete(id);
        requestResult.removeExistingNaturalId(internationalRegistrationCode);
    }

    protected void checkUpdate(VesselRow bean, Vessel vessel, ReferentialImportRequest<Vessel, String> requestResult) {
        String id = StringUtils.trimToNull((String)bean.getId());
        String internationalRegistrationCode = bean.getInternationalRegistrationCode();
        if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.noRegistrationCode", (Object[])new Object[]{id}));
        }
        if (!internationalRegistrationCode.equals(vessel.getName()) && !requestResult.addExistingNaturalId(internationalRegistrationCode)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.vessel.error.existingRegistrationCode", (Object[])new Object[]{internationalRegistrationCode}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will update vessel with internationalRegistrationCode: " + internationalRegistrationCode));
        }
        requestResult.addEntityToUpdate(bean.toEntity());
    }
}

