/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.report.ReportGenerationRequest;
import fr.ifremer.tutti.service.report.ReportGenerationResult;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIHandler;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import org.nuiton.i18n.I18n;

public class GenerateReportAction
extends AbstractTuttiAction<ReportUIModel, ReportUI, ReportUIHandler> {
    protected ReportGenerationResult reportGenerationResult;

    public GenerateReportAction(ReportUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            ((ReportUIModel)this.getModel()).setReportGenerationResult(null);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)((ReportUIModel)this.getModel()).isValid());
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(4);
        ReportGenerationRequest reportGenerationRequest = (ReportGenerationRequest)((ReportUIModel)this.getModel()).toBean();
        this.reportGenerationResult = this.getContext().getReportGenerationService().generateReport(reportGenerationRequest, progressionModel);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((ReportUIModel)this.getModel()).setReportGenerationResult(this.reportGenerationResult);
        this.sendMessage(I18n.t((String)"tutti.report.generated", (Object[])new Object[0]));
    }

    protected void releaseAction() {
        super.releaseAction();
        this.reportGenerationResult = null;
    }
}

