/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatchs;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchs;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatchs;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchBatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchBatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRowModel;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationIOUtil;

public class MultiPostImportService
extends AbstractTuttiService
implements MultiPostConstants {
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected SampleCategoryModel sampleCategoryModel;
    protected Map<String, CaracteristicQualitativeValue> sampleCategoryValueMap;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.sampleCategoryModel = context.getSampleCategoryModel();
        this.sampleCategoryValueMap = Maps.newTreeMap();
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            Caracteristic caracteristic = sampleCategoryModelEntry.getCaracteristic();
            if (caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) continue;
            List qualitativeValue = caracteristic.getQualitativeValue();
            for (CaracteristicQualitativeValue value : qualitativeValue) {
                this.sampleCategoryValueMap.put(value.getId(), value);
            }
        }
    }

    public Map<String, Object> importCatchBatch(final File file, final FishingOperation operation) {
        Callable<Map<String, Object>> call = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                CatchBatchRowModel weightsModel = new CatchBatchRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "catchBatch.csv", weightsModel, operation);
                HashMap notImportedData = Maps.newHashMap();
                CatchBatch catchBatch = MultiPostImportService.this.importCatchWeights(tempDir, operation, weightsModel, notImportedData);
                MultiPostImportService.this.importAttachments(tempDir, catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH);
                return notImportedData;
            }
        };
        Map<String, Object> result = this.persistenceService.invoke(call);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CatchBatch importCatchWeights(File file, FishingOperation operation, CatchBatchRowModel weightsModel, Map<String, Object> notImportedData) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "catchBatch.csv"), (String)I18n.n((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);
            try {
                Iterator iterator = importer.iterator();
                if (iterator.hasNext()) {
                    CatchBatchRow row = (CatchBatchRow)iterator.next();
                    CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
                    catchBatch.setFishingOperation(operation);
                    if (catchBatch.getCatchTotalWeight() == null) {
                        catchBatch.setCatchTotalWeight(row.getCatchTotalWeight());
                    } else if (row.getCatchTotalWeight() != null) {
                        notImportedData.put("catchTotalWeight", row.getCatchTotalWeight());
                    }
                    if (catchBatch.getCatchTotalRejectedWeight() == null) {
                        catchBatch.setCatchTotalRejectedWeight(row.getCatchTotalRejectedWeight());
                    } else if (row.getCatchTotalRejectedWeight() != null) {
                        notImportedData.put("catchTotalRejectedWeight", row.getCatchTotalRejectedWeight());
                    }
                    if (catchBatch.getSpeciesTotalSortedWeight() == null) {
                        catchBatch.setSpeciesTotalSortedWeight(row.getSpeciesTotalSortedWeight());
                    } else if (row.getSpeciesTotalSortedWeight() != null) {
                        notImportedData.put("speciesTotalSortedWeight", row.getSpeciesTotalSortedWeight());
                    }
                    if (catchBatch.getBenthosTotalSortedWeight() == null) {
                        catchBatch.setBenthosTotalSortedWeight(row.getBenthosTotalSortedWeight());
                    } else if (row.getBenthosTotalSortedWeight() != null) {
                        notImportedData.put("benthosTotalSortedWeight", row.getBenthosTotalSortedWeight());
                    }
                    if (catchBatch.getMarineLitterTotalWeight() == null) {
                        catchBatch.setMarineLitterTotalWeight(row.getMarineLitterTotalWeight());
                    } else if (row.getMarineLitterTotalWeight() != null) {
                        notImportedData.put("marineLitterTotalWeight", row.getMarineLitterTotalWeight());
                    }
                    this.persistenceService.saveCatchBatch(catchBatch);
                    CatchBatch catchBatch2 = catchBatch;
                    return catchBatch2;
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importAttachments(File directory, Integer catchBatchId, ObjectTypeCode objectType) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(directory, "attachments.csv"), (String)I18n.n((String)"tutti.service.multipost.import.attachments.error", (Object[])new Object[0]));
        try {
            AttachmentRowModel attachmentModel = new AttachmentRowModel(';', new File(directory, "attachments"));
            Import importer = Import.newImport((ImportModel)attachmentModel, (Reader)reader);
            try {
                for (AttachmentRow row : importer) {
                    Attachment attachment = Attachments.newAttachment();
                    attachment.setName(row.getName());
                    attachment.setComment(row.getComment());
                    attachment.setObjectType(objectType);
                    attachment.setObjectId(catchBatchId);
                    this.persistenceService.createAttachment(attachment, row.getFile());
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public Map<String, Object> importSpecies(final File file, final FishingOperation operation) {
        Callable<Map<String, Object>> call = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                CatchWeightsRowModel weightsModel = new CatchWeightsRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "weights.csv", weightsModel, operation);
                HashMap notImportedData = Maps.newHashMap();
                LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
                BatchContainer<SpeciesBatch> speciesBatches = MultiPostImportService.this.persistenceService.getRootSpeciesBatch(operation.getId(), false);
                TuttiDataContext dataContext = MultiPostImportService.this.context.getDataContext();
                List<Species> speciesList = dataContext.getReferentSpecies();
                Map<String, SpeciesBatch> batches = MultiPostImportService.this.importSpeciesBatches(tempDir, operation, speciesBatches, notImportedBatches, speciesList);
                List<Caracteristic> caracteristics = dataContext.getCaracteristics();
                MultiPostImportService.this.importSpeciesFrequencies(tempDir, batches, notImportedBatches, caracteristics);
                MultiPostImportService.this.importAttachments(tempDir, batches, notImportedBatches, ObjectTypeCode.BATCH);
                MultiPostImportService.this.importSpeciesWeights(tempDir, operation, weightsModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                return notImportedData;
            }
        };
        Map<String, Object> result = this.persistenceService.invoke(call);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SpeciesBatch> importSpeciesBatches(File file, FishingOperation operation, BatchContainer<SpeciesBatch> speciesBatches, Map<String, SpeciesBatch> notImportedBatches, List<Species> speciesList) {
        HashMap batches = Maps.newHashMap();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "species.csv"), (String)I18n.n((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[0]));
        try {
            CatchRowModel csvModel = new CatchRowModel(';', speciesList);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (CatchRow row : importer) {
                    SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
                    batch.setFishingOperation(operation);
                    Species species = row.getSpecies();
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setSpeciesToConfirm(row.isToConfirm());
                    Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
                    Integer categoryId = (Integer)valueAndCategoryType.getKey();
                    Serializable value = (Serializable)valueAndCategoryType.getValue();
                    batch.setSampleCategoryId(categoryId);
                    batch.setSampleCategoryValue(value);
                    batch.setSampleCategoryWeight(row.getCategoryWeight());
                    String parentId = row.getParentId();
                    String parentPersistedId = null;
                    SpeciesBatch parent = null;
                    if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                        parent = (SpeciesBatch)batches.get(parentId);
                        parentPersistedId = parent.getId();
                    }
                    SpeciesBatch existingBatch = null;
                    List batchesToBrowse = parent == null ? speciesBatches.getChildren() : parent.getChildBatchs();
                    if (batchesToBrowse != null) {
                        for (SpeciesBatch sb : batchesToBrowse) {
                            if (!sb.getSpecies().equals(species) || sb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !sb.getSampleCategoryValue().equals(value)) continue;
                            existingBatch = sb;
                            batches.put(row.getId(), sb);
                            notImportedBatches.put(row.getId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createSpeciesBatch(batch, parentPersistedId);
                    batches.put(row.getId(), batch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importSpeciesFrequencies(File file, Map<String, SpeciesBatch> batches, Map<String, SpeciesBatch> notImportedBatches, List<Caracteristic> caracteristics) {
        ArrayListMultimap frequencyMap = ArrayListMultimap.create();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "frequencies.csv"), (String)I18n.n((String)"tutti.service.multipost.import.frequencies.error", (Object[])new Object[0]));
        try {
            CatchFrequencyRowModel frequencyModel = new CatchFrequencyRowModel(';', caracteristics);
            Import importer = Import.newImport((ImportModel)frequencyModel, (Reader)reader);
            try {
                for (CatchFrequencyRow frequencyRow : importer) {
                    SpeciesBatch batch;
                    if (notImportedBatches.get(frequencyRow.getBatchId()) != null || (batch = batches.get(frequencyRow.getBatchId())) == null) continue;
                    SpeciesBatchFrequency frequency = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
                    frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
                    frequency.setLengthStep(frequencyRow.getLengthStep());
                    frequency.setNumber(frequencyRow.getNumber());
                    frequency.setWeight(frequencyRow.getWeight());
                    frequency.setBatch(batch);
                    frequencyMap.put((Object)batch.getId(), (Object)frequency);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        for (String batchId : frequencyMap.keySet()) {
            List frequencies = frequencyMap.get((Object)batchId);
            this.persistenceService.saveSpeciesBatchFrequency(batchId, frequencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importSpeciesWeights(File file, FishingOperation operation, CatchWeightsRowModel weightsModel, Map<String, Object> notImportedData) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "weights.csv"), (String)I18n.n((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);
            try {
                Iterator iterator = importer.iterator();
                if (iterator.hasNext()) {
                    CatchWeightsRow row = (CatchWeightsRow)iterator.next();
                    CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
                    catchBatch.setFishingOperation(operation);
                    if (catchBatch.getSpeciesTotalSortedWeight() == null) {
                        catchBatch.setSpeciesTotalSortedWeight(row.getTotalSortedWeight());
                    } else if (row.getTotalSortedWeight() != null) {
                        notImportedData.put("speciesTotalSortedWeight", row.getTotalSortedWeight());
                    }
                    if (catchBatch.getSpeciesTotalInertWeight() == null) {
                        catchBatch.setSpeciesTotalInertWeight(row.getInertWeight());
                    } else if (row.getInertWeight() != null) {
                        notImportedData.put("speciesTotalInertWeight", row.getInertWeight());
                    }
                    if (catchBatch.getSpeciesTotalLivingNotItemizedWeight() == null) {
                        catchBatch.setSpeciesTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
                    } else if (row.getLivingNotItemizedWeight() != null) {
                        notImportedData.put("speciesTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
                    }
                    this.persistenceService.saveCatchBatch(catchBatch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public Map<String, Object> importBenthos(final File file, final FishingOperation operation) {
        Callable<Map<String, Object>> call = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                CatchWeightsRowModel weightsModel = new CatchWeightsRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "weights.csv", weightsModel, operation);
                HashMap notImportedData = Maps.newHashMap();
                LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
                BatchContainer<BenthosBatch> benthosBatches = MultiPostImportService.this.persistenceService.getRootBenthosBatch(operation.getId(), false);
                TuttiDataContext dataContext = MultiPostImportService.this.context.getDataContext();
                List<Species> speciesList = dataContext.getReferentSpecies();
                Map<String, BenthosBatch> batches = MultiPostImportService.this.importBenthosBatches(tempDir, operation, benthosBatches, notImportedBatches, speciesList);
                MultiPostImportService.this.importBenthosFrequencies(tempDir, batches, notImportedBatches, dataContext.getCaracteristics());
                MultiPostImportService.this.importAttachments(tempDir, batches, notImportedBatches, ObjectTypeCode.BATCH);
                MultiPostImportService.this.importBenthosWeights(tempDir, operation, weightsModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                return notImportedData;
            }
        };
        Map<String, Object> result = this.persistenceService.invoke(call);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, BenthosBatch> importBenthosBatches(File file, FishingOperation operation, BatchContainer<BenthosBatch> benthosBatches, Map<String, BenthosBatch> notImportedBatches, List<Species> speciesList) {
        HashMap batches = Maps.newHashMap();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "benthos.csv"), (String)I18n.n((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[0]));
        try {
            CatchRowModel csvModel = new CatchRowModel(';', speciesList);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (CatchRow row : importer) {
                    BenthosBatch batch = BenthosBatchs.newBenthosBatch();
                    batch.setFishingOperation(operation);
                    Species species = row.getSpecies();
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setSpeciesToConfirm(row.isToConfirm());
                    Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
                    Integer categoryId = (Integer)valueAndCategoryType.getKey();
                    Serializable value = (Serializable)valueAndCategoryType.getValue();
                    batch.setSampleCategoryId(categoryId);
                    batch.setSampleCategoryValue(value);
                    batch.setSampleCategoryWeight(row.getCategoryWeight());
                    String parentId = row.getParentId();
                    String parentPersistedId = null;
                    BenthosBatch parent = null;
                    if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                        parent = (BenthosBatch)batches.get(parentId);
                        parentPersistedId = parent.getId();
                    }
                    BenthosBatch existingBatch = null;
                    List batchesToBrowse = parent == null ? benthosBatches.getChildren() : parent.getChildBatchs();
                    if (batchesToBrowse != null) {
                        for (BenthosBatch bb : batchesToBrowse) {
                            if (!bb.getSpecies().equals(species) || bb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !bb.getSampleCategoryValue().equals(value)) continue;
                            existingBatch = bb;
                            batches.put(row.getId(), bb);
                            notImportedBatches.put(row.getId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createBenthosBatch(batch, parentPersistedId);
                    batches.put(row.getId(), batch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importBenthosFrequencies(File file, Map<String, BenthosBatch> batches, Map<String, BenthosBatch> notImportedBatches, List<Caracteristic> caracteristics) {
        ArrayListMultimap frequencyMap = ArrayListMultimap.create();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "frequencies.csv"), (String)I18n.n((String)"tutti.service.multipost.import.frequencies.error", (Object[])new Object[0]));
        try {
            CatchFrequencyRowModel frequencyModel = new CatchFrequencyRowModel(';', caracteristics);
            Import importer = Import.newImport((ImportModel)frequencyModel, (Reader)reader);
            try {
                for (CatchFrequencyRow frequencyRow : importer) {
                    BenthosBatch batch;
                    if (notImportedBatches.get(frequencyRow.getBatchId()) != null || (batch = batches.get(frequencyRow.getBatchId())) == null) continue;
                    BenthosBatchFrequency frequency = BenthosBatchFrequencys.newBenthosBatchFrequency();
                    frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
                    frequency.setLengthStep(frequencyRow.getLengthStep());
                    frequency.setNumber(frequencyRow.getNumber());
                    frequency.setWeight(frequencyRow.getWeight());
                    frequency.setBatch(batch);
                    frequencyMap.put((Object)batch.getId(), (Object)frequency);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        for (String batchId : frequencyMap.keySet()) {
            List frequencies = frequencyMap.get((Object)batchId);
            this.persistenceService.saveBenthosBatchFrequency(batchId, frequencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importBenthosWeights(File file, FishingOperation operation, CatchWeightsRowModel weightsModel, Map<String, Object> notImportedData) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "weights.csv"), (String)I18n.n((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);
            try {
                Iterator iterator = importer.iterator();
                if (iterator.hasNext()) {
                    CatchWeightsRow row = (CatchWeightsRow)iterator.next();
                    CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
                    catchBatch.setFishingOperation(operation);
                    if (catchBatch.getBenthosTotalSortedWeight() == null) {
                        catchBatch.setBenthosTotalSortedWeight(row.getTotalSortedWeight());
                    } else if (row.getTotalSortedWeight() != null) {
                        notImportedData.put("benthosTotalSortedWeight", row.getTotalSortedWeight());
                    }
                    if (catchBatch.getBenthosTotalInertWeight() == null) {
                        catchBatch.setBenthosTotalInertWeight(row.getInertWeight());
                    } else if (row.getInertWeight() != null) {
                        notImportedData.put("benthosTotalInertWeight", row.getInertWeight());
                    }
                    if (catchBatch.getBenthosTotalLivingNotItemizedWeight() == null) {
                        catchBatch.setBenthosTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
                    } else if (row.getLivingNotItemizedWeight() != null) {
                        notImportedData.put("benthosTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
                    }
                    this.persistenceService.saveCatchBatch(catchBatch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public Map<String, Object> importMarineLitter(final File file, final FishingOperation operation) {
        Callable<Map<String, Object>> call = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "weights.csv", weightModel, operation);
                String operationId = operation.getId();
                HashMap notImportedData = Maps.newHashMap();
                LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
                BatchContainer<MarineLitterBatch> marineLitterBatches = MultiPostImportService.this.persistenceService.getRootMarineLitterBatch(operationId);
                List categoryValues = MultiPostImportService.this.persistenceService.getMarineLitterCategoryCaracteristic().getQualitativeValue();
                List sizeCategoryValues = MultiPostImportService.this.persistenceService.getMarineLitterSizeCategoryCaracteristic().getQualitativeValue();
                Map<String, MarineLitterBatch> batches = MultiPostImportService.this.importMarineLitterBatches(tempDir, operation, categoryValues, sizeCategoryValues, marineLitterBatches, notImportedBatches);
                MultiPostImportService.this.importAttachments(tempDir, batches, notImportedBatches, ObjectTypeCode.BATCH);
                MultiPostImportService.this.importMarineLitterCatchWeights(tempDir, operation, weightModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                return notImportedData;
            }
        };
        Map<String, Object> result = this.persistenceService.invoke(call);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, MarineLitterBatch> importMarineLitterBatches(File file, FishingOperation operation, List<CaracteristicQualitativeValue> categoryValues, List<CaracteristicQualitativeValue> sizeCategoryValues, BatchContainer<MarineLitterBatch> marineLitterBatches, Map<String, MarineLitterBatch> notImportedBatches) {
        LinkedHashMap batches = Maps.newLinkedHashMap();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "marineLitter.csv"), (String)I18n.n((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[0]));
        try {
            MarineLitterRowModel csvModel = new MarineLitterRowModel(';', categoryValues, sizeCategoryValues);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (MarineLitterRow row : importer) {
                    MarineLitterBatch batch = MarineLitterBatchs.newMarineLitterBatch();
                    batch.setFishingOperation(operation);
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setMarineLitterCategory(row.getCategory());
                    batch.setMarineLitterSizeCategory(row.getSizeCategory());
                    MarineLitterBatch existingBatch = null;
                    List batchesToBrowse = marineLitterBatches.getChildren();
                    if (batchesToBrowse != null) {
                        for (MarineLitterBatch mlb : batchesToBrowse) {
                            if (!mlb.getMarineLitterCategory().equals(batch.getMarineLitterCategory()) || !mlb.getMarineLitterSizeCategory().equals(batch.getMarineLitterSizeCategory())) continue;
                            existingBatch = mlb;
                            batches.put(row.getBatchId(), mlb);
                            notImportedBatches.put(row.getBatchId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createMarineLitterBatch(batch);
                    batches.put(row.getBatchId(), batch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return batches;
    }

    protected void importMarineLitterCatchWeights(File file, FishingOperation operation, MarineLitterWeightRowModel weightModel, Map<String, Object> notImportedData) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "weights.csv"), (String)I18n.n((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[0]));
        Import weight = Import.newImport((ImportModel)weightModel, (Reader)reader);
        Iterator iterator = weight.iterator();
        if (iterator.hasNext()) {
            MarineLitterWeightRow row = (MarineLitterWeightRow)iterator.next();
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
            catchBatch.setFishingOperation(operation);
            if (catchBatch.getMarineLitterTotalWeight() == null) {
                catchBatch.setMarineLitterTotalWeight(row.getTotalWeight());
            } else if (row.getTotalWeight() != null) {
                notImportedData.put("marineLitterTotalWeight", row.getTotalWeight());
            }
            this.persistenceService.saveCatchBatch(catchBatch);
        }
    }

    public void importIndividualObservation(final File file, final FishingOperation operation) {
        Callable<Void> call = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                FishingOperationRowModel operationModel = new FishingOperationRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "weights.csv", operationModel, operation);
                TuttiDataContext dataContext = MultiPostImportService.this.context.getDataContext();
                List<Species> speciesList = dataContext.getReferentSpecies();
                List<Caracteristic> caracteristics = dataContext.getCaracteristicWithProtected();
                Map<String, IndividualObservationBatch> batches = MultiPostImportService.this.importIndividualObservationBatches(tempDir, operation, speciesList, caracteristics);
                MultiPostImportService.this.importIndividualObservationCaracteristics(tempDir, batches, caracteristics);
                for (IndividualObservationBatch batch : batches.values()) {
                    MultiPostImportService.this.persistenceService.createIndividualObservationBatch(batch);
                }
                MultiPostImportService.this.importAttachments(tempDir, batches, ObjectTypeCode.SAMPLE);
                return null;
            }
        };
        this.persistenceService.invoke(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IndividualObservationBatch> importIndividualObservationBatches(File file, FishingOperation operation, List<Species> speciesList, List<Caracteristic> caracteristics) {
        LinkedHashMap batches = Maps.newLinkedHashMap();
        IndividualObservationRowModel csvModel = new IndividualObservationRowModel(';', speciesList, caracteristics);
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "individualObservation.csv"), (String)I18n.n((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (IndividualObservationRow row : importer) {
                    IndividualObservationBatch batch = IndividualObservationBatchs.newIndividualObservationBatch();
                    batch.setFishingOperation(operation);
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setSize(row.getSize());
                    batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
                    batch.setComment(row.getComment());
                    batch.setCaracteristics(new CaracteristicMap());
                    batches.put(row.getBatchId(), batch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importIndividualObservationCaracteristics(File file, Map<String, IndividualObservationBatch> batches, List<Caracteristic> caracteristics) {
        CaracteristicRowModel caracteristicModel = new CaracteristicRowModel(';', caracteristics);
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "caracteristics.csv"), (String)I18n.n((String)"tutti.service.multipost.import.caracteristics.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)caracteristicModel, (Reader)reader);
            try {
                for (CaracteristicRow caracteristicRow : importer) {
                    IndividualObservationBatch batch = batches.get(caracteristicRow.getBatchId());
                    if (batch == null) continue;
                    Caracteristic caracteristic = caracteristicRow.getCaracteristic();
                    Serializable value = caracteristicRow.getValue();
                    switch (caracteristic.getCaracteristicType()) {
                        case QUALITATIVE: {
                            value = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)Integer.parseInt(value.toString()));
                            break;
                        }
                        case NUMBER: {
                            value = Float.valueOf(Float.parseFloat(value.toString()));
                        }
                    }
                    CaracteristicMap map = batch.getCaracteristics();
                    map.put((Object)caracteristic, (Object)value);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public void importAccidentalCatches(final File file, final FishingOperation operation) {
        Callable<Void> call = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                File tempDir = ApplicationIOUtil.explodeZip((File)MultiPostImportService.this.context.getConfig().getTmpDirectory(), (File)file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
                FishingOperationRowModel operationModel = new FishingOperationRowModel(';');
                MultiPostImportService.this.checkSameOperation(tempDir, "weights.csv", operationModel, operation);
                TuttiDataContext dataContext = MultiPostImportService.this.context.getDataContext();
                List<Species> speciesList = dataContext.getReferentSpecies();
                List<CaracteristicQualitativeValue> genderValues = dataContext.getGenderValues();
                List<Caracteristic> caracteristics = dataContext.getCaracteristicWithProtected();
                List<CaracteristicQualitativeValue> dedOrAliveValues = dataContext.getDeadOrAliveValues();
                Map<String, AccidentalBatch> batches = MultiPostImportService.this.importAccidentalCatchesBatches(tempDir, operation, speciesList, genderValues, caracteristics, dedOrAliveValues);
                MultiPostImportService.this.importAccidentalCatchesCaracteristics(tempDir, batches, caracteristics);
                for (AccidentalBatch batch : batches.values()) {
                    MultiPostImportService.this.persistenceService.createAccidentalBatch(batch);
                }
                MultiPostImportService.this.importAttachments(tempDir, batches, ObjectTypeCode.SAMPLE);
                return null;
            }
        };
        this.persistenceService.invoke(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, AccidentalBatch> importAccidentalCatchesBatches(File file, FishingOperation operation, List<Species> speciesList, List<CaracteristicQualitativeValue> genderValues, List<Caracteristic> caracteristics, List<CaracteristicQualitativeValue> dedOrAliveValues) {
        LinkedHashMap batches = Maps.newLinkedHashMap();
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "accidentalCatches.csv"), (String)I18n.n((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[0]));
        try {
            AccidentalCatchRowModel csvModel = new AccidentalCatchRowModel(';', speciesList, genderValues, caracteristics, dedOrAliveValues);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (AccidentalCatchRow row : importer) {
                    AccidentalBatch batch = AccidentalBatchs.newAccidentalBatch();
                    batch.setFishingOperation(operation);
                    batch.setSpecies(row.getSpecies());
                    batch.setGender(row.getGender());
                    batch.setWeight(row.getWeight());
                    batch.setSize(row.getSize());
                    batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
                    batch.setDeadOrAlive(row.getDeadOrAlive());
                    batch.setComment(row.getComment());
                    batch.setCaracteristics(new CaracteristicMap());
                    batches.put(row.getBatchId(), batch);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importAccidentalCatchesCaracteristics(File file, Map<String, AccidentalBatch> batches, List<Caracteristic> caracteristics) {
        CaracteristicRowModel caracteristicModel = new CaracteristicRowModel(';', caracteristics);
        Reader reader = ApplicationIOUtil.newReader((File)new File(file, "caracteristics.csv"), (String)I18n.n((String)"tutti.service.multipost.import.caracteristics.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport((ImportModel)caracteristicModel, (Reader)reader);
            try {
                for (CaracteristicRow caracteristicRow : importer) {
                    AccidentalBatch batch = batches.get(caracteristicRow.getBatchId());
                    if (batch == null) continue;
                    Caracteristic caracteristic = caracteristicRow.getCaracteristic();
                    Serializable value = caracteristicRow.getValue();
                    switch (caracteristic.getCaracteristicType()) {
                        case QUALITATIVE: {
                            value = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)Integer.parseInt(value.toString()));
                            break;
                        }
                        case NUMBER: {
                            value = Float.valueOf(Float.parseFloat(value.toString()));
                        }
                    }
                    CaracteristicMap map = batch.getCaracteristics();
                    map.put((Object)caracteristic, (Object)value);
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected Pair<Integer, Serializable> getValueAndCategoryType(CatchRow row) {
        Serializable value = row.getCategoryValue();
        Integer categoryId = row.getCategoryId();
        SampleCategoryModelEntry categoryModelEntry = this.sampleCategoryModel.getCategoryById(categoryId);
        Caracteristic caracteristic = categoryModelEntry.getCaracteristic();
        if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            CaracteristicQualitativeValue caracteristicQualitativeValue = this.sampleCategoryValueMap.get(String.valueOf(value));
            Preconditions.checkNotNull((Object)caracteristicQualitativeValue, (Object)("Can't find caracteristic qualitative value with id: " + value + " for caracteristic of id: " + categoryId));
            value = caracteristicQualitativeValue;
        }
        return Pair.of((Object)categoryId, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <FO extends AbstractFishingOperationRow> void checkSameOperation(File directory, String fileName, AbstractFishingOperationRowModel<FO> fishingOperationRowModel, FishingOperation operation) {
        Reader reader = ApplicationIOUtil.newReader((File)new File(directory, fileName), (String)I18n.n((String)"tutti.service.multipost.import.operation.error", (Object[])new Object[0]));
        try {
            Import importer = Import.newImport(fishingOperationRowModel, (Reader)reader);
            Iterator iterator = importer.iterator();
            try {
                if (iterator.hasNext()) {
                    AbstractFishingOperationRow row = (AbstractFishingOperationRow)iterator.next();
                    Date rowDate = this.dateWithNoTime(row.getDate());
                    Date operationDate = this.dateWithNoTime(operation.getGearShootingStartDate());
                    if (ObjectUtils.notEqual((Object)row.getStationNumber(), (Object)operation.getStationNumber()) || ObjectUtils.notEqual((Object)row.getOperationNumber(), (Object)operation.getFishingOperationNumber()) || ObjectUtils.notEqual((Object)row.getMultirigAggregation(), (Object)operation.getMultirigAggregation()) || ObjectUtils.notEqual((Object)rowDate, (Object)operationDate)) {
                        throw new ApplicationBusinessException(I18n.t((String)"tutti.service.multipost.import.wrongOperation.error", (Object[])new Object[]{this.decoratorService.getDecoratorByType(FishingOperation.class).toString((Object)operation)}));
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends TuttiEntity> void importAttachments(File directory, final Map<String, R> data, final Map<String, R> notImportedData, ObjectTypeCode objectType) {
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                TuttiEntity batch;
                Integer result = null;
                if (notImportedData.get(input.getBatchId()) == null && (batch = (TuttiEntity)data.get(input.getBatchId())) != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        Reader reader = ApplicationIOUtil.newReader((File)new File(directory, "attachments.csv"), (String)I18n.n((String)"tutti.service.multipost.import.attachments.error", (Object[])new Object[0]));
        try {
            AttachmentRowModel attachmentModel = new AttachmentRowModel(';', new File(directory, "attachments"));
            Import importer = Import.newImport((ImportModel)attachmentModel, (Reader)reader);
            try {
                for (AttachmentRow row : importer) {
                    Integer objectId = (Integer)getObjetcIdFunction.apply((Object)row);
                    if (objectId == null) continue;
                    Attachment attachment = Attachments.newAttachment();
                    attachment.setName(row.getName());
                    attachment.setComment(row.getComment());
                    attachment.setObjectType(objectType);
                    attachment.setObjectId(objectId);
                    this.persistenceService.createAttachment(attachment, row.getFile());
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected Date dateWithNoTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends TuttiEntity> void importAttachments(File directory, final Map<String, R> data, ObjectTypeCode objectType) {
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                Integer result = null;
                TuttiEntity batch = (TuttiEntity)data.get(input.getBatchId());
                if (batch != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        Reader reader = ApplicationIOUtil.newReader((File)new File(directory, "attachments.csv"), (String)I18n.n((String)"tutti.service.multipost.import.attachments.error", (Object[])new Object[0]));
        try {
            AttachmentRowModel attachmentModel = new AttachmentRowModel(';', new File(directory, "attachments"));
            Import importer = Import.newImport((ImportModel)attachmentModel, (Reader)reader);
            try {
                for (AttachmentRow row : importer) {
                    Integer objectId = (Integer)getObjetcIdFunction.apply((Object)row);
                    if (objectId == null) continue;
                    Attachment attachment = Attachments.newAttachment();
                    attachment.setName(row.getName());
                    attachment.setComment(row.getComment());
                    attachment.setObjectType(objectType);
                    attachment.setObjectId(objectId);
                    this.persistenceService.createAttachment(attachment, row.getFile());
                }
                ApplicationIOUtil.close((Closeable)importer, (String)"Could not close importer");
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ApplicationIOUtil.close((Closeable)reader, (String)"Could not close reader");
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

