/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.util.IOUtil;

public class RowIndexUtil {
    private DataOutputStream rowDos;
    private DataInputStream rowDis;
    private static Logger logger = Logger.getLogger(RowIndexUtil.class.getName());

    public RowIndexUtil(OutputStream rowOs) {
        this.rowDos = new DataOutputStream(rowOs);
    }

    public RowIndexUtil(InputStream rowIs) {
        this.rowDis = new DataInputStream(rowIs);
    }

    public void write(int rowId) {
        try {
            IOUtil.writeInt(this.rowDos, rowId);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    public int read() {
        try {
            return IOUtil.readInt(this.rowDis);
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void close() {
        try {
            if (this.rowDos != null) {
                this.rowDos.close();
            }
            if (this.rowDis != null) {
                this.rowDis.close();
            }
        }
        catch (IOException iOException) {}
    }
}

