/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept;

import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class SynchroInterceptorBase
implements SynchroInterceptor {
    private SynchroInterceptor next;
    private boolean enableOnRead = false;
    private boolean enableOnWrite = false;
    private SynchroDatabaseConfiguration config;

    public SynchroInterceptorBase() {
        this.next = null;
    }

    @Override
    public boolean apply(SynchroDatabaseConfiguration config) {
        this.config = config;
        return true;
    }

    public SynchroInterceptorBase(SynchroInterceptor next) {
        this.next = next;
    }

    @Override
    public SynchroInterceptorBase clone() {
        try {
            SynchroInterceptorBase newInstance = (SynchroInterceptorBase)this.getClass().newInstance();
            newInstance.config = this.config;
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException(String.format("Could not clone the interceptor class %s. Make sure method clone() has been implemented.", this.getClass().getName()));
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException(String.format("Could not clone the interceptor class %s. Make sure method clone() has been implemented.", this.getClass().getName()));
        }
    }

    @Override
    public boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return false;
    }

    @Override
    public void setNext(SynchroInterceptor next) {
        this.next = next;
    }

    @Override
    public SynchroInterceptor getNext() {
        return this.next;
    }

    @Override
    public final void close() throws IOException {
        this.doClose();
        if (this.next != null) {
            this.next.close();
        }
    }

    @Override
    public final void onRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
        this.doOnRead(data, sourceDao, targetDao);
        if (this.next != null) {
            this.next.onRead(data, sourceDao, targetDao);
        }
    }

    @Override
    public final void onWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        this.doOnWrite(data, pk, sourceDao, targetDao, buffer);
        if (this.next != null) {
            this.next.onWrite(data, pk, sourceDao, targetDao, buffer);
        }
    }

    @Override
    public final void onDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        this.doOnDelete(pk, sourceDao, targetDao, buffer);
        if (this.next != null) {
            this.next.onDelete(pk, sourceDao, targetDao, buffer);
        }
    }

    @Override
    public final void onDetach(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        this.doOnDetach(pk, sourceDao, targetDao, buffer);
        if (this.next != null) {
            this.next.onDetach(pk, sourceDao, targetDao, buffer);
        }
    }

    @Override
    public boolean enableOnRead() {
        return this.enableOnRead;
    }

    @Override
    public boolean enableOnWrite() {
        return this.enableOnWrite;
    }

    public void setEnableOnRead(boolean enableOnRead) {
        this.enableOnRead = enableOnRead;
    }

    public void setEnableOnWrite(boolean enableOnWrite) {
        this.enableOnWrite = enableOnWrite;
    }

    protected SynchroDatabaseConfiguration getDefaultDatabaseConfiguration() {
        return this.config;
    }

    protected void doClose() throws IOException {
    }

    protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
    }

    protected void doOnDetach(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
    }

    protected boolean hasColumns(TableMetadata table, String ... columnNames) {
        Map<String, ColumnMetadata> delegateColumns = SynchroTableMetadata.getColumns(table);
        for (String columnName : columnNames) {
            if (delegateColumns.containsKey(columnName.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasColumns(SynchroTableMetadata table, String ... columnNames) {
        Set<String> delegateColumns = table.getColumnNames();
        for (String columnName : columnNames) {
            if (delegateColumns.contains(columnName.toLowerCase())) continue;
            return false;
        }
        return true;
    }
}

