/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.attachment.SaveAttachmentAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class AttachmentEditorUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, AttachmentEditorUI> {
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected Action closeAction;
    protected Action openAction;

    public void afterInit(AttachmentEditorUI ui) {
        ui.getFile().setDialogOwner((JDialog)ui);
        ui.pack();
        ui.setResizable(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{ui});
        JRootPane rootPane = ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        this.closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AttachmentEditorUI)AttachmentEditorUIHandler.this.ui).dispose();
                ((AttachmentEditorUI)AttachmentEditorUIHandler.this.ui).setVisible(false);
            }
        };
        this.openAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AttachmentEditorUI)AttachmentEditorUIHandler.this.ui).setVisible(true);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        this.closeAction.putValue("SmallIcon", actionIcon);
        this.closeAction.putValue("SwingLargeIconKey", actionIcon);
        this.closeAction.putValue("ActionCommandKey", "close");
        this.closeAction.putValue("Name", "close");
        this.closeAction.putValue("ShortDescription", I18n.t((String)"tutti.attachmentEditor.action.closeAttachment.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        ui.getAttachmentBody().setRightDecoration((JComponent)jToolBar);
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentEditorUI)this.getUI()).getFile();
    }

    public void onCloseUI() {
    }

    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        List<Attachment> list;
        this.resetFields();
        ((AttachmentEditorUI)this.ui).getAttachments().removeAll();
        AttachmentModelAware bean = ((AttachmentEditorUI)this.ui).getBean();
        if (bean != null && (list = bean.getAttachment()) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        ((AttachmentEditorUI)this.ui).pack();
        if (x + ((AttachmentEditorUI)this.ui).getWidth() > ((AttachmentEditorUI)this.ui).getOwner().getX() + ((AttachmentEditorUI)this.ui).getOwner().getWidth()) {
            x = x - ((AttachmentEditorUI)this.ui).getWidth() + component.getWidth();
        }
        ((AttachmentEditorUI)this.ui).setLocation(x, y);
    }

    public void addAttachment() {
        AttachmentModelAware bean = ((AttachmentEditorUI)this.ui).getBean();
        Attachment attachment = Attachments.newAttachment();
        File file = ((AttachmentEditorUI)this.ui).getFile().getSelectedFile();
        if (file != null) {
            String name = ((AttachmentEditorUI)this.ui).getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            attachment.setObjectType(bean.getObjectType());
            attachment.setObjectId(bean.getObjectId());
            attachment.setName(name);
            attachment.setComment(((AttachmentEditorUI)this.ui).getFileComment().getText());
            attachment = this.getPersistenceService().createAttachment(attachment, file);
            bean.addAttachment(attachment);
            this.resetFields();
            this.addAttachment(attachment);
            ((AttachmentEditorUI)this.ui).pack();
        }
    }

    protected void addAttachment(Attachment attachment) {
        AttachmentItem item = new AttachmentItem();
        item.setAttachment(attachment);
        item.setHandler(this);
        ((AttachmentEditorUI)this.ui).getAttachments().add(item);
    }

    protected void resetFields() {
        ((AttachmentEditorUI)this.ui).getFile().setSelectedFilePath(null);
        ((AttachmentEditorUI)this.ui).getFileName().setText("");
        ((AttachmentEditorUI)this.ui).getFileComment().setText("");
    }

    public void openAttachment(Attachment attachment) {
        File file = this.getPersistenceService().getAttachmentFile(attachment.getId());
        if (!file.exists()) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.attachmentEditor.fileNotFound", (Object[])new Object[]{file.getAbsolutePath()}));
        }
        TuttiUIUtil.openResource(file);
    }

    public void saveAttachment(Attachment attachment) {
        SaveAttachmentAction action = (SaveAttachmentAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, SaveAttachmentAction.class);
        action.setAttachment(attachment);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)action);
    }

    public void removeAttachment(AttachmentItem attachmentItem) {
        Attachment attachment = attachmentItem.getAttachment();
        boolean hackDialog = ((AttachmentEditorUI)this.ui).isAlwaysOnTop();
        if (hackDialog) {
            ((AttachmentEditorUI)this.ui).setAlwaysOnTop(false);
        }
        int answer = JOptionPane.showConfirmDialog((Component)this.ui, I18n.t((String)"tutti.attachmentEditor.deleteAttachment.message", (Object[])new Object[]{attachment.getName()}), I18n.t((String)"tutti.attachmentEditor.deleteAttachment.title", (Object[])new Object[0]), 0);
        if (hackDialog) {
            ((AttachmentEditorUI)this.ui).setAlwaysOnTop(true);
        }
        if (answer == 0) {
            AttachmentModelAware bean = ((AttachmentEditorUI)this.ui).getBean();
            this.getPersistenceService().deleteAttachment(attachment.getId());
            bean.removeAttachment(attachment);
            ((AttachmentEditorUI)this.ui).getAttachments().remove(attachmentItem);
            ((AttachmentEditorUI)this.ui).pack();
        }
    }
}

