/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Rotation3D;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.impl.ChartImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChartWithAxesImpl
extends ChartImpl
implements ChartWithAxes {
    protected EList<Axis> axes;
    protected Fill wallFill;
    protected Fill floorFill;
    protected static final Orientation ORIENTATION_EDEFAULT = Orientation.VERTICAL_LITERAL;
    protected Orientation orientation = ORIENTATION_EDEFAULT;
    protected boolean orientationESet;
    protected static final double UNIT_SPACING_EDEFAULT = 50.0;
    protected double unitSpacing = 50.0;
    protected boolean unitSpacingESet;
    protected Rotation3D rotation;
    protected static final boolean REVERSE_CATEGORY_EDEFAULT = false;
    protected boolean reverseCategory = false;
    protected boolean reverseCategoryESet;
    protected static final boolean STUDY_LAYOUT_EDEFAULT = false;
    protected boolean studyLayout = false;
    protected boolean studyLayoutESet;

    protected ChartWithAxesImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.CHART_WITH_AXES;
    }

    @Override
    public EList<Axis> getAxes() {
        if (this.axes == null) {
            this.axes = new EObjectContainmentEList(Axis.class, (InternalEObject)this, 15);
        }
        return this.axes;
    }

    @Override
    public Fill getWallFill() {
        return this.wallFill;
    }

    public NotificationChain basicSetWallFill(Fill newWallFill, NotificationChain msgs) {
        Fill oldWallFill = this.wallFill;
        this.wallFill = newWallFill;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldWallFill, (Object)newWallFill);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setWallFill(Fill newWallFill) {
        if (newWallFill != this.wallFill) {
            NotificationChain msgs = null;
            if (this.wallFill != null) {
                msgs = ((InternalEObject)this.wallFill).eInverseRemove((InternalEObject)this, -17, null, msgs);
            }
            if (newWallFill != null) {
                msgs = ((InternalEObject)newWallFill).eInverseAdd((InternalEObject)this, -17, null, msgs);
            }
            if ((msgs = this.basicSetWallFill(newWallFill, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newWallFill, (Object)newWallFill));
        }
    }

    @Override
    public Fill getFloorFill() {
        return this.floorFill;
    }

    public NotificationChain basicSetFloorFill(Fill newFloorFill, NotificationChain msgs) {
        Fill oldFloorFill = this.floorFill;
        this.floorFill = newFloorFill;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldFloorFill, (Object)newFloorFill);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setFloorFill(Fill newFloorFill) {
        if (newFloorFill != this.floorFill) {
            NotificationChain msgs = null;
            if (this.floorFill != null) {
                msgs = ((InternalEObject)this.floorFill).eInverseRemove((InternalEObject)this, -18, null, msgs);
            }
            if (newFloorFill != null) {
                msgs = ((InternalEObject)newFloorFill).eInverseAdd((InternalEObject)this, -18, null, msgs);
            }
            if ((msgs = this.basicSetFloorFill(newFloorFill, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)newFloorFill, (Object)newFloorFill));
        }
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation newOrientation) {
        Orientation oldOrientation = this.orientation;
        this.orientation = newOrientation == null ? ORIENTATION_EDEFAULT : newOrientation;
        boolean oldOrientationESet = this.orientationESet;
        this.orientationESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldOrientation, (Object)this.orientation, !oldOrientationESet));
        }
    }

    @Override
    public void unsetOrientation() {
        Orientation oldOrientation = this.orientation;
        boolean oldOrientationESet = this.orientationESet;
        this.orientation = ORIENTATION_EDEFAULT;
        this.orientationESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 18, (Object)oldOrientation, (Object)ORIENTATION_EDEFAULT, oldOrientationESet));
        }
    }

    @Override
    public boolean isSetOrientation() {
        return this.orientationESet;
    }

    @Override
    public double getUnitSpacing() {
        return this.unitSpacing;
    }

    @Override
    public void setUnitSpacing(double newUnitSpacing) {
        double oldUnitSpacing = this.unitSpacing;
        this.unitSpacing = newUnitSpacing;
        boolean oldUnitSpacingESet = this.unitSpacingESet;
        this.unitSpacingESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldUnitSpacing, this.unitSpacing, !oldUnitSpacingESet));
        }
    }

    @Override
    public void unsetUnitSpacing() {
        double oldUnitSpacing = this.unitSpacing;
        boolean oldUnitSpacingESet = this.unitSpacingESet;
        this.unitSpacing = 50.0;
        this.unitSpacingESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 19, oldUnitSpacing, 50.0, oldUnitSpacingESet));
        }
    }

    @Override
    public boolean isSetUnitSpacing() {
        return this.unitSpacingESet;
    }

    @Override
    public Rotation3D getRotation() {
        return this.rotation;
    }

    public NotificationChain basicSetRotation(Rotation3D newRotation, NotificationChain msgs) {
        Rotation3D oldRotation = this.rotation;
        this.rotation = newRotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldRotation, (Object)newRotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRotation(Rotation3D newRotation) {
        if (newRotation != this.rotation) {
            NotificationChain msgs = null;
            if (this.rotation != null) {
                msgs = ((InternalEObject)this.rotation).eInverseRemove((InternalEObject)this, -21, null, msgs);
            }
            if (newRotation != null) {
                msgs = ((InternalEObject)newRotation).eInverseAdd((InternalEObject)this, -21, null, msgs);
            }
            if ((msgs = this.basicSetRotation(newRotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)newRotation, (Object)newRotation));
        }
    }

    @Override
    public boolean isReverseCategory() {
        return this.reverseCategory;
    }

    @Override
    public void setReverseCategory(boolean newReverseCategory) {
        boolean oldReverseCategory = this.reverseCategory;
        this.reverseCategory = newReverseCategory;
        boolean oldReverseCategoryESet = this.reverseCategoryESet;
        this.reverseCategoryESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldReverseCategory, this.reverseCategory, !oldReverseCategoryESet));
        }
    }

    @Override
    public void unsetReverseCategory() {
        boolean oldReverseCategory = this.reverseCategory;
        boolean oldReverseCategoryESet = this.reverseCategoryESet;
        this.reverseCategory = false;
        this.reverseCategoryESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 21, oldReverseCategory, false, oldReverseCategoryESet));
        }
    }

    @Override
    public boolean isSetReverseCategory() {
        return this.reverseCategoryESet;
    }

    @Override
    public boolean isStudyLayout() {
        return this.studyLayout;
    }

    @Override
    public void setStudyLayout(boolean newStudyLayout) {
        boolean oldStudyLayout = this.studyLayout;
        this.studyLayout = newStudyLayout;
        boolean oldStudyLayoutESet = this.studyLayoutESet;
        this.studyLayoutESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, oldStudyLayout, this.studyLayout, !oldStudyLayoutESet));
        }
    }

    @Override
    public void unsetStudyLayout() {
        boolean oldStudyLayout = this.studyLayout;
        boolean oldStudyLayoutESet = this.studyLayoutESet;
        this.studyLayout = false;
        this.studyLayoutESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 22, oldStudyLayout, false, oldStudyLayoutESet));
        }
    }

    @Override
    public boolean isSetStudyLayout() {
        return this.studyLayoutESet;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return ((InternalEList)this.getAxes()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return this.basicSetWallFill(null, msgs);
            }
            case 17: {
                return this.basicSetFloorFill(null, msgs);
            }
            case 20: {
                return this.basicSetRotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 15: {
                return this.getAxes();
            }
            case 16: {
                return this.getWallFill();
            }
            case 17: {
                return this.getFloorFill();
            }
            case 18: {
                return this.getOrientation();
            }
            case 19: {
                return this.getUnitSpacing();
            }
            case 20: {
                return this.getRotation();
            }
            case 21: {
                return this.isReverseCategory();
            }
            case 22: {
                return this.isStudyLayout();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.getAxes().clear();
                this.getAxes().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setWallFill((Fill)newValue);
                return;
            }
            case 17: {
                this.setFloorFill((Fill)newValue);
                return;
            }
            case 18: {
                this.setOrientation((Orientation)((Object)newValue));
                return;
            }
            case 19: {
                this.setUnitSpacing((Double)newValue);
                return;
            }
            case 20: {
                this.setRotation((Rotation3D)newValue);
                return;
            }
            case 21: {
                this.setReverseCategory((Boolean)newValue);
                return;
            }
            case 22: {
                this.setStudyLayout((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.getAxes().clear();
                return;
            }
            case 16: {
                this.setWallFill(null);
                return;
            }
            case 17: {
                this.setFloorFill(null);
                return;
            }
            case 18: {
                this.unsetOrientation();
                return;
            }
            case 19: {
                this.unsetUnitSpacing();
                return;
            }
            case 20: {
                this.setRotation(null);
                return;
            }
            case 21: {
                this.unsetReverseCategory();
                return;
            }
            case 22: {
                this.unsetStudyLayout();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 15: {
                return this.axes != null && !this.axes.isEmpty();
            }
            case 16: {
                return this.wallFill != null;
            }
            case 17: {
                return this.floorFill != null;
            }
            case 18: {
                return this.isSetOrientation();
            }
            case 19: {
                return this.isSetUnitSpacing();
            }
            case 20: {
                return this.rotation != null;
            }
            case 21: {
                return this.isSetReverseCategory();
            }
            case 22: {
                return this.isSetStudyLayout();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (orientation: ");
        if (this.orientationESet) {
            result.append((Object)this.orientation);
        } else {
            result.append("<unset>");
        }
        result.append(", unitSpacing: ");
        if (this.unitSpacingESet) {
            result.append(this.unitSpacing);
        } else {
            result.append("<unset>");
        }
        result.append(", reverseCategory: ");
        if (this.reverseCategoryESet) {
            result.append(this.reverseCategory);
        } else {
            result.append("<unset>");
        }
        result.append(", studyLayout: ");
        if (this.studyLayoutESet) {
            result.append(this.studyLayout);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public final Axis[] getBaseAxes() {
        EList<Axis> elAxes = this.getAxes();
        int iAxisCount = elAxes.size();
        Axis[] axa = new Axis[iAxisCount];
        int i = 0;
        while (i < iAxisCount) {
            axa[i] = (Axis)elAxes.get(i);
            ++i;
        }
        return axa;
    }

    @Override
    public final Axis[] getPrimaryBaseAxes() {
        EList<Axis> elAxes = this.getAxes();
        int iAxisCount = elAxes.size();
        Axis[] axa = new Axis[iAxisCount];
        int i = 0;
        while (i < iAxisCount) {
            axa[i] = (Axis)elAxes.get(i);
            ++i;
        }
        return axa;
    }

    @Override
    public final Axis[] getOrthogonalAxes(Axis axBase, boolean bIncludePrimary) {
        EList<Axis> elAxes = axBase.getAssociatedAxes();
        int iAxisCount = elAxes.size();
        int iDecrease = bIncludePrimary ? 0 : 1;
        Axis[] axa = new Axis[iAxisCount - iDecrease];
        int i = 0;
        int j = 1 - iDecrease;
        while (i < iAxisCount) {
            Axis ax = (Axis)elAxes.get(i);
            if (!ax.isPrimaryAxis()) {
                axa[j++] = ax;
            } else if (bIncludePrimary) {
                axa[0] = ax;
            }
            ++i;
        }
        return axa;
    }

    @Override
    public final Axis getPrimaryOrthogonalAxis(Axis axBase) {
        EList<Axis> elAxes = axBase.getAssociatedAxes();
        int iAxisCount = elAxes.size();
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = (Axis)elAxes.get(i);
            if (ax.isPrimaryAxis()) {
                return ax;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Axis getAncillaryBaseAxis(Axis axBase) {
        EList<Axis> elAxes = axBase.getAncillaryAxes();
        int iAxisCount = elAxes.size();
        if (iAxisCount > 0) {
            return (Axis)elAxes.get(0);
        }
        return null;
    }

    public static final ChartWithAxes create() {
        ChartWithAxes cwa = ModelFactory.eINSTANCE.createChartWithAxes();
        ((ChartWithAxesImpl)cwa).initialize();
        return cwa;
    }

    @Override
    protected final void initialize() {
        super.initialize();
        Axis xAxisBase = AxisImpl.create(1);
        xAxisBase.setTitlePosition(Position.BELOW_LITERAL);
        xAxisBase.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.X_Axis.title"));
        xAxisBase.getTitle().setVisible(false);
        xAxisBase.setPrimaryAxis(true);
        xAxisBase.setLabelPosition(Position.BELOW_LITERAL);
        xAxisBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        xAxisBase.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxisBase.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        xAxisBase.setType(AxisType.TEXT_LITERAL);
        Axis yAxisOrthogonal = AxisImpl.create(2);
        yAxisOrthogonal.setTitlePosition(Position.LEFT_LITERAL);
        yAxisOrthogonal.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Y_Axis.title"));
        try {
            ChartElementUtil.setDefaultValue(yAxisOrthogonal.getTitle().getCaption().getFont(), "rotation", 90);
        }
        catch (ChartException chartException) {}
        yAxisOrthogonal.getTitle().setVisible(false);
        yAxisOrthogonal.setPrimaryAxis(true);
        yAxisOrthogonal.setLabelPosition(Position.LEFT_LITERAL);
        yAxisOrthogonal.setOrientation(Orientation.VERTICAL_LITERAL);
        yAxisOrthogonal.getOrigin().setType(IntersectionType.MIN_LITERAL);
        yAxisOrthogonal.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        yAxisOrthogonal.setType(AxisType.LINEAR_LITERAL);
        xAxisBase.getAssociatedAxes().add((Object)yAxisOrthogonal);
        this.getAxes().add((Object)xAxisBase);
        this.setRotation(Rotation3DImpl.create());
    }

    public static final ChartWithAxes createDefault() {
        ChartWithAxes cwa = ModelFactory.eINSTANCE.createChartWithAxes();
        ((ChartWithAxesImpl)cwa).initDefault();
        return cwa;
    }

    @Override
    protected final void initDefault() {
        super.initDefault();
        Axis xAxisBase = AxisImpl.createDefault(1);
        try {
            ChartElementUtil.setDefaultValue(xAxisBase, "titlePosition", (Object)Position.BELOW_LITERAL);
            ChartElementUtil.setDefaultValue(xAxisBase.getTitle(), "visible", false);
            ChartElementUtil.setDefaultValue(xAxisBase, "primaryAxis", true);
            ChartElementUtil.setDefaultValue(xAxisBase, "labelPosition", (Object)Position.BELOW_LITERAL);
            ChartElementUtil.setDefaultValue(xAxisBase, "orientation", (Object)Orientation.HORIZONTAL_LITERAL);
            ChartElementUtil.setDefaultValue(xAxisBase.getOrigin(), "type", (Object)IntersectionType.MIN_LITERAL);
            xAxisBase.getOrigin().setValue(null);
            ChartElementUtil.setDefaultValue(xAxisBase, "type", (Object)AxisType.TEXT_LITERAL);
            Axis yAxisOrthogonal = AxisImpl.createDefault(2);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal, "titlePosition", (Object)Position.LEFT_LITERAL);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal.getTitle().getCaption().getFont(), "rotation", 90);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal.getTitle(), "visible", false);
            yAxisOrthogonal.setPrimaryAxis(true);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal, "labelPosition", (Object)Position.LEFT_LITERAL);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal, "orientation", (Object)Orientation.VERTICAL_LITERAL);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal.getOrigin(), "type", (Object)IntersectionType.MIN_LITERAL);
            yAxisOrthogonal.getOrigin().setValue(null);
            ChartElementUtil.setDefaultValue(yAxisOrthogonal, "type", (Object)AxisType.LINEAR_LITERAL);
            xAxisBase.getAssociatedAxes().add((Object)yAxisOrthogonal);
            this.getAxes().add((Object)xAxisBase);
            this.setRotation(Rotation3DImpl.createDefault(new Angle3D[]{Angle3DImpl.createDefault(-20.0, 45.0, 0.0)}));
        }
        catch (ChartException chartException) {}
    }

    @Override
    public final Series[] getSeries(int iBaseOrOrthogonal) {
        ArrayList<Series> al = new ArrayList<Series>(8);
        Axis[] axaBase = this.getBaseAxes();
        int i = 0;
        while (i < axaBase.length) {
            SeriesDefinition sd;
            int j;
            EList<SeriesDefinition> el;
            if ((iBaseOrOrthogonal | 1) == 1) {
                el = axaBase[i].getSeriesDefinitions();
                j = 0;
                while (j < el.size()) {
                    sd = (SeriesDefinition)el.get(j);
                    al.addAll(sd.getRunTimeSeries());
                    ++j;
                }
            }
            Axis[] axaOrthogonal = this.getOrthogonalAxes(axaBase[i], true);
            j = 0;
            while (j < axaOrthogonal.length) {
                if ((iBaseOrOrthogonal | 2) == 2) {
                    el = axaOrthogonal[j].getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        al.addAll(sd.getRunTimeSeries());
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return al.toArray(new Series[al.size()]);
    }

    @Override
    public final boolean isTransposed() {
        return this.getOrientation().getValue() == 0;
    }

    @Override
    public void setTransposed(boolean bTransposed) {
        this.setOrientation(bTransposed ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL);
    }

    @Override
    public final void clearSections(int iSectionType) {
        if ((iSectionType & 3) == 3) {
            Axis[] axaBase = this.getBaseAxes();
            int i = 0;
            while (i < axaBase.length) {
                SeriesDefinition sd;
                EList<SeriesDefinition> el = axaBase[i].getSeriesDefinitions();
                int j = 0;
                while (j < el.size()) {
                    sd = (SeriesDefinition)el.get(j);
                    if (sd.getSeries().size() == sd.getRunTimeSeries().size()) {
                        for (Series se : sd.getRunTimeSeries()) {
                            se.getDataSets().clear();
                        }
                    } else {
                        sd.getSeries().removeAll(sd.getRunTimeSeries());
                    }
                    ++j;
                }
                Axis[] axaOrthogonal = this.getOrthogonalAxes(axaBase[i], true);
                j = 0;
                while (j < axaOrthogonal.length) {
                    el = axaOrthogonal[j].getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        if (sd.getSeries().size() == sd.getRunTimeSeries().size()) {
                            for (Series se : sd.getRunTimeSeries()) {
                                se.getDataSets().clear();
                            }
                        } else {
                            sd.getSeries().removeAll(sd.getRunTimeSeries());
                        }
                        ++k;
                    }
                    ++j;
                }
                Axis axaAncillary = this.getAncillaryBaseAxis(axaBase[i]);
                if (axaAncillary != null) {
                    el = axaAncillary.getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        if (sd.getSeries().size() != sd.getRunTimeSeries().size()) {
                            sd.getSeries().removeAll(sd.getRunTimeSeries());
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public ChartWithAxes copyInstance() {
        ChartWithAxesImpl dest = new ChartWithAxesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(ChartWithAxes src) {
        super.set(src);
        if (src.getAxes() != null) {
            EList<Axis> list = this.getAxes();
            for (Axis element : src.getAxes()) {
                list.add((Object)element.copyInstance());
            }
        }
        if (src.getWallFill() != null) {
            this.setWallFill(src.getWallFill().copyInstance());
        }
        if (src.getFloorFill() != null) {
            this.setFloorFill(src.getFloorFill().copyInstance());
        }
        if (src.getRotation() != null) {
            this.setRotation(src.getRotation().copyInstance());
        }
        this.orientation = src.getOrientation();
        this.orientationESet = src.isSetOrientation();
        this.unitSpacing = src.getUnitSpacing();
        this.unitSpacingESet = src.isSetUnitSpacing();
        this.reverseCategory = src.isReverseCategory();
        this.reverseCategoryESet = src.isSetReverseCategory();
        this.studyLayout = src.isStudyLayout();
        this.studyLayoutESet = src.isSetStudyLayout();
    }

    @Override
    protected SeriesDefinition getBaseSeriesDefinition() {
        return (SeriesDefinition)((Axis)this.getAxes().get(0)).getSeriesDefinitions().get(0);
    }

    @Override
    protected List<SeriesDefinition> getOrthogonalSeriesDefinitions() {
        ArrayList<SeriesDefinition> osds = new ArrayList<SeriesDefinition>();
        for (Axis xAxis : this.getAxes()) {
            for (Axis yAxis : xAxis.getAssociatedAxes()) {
                osds.addAll((Collection<SeriesDefinition>)yAxis.getSeriesDefinitions());
            }
        }
        return osds;
    }

    @Override
    protected SeriesDefinition getAncillaryBaseSeriesDefinition() {
        Axis baseAxis = (Axis)this.getAxes().get(0);
        if (baseAxis.getAncillaryAxes().size() > 0) {
            return (SeriesDefinition)((Axis)baseAxis.getAncillaryAxes().get(0)).getSeriesDefinitions().get(0);
        }
        return null;
    }
}

