/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationDelivery;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class OBEXServerOperationPut
extends OBEXServerOperation
implements OBEXOperationReceive,
OBEXOperationDelivery {
    protected OBEXServerOperationPut(OBEXServerSessionImpl session, OBEXHeaderSetImpl receivedHeaders, boolean finalPacket) throws IOException {
        super(session, receivedHeaders);
        this.inputStream = new OBEXOperationInputStream(this);
        this.processIncommingData(receivedHeaders, finalPacket);
    }

    public InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.inputStreamOpened) {
            throw new IOException("input stream already open");
        }
        DebugLog.debug("openInputStream");
        this.inputStreamOpened = true;
        return this.inputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.outputStream != null) {
            throw new IOException("output stream already open");
        }
        this.outputStream = new OBEXOperationOutputStream(this.session.mtu, this);
        return this.outputStream;
    }

    public void close() throws IOException {
        DebugLog.debug("server close put operation");
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        super.close();
    }

    protected boolean readRequestPacket() throws IOException {
        boolean finalPacket;
        byte[] b = this.session.readPacket();
        int opcode = b[0] & 0xFF;
        boolean bl = finalPacket = (opcode & 0x80) != 0;
        if (finalPacket) {
            DebugLog.debug("server operation got final packet");
            this.finalPacketReceived = true;
        }
        switch (opcode) {
            case 2: 
            case 130: {
                OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
                if (!this.session.handleAuthenticationResponse(requestHeaders)) {
                    this.errorReceived = true;
                    this.session.writePacket(193, null);
                    break;
                }
                OBEXHeaderSetImpl.appendHeaders(this.receivedHeaders, requestHeaders);
                this.processIncommingData(requestHeaders, finalPacket);
                break;
            }
            case 255: {
                this.processAbort();
                break;
            }
            default: {
                this.errorReceived = true;
                DebugLog.debug0x("server operation invalid request", OBEXUtils.toStringObexResponseCodes(opcode), opcode);
                this.session.writePacket(192, null);
            }
        }
        return finalPacket;
    }

    public void receiveData(OBEXOperationInputStream is) throws IOException {
        if (this.finalPacketReceived || this.errorReceived) {
            is.appendData(null, true);
            return;
        }
        DebugLog.debug("server operation reply continue");
        this.session.writePacket(144, this.sendHeaders);
        this.sendHeaders = null;
        this.readRequestPacket();
    }

    public void deliverPacket(boolean finalPacket, byte[] buffer) throws IOException {
        if (this.session.requestSent) {
            this.readRequestPacket();
            if (this.session.requestSent) {
                throw new IOException("Client not requesting data");
            }
        }
        OBEXHeaderSetImpl dataHeaders = OBEXSessionBase.createOBEXHeaderSetImpl();
        int opcode = 144;
        int dataHeaderID = 72;
        if (finalPacket) {
            dataHeaderID = 73;
        }
        dataHeaders.setHeader(dataHeaderID, buffer);
        if (this.sendHeaders != null) {
            OBEXHeaderSetImpl.appendHeaders(dataHeaders, this.sendHeaders);
            this.sendHeaders = null;
        }
        this.session.writePacket(opcode, dataHeaders);
        this.readRequestPacket();
    }

    private void processAbort() throws IOException {
        this.isAborted = true;
        this.session.writePacket(160, null);
        this.close();
        throw new IOException("Operation aborted by client");
    }
}

