/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefCapablePropertyResourceBundle {
    private PropertyResourceBundle wrappedBundle;
    private String baseName;
    private String language;
    private String country;
    private String variant;
    private static Map allBundles = new HashMap();
    public static String LS = System.getProperty("line.separator");
    private Pattern sysPropVarPattern = Pattern.compile("(?s)\\Q${\\E([^}]+?)(?:\\Q:+\\E([^}]+))?\\Q}");
    private Pattern posPattern = Pattern.compile("(?s)\\Q%{\\E(\\d)(?:\\Q:+\\E([^}]+))?\\Q}");
    private ClassLoader loader;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;
    static /* synthetic */ Class class$java$util$PropertyResourceBundle;
    static /* synthetic */ Class class$org$hsqldb$util$RefCapablePropertyResourceBundle;

    public Enumeration getKeys() {
        return this.wrappedBundle.getKeys();
    }

    private RefCapablePropertyResourceBundle(String string, PropertyResourceBundle propertyResourceBundle, ClassLoader classLoader) {
        this.baseName = string;
        this.wrappedBundle = propertyResourceBundle;
        Locale locale = propertyResourceBundle.getLocale();
        this.loader = classLoader;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
        if (this.language.length() < 1) {
            this.language = null;
        }
        if (this.country.length() < 1) {
            this.country = null;
        }
        if (this.variant.length() < 1) {
            this.variant = null;
        }
    }

    public String getExpandedString(String string, int n) {
        String string2 = this.getString(string);
        Matcher matcher = this.sysPropVarPattern.matcher(string2);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string5 = System.getProperty(string3);
            if (string4 != null) {
                String string6 = string5 = string5 == null ? "" : string4.replaceAll("\\Q$" + string3 + "\\E\\b", RefCapablePropertyResourceBundle.literalize(string5));
            }
            if (string5 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("No Sys Property set for variable '" + string3 + "' in property value (" + string2 + ").");
                    }
                    case 1: {
                        string5 = "";
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuffer.append(string2.substring(n2, matcher.start()) + (string5 == null ? matcher.group() : string5));
            n2 = matcher.end();
        }
        return n2 < 1 ? string2 : stringBuffer.toString() + string2.substring(n2);
    }

    public String posSubst(String string, String[] stringArray, int n) {
        Matcher matcher = this.posPattern.matcher(string);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            int n3 = Integer.parseInt(matcher.group(1)) - 1;
            String string3 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string4 = string2 = n3 < stringArray.length ? stringArray[n3] : null;
            if (string3 != null) {
                String string5 = string2 = string2 == null ? "" : string3.replaceAll("\\Q%" + (n3 + 1) + "\\E\\b", RefCapablePropertyResourceBundle.literalize(string2));
            }
            if (string2 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException(Integer.toString(stringArray.length) + " positional values given, but property string " + "contains (" + matcher.group() + ").");
                    }
                    case 1: {
                        string2 = "";
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuffer.append(string.substring(n2, matcher.start()) + (string2 == null ? matcher.group() : string2));
            n2 = matcher.end();
        }
        return n2 < 1 ? string : stringBuffer.toString() + string.substring(n2);
    }

    public String getExpandedString(String string, String[] stringArray, int n, int n2) {
        return this.posSubst(this.getExpandedString(string, n), stringArray, n2);
    }

    public String getString(String string, String[] stringArray, int n) {
        return this.posSubst(this.getString(string), stringArray, n);
    }

    public String toString() {
        return this.baseName + " for " + this.language + " / " + this.country + " / " + this.variant;
    }

    public String getString(String string) {
        String string2 = this.wrappedBundle.getString(string);
        if (string2.length() > 0) {
            return string2;
        }
        string2 = this.getStringFromFile(string);
        if (string2.indexOf(13) > -1) {
            string2 = string2.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\n') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!LS.equals("\n")) {
            string2 = string2.replaceAll("\\n", LS);
        }
        return string2;
    }

    public static RefCapablePropertyResourceBundle getBundle(String string, ClassLoader classLoader) {
        return RefCapablePropertyResourceBundle.getRef(string, ResourceBundle.getBundle(string, Locale.getDefault(), classLoader), classLoader);
    }

    public static RefCapablePropertyResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        return RefCapablePropertyResourceBundle.getRef(string, ResourceBundle.getBundle(string, locale, classLoader), classLoader);
    }

    private static RefCapablePropertyResourceBundle getRef(String string, ResourceBundle resourceBundle, ClassLoader classLoader) {
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            throw new MissingResourceException("Found a Resource Bundle, but it is a " + resourceBundle.getClass().getName(), (class$java$util$PropertyResourceBundle == null ? (class$java$util$PropertyResourceBundle = RefCapablePropertyResourceBundle.class$("java.util.PropertyResourceBundle")) : class$java$util$PropertyResourceBundle).getName(), null);
        }
        if (allBundles.containsKey(resourceBundle)) {
            return (RefCapablePropertyResourceBundle)allBundles.get(resourceBundle);
        }
        RefCapablePropertyResourceBundle refCapablePropertyResourceBundle = new RefCapablePropertyResourceBundle(string, (PropertyResourceBundle)resourceBundle, classLoader);
        allBundles.put(resourceBundle, refCapablePropertyResourceBundle);
        return refCapablePropertyResourceBundle;
    }

    private InputStream getMostSpecificStream(String string, String string2, String string3, String string4) {
        String string5 = this.baseName.replace('.', '/') + '/' + string + (string2 == null ? "" : "_" + string2) + (string3 == null ? "" : "_" + string3) + (string4 == null ? "" : "_" + string4) + ".text";
        InputStream inputStream = this.loader.getResourceAsStream(string5);
        return inputStream == null && string2 != null ? this.getMostSpecificStream(string, string3 == null ? null : string2, string4 == null ? null : string3, null) : inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromFile(String string) {
        int n;
        byte[] byArray = null;
        InputStream inputStream = this.getMostSpecificStream(string, this.language, this.country, this.variant);
        if (inputStream == null) {
            throw new MissingResourceException("Key '" + string + "' is present in .properties file with no value, yet " + "text file resource is missing", (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
        }
        try {
            try {
                byArray = new byte[inputStream.available()];
            }
            catch (RuntimeException runtimeException) {
                throw new MissingResourceException("Resource is too big to read in '" + string + "' value in one " + "gulp.\nPlease run the program with more RAM " + "(try Java -Xm* switches).: " + runtimeException, (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for key '" + string + "': " + iOException, (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
            }
            try {
                int n2;
                for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
                }
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for '" + string + "': " + iOException, (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed to close input stream: " + iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Failed to close input stream: " + iOException);
        }
        if (n != byArray.length) {
            throw new MissingResourceException("Didn't read all bytes.  Read in " + n + " bytes out of " + byArray.length + " bytes for key '" + string + "'", (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
        }
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        catch (RuntimeException runtimeException) {
            throw new MissingResourceException("Value for key '" + string + "' too big to convert to String.  " + "Please run the program with more RAM " + "(try Java -Xm* switches).: " + runtimeException, (class$org$hsqldb$util$RefCapablePropertyResourceBundle == null ? (class$org$hsqldb$util$RefCapablePropertyResourceBundle = RefCapablePropertyResourceBundle.class$("org.hsqldb.util.RefCapablePropertyResourceBundle")) : class$org$hsqldb$util$RefCapablePropertyResourceBundle).getName(), string);
        }
    }

    public static String literalize(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block4;
                }
                case '$': {
                    stringBuffer.append('\\');
                    stringBuffer.append('$');
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

