/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import java.util.ArrayList;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionLogic;
import liquibase.precondition.core.FailedPrecondition;

public class AndPrecondition
extends PreconditionLogic {
    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        boolean allPassed = true;
        ArrayList<FailedPrecondition> failures = new ArrayList<FailedPrecondition>();
        for (Precondition precondition : this.getNestedPreconditions()) {
            try {
                precondition.check(database, changeLog, changeSet);
            }
            catch (PreconditionFailedException e) {
                failures.addAll(e.getFailedPreconditions());
                allPassed = false;
                break;
            }
        }
        if (!allPassed) {
            throw new PreconditionFailedException(failures);
        }
    }

    @Override
    public String getName() {
        return "and";
    }
}

