/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.catches.EnterWeightUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import jaxx.runtime.JAXXUtil;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.swing.svg.SVGUserAgentAdapter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.util.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStylable;

public class EditCatchesSvgHandler {
    private static final Log log = LogFactory.getLog(EditCatchesSvgHandler.class);
    protected Multimap<String, PropertyChangeListener> svgRelatedPropertyChangeListeners = HashMultimap.create();
    protected JSVGCanvas canvas;
    protected Document svgDocument;
    protected final TuttiUIContext context;
    protected final EditCatchesUI ui;
    protected final EditCatchesUIModel model;
    protected final SVGUserAgentAdapter ua = new SVGUserAgentAdapter(){

        public void displayError(String message) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Canvas error: " + message));
            }
        }

        public void displayError(Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Canvas error", (Throwable)ex);
            }
        }
    };

    public EditCatchesSvgHandler(TuttiUIContext context, EditCatchesUI ui, EditCatchesUIModel model) {
        this.context = context;
        this.ui = ui;
        this.model = model;
    }

    public void initResumeSvg() {
        this.ui.getSvgCanvasPanel().removeAll();
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            URL url = Resource.getURL((String)"EcranResume.svg");
            this.svgDocument = f.createDocument(url.toString());
            this.canvas = new JSVGCanvas((SVGUserAgent)this.ua, true, true);
            this.canvas.setBackground(Color.decode("#d6d9df"));
            this.canvas.setSize(new Dimension(1, 1));
            this.canvas.setMySize(new Dimension(1, 1));
            this.canvas.setRecenterOnResize(true);
            final TuttiConfiguration config = this.context.getConfig();
            final Color catchColor = config.getColorCatch();
            final Color speciesColor = config.getColorSpecies();
            final Color benthosColor = config.getColorBenthos();
            final Color speciesOrBenthosUnsortedComputedWeightInWarningColor = config.getColorSpeciesOrBenthosUnsortedComputedWeightInWarning();
            final Color marineLitterColor = config.getColorMarineLitter();
            this.canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingCompleted(GVTTreeRendererEvent gvtTreeRendererEvent) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"gvtRenderingCompleted");
                    }
                    WeightUnit catchWeightUnit = WeightUnit.KG;
                    WeightUnit speciesWeightUnit = config.getSpeciesWeightUnit();
                    WeightUnit benthosWeightUnit = config.getBenthosWeightUnit();
                    WeightUnit marineLitterWeightUnit = config.getMarineLitterWeightUnit();
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalWeight", (Object[])new Object[0]), "catchTotalWeight", "catchTotalComputedWeight", EditCatchesSvgHandler.this.model.getCatchTotalComputedOrNotWeight(), catchWeightUnit, catchColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedComputedWeight", (Object[])new Object[0]), "catchTotalSortedComputedWeight", catchWeightUnit, catchColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalRejectedWeight", (Object[])new Object[0]), "catchTotalRejectedWeight", "catchTotalRejectedComputedWeight", EditCatchesSvgHandler.this.model.getCatchTotalRejectedComputedOrNotWeight(), catchWeightUnit, catchColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedSortedComputedWeight", (Object[])new Object[0]), "catchTotalSortedSortedComputedWeight", catchWeightUnit, catchColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.speciesTotalSortedWeight", (Object[])new Object[0]), "speciesTotalSortedWeight", "speciesTotalSortedComputedWeight", EditCatchesSvgHandler.this.model.getSpeciesTotalSortedComputedOrNotWeight(), speciesWeightUnit, speciesColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.speciesTotalSampleSortedComputedWeight", (Object[])new Object[0]), "speciesTotalSampleSortedComputedWeight", speciesWeightUnit, speciesColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.benthosTotalSortedWeight", (Object[])new Object[0]), "benthosTotalSortedWeight", "benthosTotalSortedComputedWeight", EditCatchesSvgHandler.this.model.getBenthosTotalSortedComputedOrNotWeight(), benthosWeightUnit, benthosColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.benthosTotalSampleSortedComputedWeight", (Object[])new Object[0]), "benthosTotalSampleSortedComputedWeight", benthosWeightUnit, benthosColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalUnsortedComputedWeight", (Object[])new Object[0]), "catchTotalUnsortedComputedWeight", catchWeightUnit, catchColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.speciesTotalUnsortedComputedWeight", (Object[])new Object[0]), "speciesTotalUnsortedComputedWeight", speciesWeightUnit, speciesColor, new String[0]);
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.benthosTotalUnsortedComputedWeight", (Object[])new Object[0]), "benthosTotalUnsortedComputedWeight", benthosWeightUnit, benthosColor, new String[0]);
                    EditCatchesSvgHandler.this.addSvgRelatedPropertyChangeListener(null, new ChangeElementBackgroundColorPropertyChangeListener("speciesTotalUnsortedComputedWeight", Sets.newHashSet((Object[])new String[]{"catchTotalRejectedWeight", "catchTotalRejectedComputedWeight", "speciesTotalSortedWeight", "speciesTotalSortedComputedWeight", "speciesTotalSampleSortedComputedWeight"}), new Function<EditCatchesUIModel, Color>(){

                        public Color apply(EditCatchesUIModel model) {
                            boolean warning = model.isSpeciesTotalUnsortedComputedWeightInWarning();
                            return warning ? speciesOrBenthosUnsortedComputedWeightInWarningColor : speciesColor;
                        }
                    }));
                    EditCatchesSvgHandler.this.addSvgRelatedPropertyChangeListener(null, new ChangeElementBackgroundColorPropertyChangeListener("benthosTotalUnsortedComputedWeight", Sets.newHashSet((Object[])new String[]{"catchTotalRejectedWeight", "catchTotalRejectedComputedWeight", "benthosTotalSortedWeight", "benthosTotalSortedComputedWeight", "benthosTotalSampleSortedComputedWeight"}), new Function<EditCatchesUIModel, Color>(){

                        public Color apply(EditCatchesUIModel model) {
                            boolean warning = model.isBenthosTotalUnsortedComputedWeightInWarning();
                            return warning ? speciesOrBenthosUnsortedComputedWeightInWarningColor : benthosColor;
                        }
                    }));
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.speciesTotalComputedWeight", (Object[])new Object[0]), "speciesTotalComputedWeight", speciesWeightUnit, speciesColor, "benthosTotalComputedWeight", "marineLitterTotalWeight");
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.benthosTotalComputedWeight", (Object[])new Object[0]), "benthosTotalComputedWeight", benthosWeightUnit, benthosColor, "speciesTotalComputedWeight", "marineLitterTotalWeight");
                    EditCatchesSvgHandler.this.initSvgField(I18n.n((String)"tutti.editCatchBatch.field.marineLitterTotalWeight", (Object[])new Object[0]), "marineLitterTotalWeight", "marineLitterTotalComputedWeight", EditCatchesSvgHandler.this.model.getMarineLitterTotalComputedOrNotWeight(), marineLitterWeightUnit, marineLitterColor, "speciesTotalComputedWeight", "benthosTotalComputedWeight");
                    EditCatchesSvgHandler.this.addSvgRelatedPropertyChangeListener(null, new RatioPropertyChangeListener("ratioSpeciesSampleSortedOverSpeciesSortedWeightLabel", "speciesTotalSampleSortedComputedWeight", "speciesTotalSortedWeight", "speciesTotalSortedComputedWeight"));
                    EditCatchesSvgHandler.this.addSvgRelatedPropertyChangeListener(null, new RatioPropertyChangeListener("ratioBenthosSampleSortedOverBenthosSortedWeightLabel", "benthosTotalSampleSortedComputedWeight", "benthosTotalSortedWeight", "benthosTotalSortedComputedWeight"));
                    EditCatchesSvgHandler.this.addSvgRelatedPropertyChangeListener(null, new RatioPropertyChangeListener("ratioSortedSortedOverSortedWeightLabel", "catchTotalSortedSortedComputedWeight", "catchTotalSortedComputedWeight", "catchTotalSortedComputedWeight"));
                    EditCatchesSvgHandler.this.initSpeciesCount(I18n.n((String)"tutti.editCatchBatch.field.speciesDistinctSortedSpeciesCount", (Object[])new Object[0]), "speciesDistinctSortedSpeciesCount");
                    EditCatchesSvgHandler.this.initSpeciesCount(I18n.n((String)"tutti.editCatchBatch.field.benthosDistinctSortedSpeciesCount", (Object[])new Object[0]), "benthosDistinctSortedSpeciesCount");
                    EditCatchesSvgHandler.this.initTremieCarrouselField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedCarousselWeight", (Object[])new Object[0]), "catchTotalSortedCarousselWeight", catchWeightUnit);
                    EditCatchesSvgHandler.this.initTremieCarrouselField(I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedTremisWeight", (Object[])new Object[0]), "catchTotalSortedTremisWeight", catchWeightUnit);
                    EditCatchesSvgHandler.this.ui.getSvgCanvasPanel().add((Component)EditCatchesSvgHandler.this.canvas, "Center");
                }
            });
            this.canvas.setDocumentState(1);
            this.canvas.setDocument(this.svgDocument);
        }
        catch (IOException err) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while initializing the resume background", (Throwable)err);
            }
            this.context.getErrorHelper().showErrorDialog(I18n.t((String)"tutti.editCatchBatch.svgLoading.error", (Object[])new Object[0]), (Throwable)err);
        }
    }

    public void clearSVG() {
        for (String property : this.svgRelatedPropertyChangeListeners.keySet()) {
            for (PropertyChangeListener listener : this.svgRelatedPropertyChangeListeners.get((Object)property)) {
                if (property != null) {
                    this.model.removePropertyChangeListener(property, listener);
                    continue;
                }
                this.model.removePropertyChangeListener(listener);
            }
        }
        this.svgRelatedPropertyChangeListeners.clear();
        if (this.canvas != null) {
            UpdateManager updateManager = this.canvas.getUpdateManager();
            if (updateManager != null) {
                try {
                    updateManager.suspend();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.canvas.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ui.getSvgCanvasPanel().remove((Component)this.canvas);
        }
    }

    protected void initSvgField(String label, String computedProperty, WeightUnit weightUnit, Color bgColor, String ... idsInGroup) {
        this.initSvgField(label, null, computedProperty, null, weightUnit, bgColor, idsInGroup);
    }

    protected void initSvgField(final String label, String property, String computedProperty, final ComputableData<Float> computableData, final WeightUnit weightUnit, final Color bgColor, final String ... idsInGroup) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init " + property + " field"));
        }
        final String notNullProperty = property != null ? property : computedProperty;
        OnDataOrComputedDataValueChangedListener listener = new OnDataOrComputedDataValueChangedListener(notNullProperty, computableData, weightUnit, idsInGroup);
        if (property != null) {
            this.addSvgRelatedPropertyChangeListener(property, listener);
        }
        if (computedProperty != null) {
            this.addSvgRelatedPropertyChangeListener(computedProperty, listener);
        }
        if (computableData != null) {
            Element element = this.svgDocument.getElementById(property);
            EventTarget target = (EventTarget)((Object)element);
            target.addEventListener("click", new OnValueClickListener(computableData, property, weightUnit), false);
        }
        this.updateOnCanvas(new Runnable(){

            @Override
            public void run() {
                Float value;
                boolean computed;
                int colorBrightness;
                SVGOMRectElement rectElement = (SVGOMRectElement)EditCatchesSvgHandler.this.svgDocument.getElementById(notNullProperty + "Rect");
                SVGRect bbox = rectElement.getBBox();
                Float x = Float.valueOf(bbox.getX());
                SVGOMTextElement labelElement = (SVGOMTextElement)EditCatchesSvgHandler.this.svgDocument.getElementById(notNullProperty + "Label");
                CSSStyleDeclaration style = labelElement.getStyle();
                if (computableData == null) {
                    style.setProperty("font-style", "italic", null);
                }
                String textColor = (colorBrightness = TuttiUIUtil.getColorBrightness(bgColor)) > 150 ? "#000000" : "#FFFFFF";
                style.setProperty("fill", textColor, null);
                labelElement.setTextContent(weightUnit.decorateLabel(I18n.t((String)label, (Object[])new Object[0])));
                bbox = labelElement.getBBox();
                float labelX = bbox.getX();
                float width = Math.abs(x.floatValue() - labelX) + 10.0f;
                SVGOMRectElement labelRectElement = (SVGOMRectElement)EditCatchesSvgHandler.this.svgDocument.getElementById(notNullProperty + "LabelRect");
                float actualWidth = Math.abs(labelRectElement.getBBox().getX() - labelX) + 10.0f;
                if (actualWidth < width) {
                    labelRectElement.setAttribute("width", Float.toString(width));
                    labelRectElement.setAttribute("x", String.valueOf(labelX - 10.0f));
                    for (String id : idsInGroup) {
                        Element el = EditCatchesSvgHandler.this.svgDocument.getElementById(id + "LabelRect");
                        el.setAttribute("width", Float.toString(width));
                        el.setAttribute("x", String.valueOf(labelX - 10.0f));
                    }
                }
                style = labelRectElement.getStyle();
                String hexaColor = "#" + Integer.toHexString(bgColor.getRGB()).substring(2);
                style.setProperty("fill", hexaColor, null);
                if (computableData == null) {
                    computed = true;
                    value = EditCatchesSvgHandler.this.getModelPropertyValue(notNullProperty);
                } else if (computableData.getData() == null) {
                    computed = true;
                    value = (Float)computableData.getComputedData();
                } else {
                    computed = false;
                    value = (Float)computableData.getData();
                }
                EditCatchesSvgHandler.this.updateValue(notNullProperty, value, weightUnit, computed, idsInGroup);
            }
        });
    }

    protected void updateOnCanvas(Runnable runnable) {
        try {
            this.canvas.getUpdateManager().getUpdateRunnableQueue().invokeLater(runnable);
        }
        catch (IllegalStateException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while updating canvas, reload it");
            }
            this.clearSVG();
            this.initResumeSvg();
        }
    }

    protected void addSvgRelatedPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.svgRelatedPropertyChangeListeners.put((Object)property, (Object)listener);
        if (property != null) {
            this.model.addPropertyChangeListener(property, listener);
        } else {
            this.model.addPropertyChangeListener(listener);
        }
    }

    protected void updateValue(final String property, final Float value, final WeightUnit weightUnit, final boolean computed, final String ... idsInGroup) {
        this.updateOnCanvas(new Runnable(){

            @Override
            public void run() {
                SVGOMTextElement valueElement;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update " + property + " field"));
                }
                if ((valueElement = (SVGOMTextElement)EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Value")) == null) {
                    return;
                }
                String textContent = value != null ? Weights.getWeightStringValue(value) + " " + weightUnit.getShortLabel() : null;
                valueElement.setTextContent(textContent);
                CSSStyleDeclaration style = valueElement.getStyle();
                Color colorComputedWeights = EditCatchesSvgHandler.this.context.getConfig().getColorComputedWeights();
                String computedColor = "#" + Integer.toHexString(colorComputedWeights.getRGB()).substring(2);
                style.setProperty("fill", computed ? computedColor : "#000000", null);
                style.setProperty("font-style", computed ? "italic" : "normal", null);
                SVGRect bbox = valueElement.getBBox();
                SVGOMRectElement rectElement = (SVGOMRectElement)EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Rect");
                if (bbox != null && rectElement != null) {
                    float width = bbox.getWidth() + 15.0f;
                    float actualWidth = rectElement.getBBox().getWidth();
                    if (actualWidth < width) {
                        rectElement.setAttribute("width", Float.toString(width));
                        for (String id : idsInGroup) {
                            Element el = EditCatchesSvgHandler.this.svgDocument.getElementById(id + "Rect");
                            el.setAttribute("width", Float.toString(width));
                        }
                    }
                }
            }
        });
    }

    protected Float getModelPropertyValue(String property) {
        Float value;
        try {
            String sValue = BeanUtils.getProperty((Object)this.model, (String)property);
            value = sValue != null ? Float.valueOf(Float.parseFloat(sValue)) : null;
        }
        catch (ReflectiveOperationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("error on reading model's property " + property), (Throwable)e);
            }
            value = null;
        }
        return value;
    }

    protected void initSpeciesCount(final String label, final String property) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init " + property + " field"));
        }
        this.updateOnCanvas(new Runnable(){

            @Override
            public void run() {
                Integer value;
                Element labelElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Label");
                labelElement.setTextContent(I18n.t((String)label, (Object[])new Object[0]));
                Element valueElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Value");
                try {
                    String sValue = BeanUtils.getProperty((Object)EditCatchesSvgHandler.this.model, (String)property);
                    value = sValue != null ? Integer.valueOf(Integer.parseInt(sValue)) : null;
                }
                catch (ReflectiveOperationException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("error on reading model's property " + property), (Throwable)e);
                    }
                    value = null;
                }
                valueElement.setTextContent(JAXXUtil.getStringValue(value));
            }
        });
        this.addSvgRelatedPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final Integer value = (Integer)evt.getNewValue();
                EditCatchesSvgHandler.this.updateOnCanvas(new Runnable(){

                    @Override
                    public void run() {
                        Element labelElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Value");
                        labelElement.setTextContent(JAXXUtil.getStringValue((Object)value));
                    }
                });
            }
        });
    }

    protected void initTremieCarrouselField(final String label, final String property, final WeightUnit weightUnit) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init " + property + " field"));
        }
        this.updateOnCanvas(new Runnable(){

            @Override
            public void run() {
                Element labelElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Label");
                labelElement.setTextContent(weightUnit.decorateLabel(I18n.t((String)label, (Object[])new Object[0])));
            }
        });
        this.addSvgRelatedPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float value = (Float)evt.getNewValue();
                EditCatchesSvgHandler.this.updateValue(property, value, weightUnit, true, new String[0]);
            }
        });
        Float value = this.getModelPropertyValue(property);
        this.updateValue(property, value, weightUnit, true, new String[0]);
        this.addSvgRelatedPropertyChangeListener("fishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditCatchesSvgHandler.this.updateTremieCarrouselVisibility(property);
            }
        });
        this.updateTremieCarrouselVisibility(property);
    }

    protected void updateTremieCarrouselVisibility(final String property) {
        FishingOperation fishingOperation = this.model.getFishingOperation();
        if (fishingOperation != null) {
            final boolean tremieCarrouselFieldsVisisble = fishingOperation.getVessel() != null && fishingOperation.getVessel().getId().equals(this.context.getConfig().getTremieCarousselVesselId());
            this.updateOnCanvas(new Runnable(){

                @Override
                public void run() {
                    Element labelElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Label");
                    labelElement.setAttribute("visibility", tremieCarrouselFieldsVisisble ? "visible" : "hidden");
                    Element valueElement = EditCatchesSvgHandler.this.svgDocument.getElementById(property + "Value");
                    valueElement.setAttribute("visibility", tremieCarrouselFieldsVisisble ? "visible" : "hidden");
                }
            });
        }
    }

    private class RatioPropertyChangeListener
    implements PropertyChangeListener {
        private final String elementId;
        private final String numeratorProperty;
        private final String denominatorProperty;
        private final String denominatorComputedProperty;
        private Integer ratio = null;
        private final Set<String> propertyNames;

        public RatioPropertyChangeListener(String elementId, String numeratorProperty, String denominatorProperty, String denominatorComputedProperty) {
            this.elementId = elementId;
            this.numeratorProperty = numeratorProperty;
            this.denominatorProperty = denominatorProperty;
            this.denominatorComputedProperty = denominatorComputedProperty;
            this.propertyNames = ImmutableSet.of((Object)numeratorProperty, (Object)denominatorProperty, (Object)denominatorComputedProperty);
            this.updateRatioText();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (this.propertyNames.contains(propertyName)) {
                this.updateRatioText();
            }
        }

        protected void updateRatioText() {
            Float numerator = (Float)JavaBeanObjectUtil.getProperty((Object)EditCatchesSvgHandler.this.model, (String)this.numeratorProperty);
            Float denominator = (Float)JavaBeanObjectUtil.getProperty((Object)EditCatchesSvgHandler.this.model, (String)this.denominatorProperty);
            if (denominator == null) {
                denominator = (Float)JavaBeanObjectUtil.getProperty((Object)EditCatchesSvgHandler.this.model, (String)this.denominatorComputedProperty);
            }
            this.ratio = numerator == null || denominator == null || Weights.isEqualWeight(denominator.floatValue(), 0.0f) ? null : Integer.valueOf(Numbers.roundToInt(100.0f * numerator.floatValue() / denominator.floatValue()));
            EditCatchesSvgHandler.this.updateOnCanvas(new Runnable(){

                @Override
                public void run() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("update " + RatioPropertyChangeListener.this.elementId + " field"));
                    }
                    Element ratioElement = EditCatchesSvgHandler.this.svgDocument.getElementById(RatioPropertyChangeListener.this.elementId);
                    String textContent = RatioPropertyChangeListener.this.ratio != null ? RatioPropertyChangeListener.this.ratio + "%" : null;
                    ratioElement.setTextContent(textContent);
                }
            });
        }
    }

    private class ChangeElementBackgroundColorPropertyChangeListener
    implements PropertyChangeListener {
        private final String elementId;
        private Set<String> propertiesToListen;
        private Function<EditCatchesUIModel, Color> colorFunction;

        public ChangeElementBackgroundColorPropertyChangeListener(String elementId, Set<String> propertiesToListen, Function<EditCatchesUIModel, Color> colorFunction) {
            this.elementId = elementId;
            this.propertiesToListen = propertiesToListen;
            this.colorFunction = colorFunction;
            this.updateColor();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.propertiesToListen.contains(evt.getPropertyName())) {
                this.updateColor();
            }
        }

        protected void updateColor() {
            EditCatchesSvgHandler.this.updateOnCanvas(new Runnable(){

                @Override
                public void run() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("update " + ChangeElementBackgroundColorPropertyChangeListener.this.elementId + " field"));
                    }
                    Element rectElement = EditCatchesSvgHandler.this.svgDocument.getElementById(ChangeElementBackgroundColorPropertyChangeListener.this.elementId + "LabelRect");
                    SVGStylable field = (SVGStylable)rectElement;
                    CSSStyleDeclaration style = field.getStyle();
                    Color background = (Color)ChangeElementBackgroundColorPropertyChangeListener.this.colorFunction.apply((Object)EditCatchesSvgHandler.this.model);
                    String color = "#" + Integer.toHexString(background.getRGB()).substring(2);
                    style.setProperty("fill", color, null);
                    SVGOMTextElement labelElement = (SVGOMTextElement)EditCatchesSvgHandler.this.svgDocument.getElementById(ChangeElementBackgroundColorPropertyChangeListener.this.elementId + "Label");
                    CSSStyleDeclaration labelStyle = labelElement.getStyle();
                    int colorBrightness = TuttiUIUtil.getColorBrightness(background);
                    String textColor = colorBrightness > 150 ? "#000000" : "#FFFFFF";
                    labelStyle.setProperty("fill", textColor, null);
                }
            });
        }
    }

    private class OnDataOrComputedDataValueChangedListener
    implements PropertyChangeListener {
        private final String property;
        private final ComputableData<Float> computableData;
        private final WeightUnit weightUnit;
        private final String[] idsInGroup;

        public OnDataOrComputedDataValueChangedListener(String property, ComputableData<Float> computableData, WeightUnit weightUnit, String ... idsInGroup) {
            this.property = property;
            this.computableData = computableData;
            this.weightUnit = weightUnit;
            this.idsInGroup = idsInGroup;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Float newValue;
            boolean computedData;
            if (this.computableData == null) {
                computedData = true;
                newValue = (Float)evt.getNewValue();
            } else if (this.computableData.getData() == null) {
                computedData = true;
                newValue = this.computableData.getComputedData();
            } else {
                computedData = false;
                newValue = this.computableData.getData();
            }
            EditCatchesSvgHandler.this.updateValue(this.property, newValue, this.weightUnit, computedData, this.idsInGroup);
        }
    }

    private class OnValueClickListener
    implements EventListener {
        private final ComputableData<Float> computableData;
        private final String property;
        private final WeightUnit weightUnit;

        public OnValueClickListener(ComputableData<Float> computableData, String property, WeightUnit weightUnit) {
            this.computableData = computableData;
            this.property = property;
            this.weightUnit = weightUnit;
        }

        @Override
        public void handleEvent(Event evt) {
            log.info((Object)"element clicked");
            EnterWeightUI dialog = new EnterWeightUI(EditCatchesSvgHandler.this.context);
            Float originalWeight = this.computableData.getData();
            Float weight = dialog.openAndGetWeightValue(I18n.t((String)("tutti.editCatchBatch.field." + this.property), (Object[])new Object[0]), originalWeight, this.weightUnit);
            if (!Objects.equals(originalWeight, weight)) {
                this.computableData.setData(weight);
            }
        }
    }
}

