/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.csv;

public class CSVUtil {
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String QUOTE = "\"";

    public static String quoteCSVValue(String value, String sep) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return "\"\"";
        }
        value = value.replaceAll(QUOTE, "\"\"");
        boolean needQuote = false;
        boolean bl = needQuote = value.indexOf(sep) != -1 || value.indexOf(QUOTE) != -1 || value.indexOf(10) != -1 || value.startsWith(" ") || value.endsWith(" ") || value.startsWith("\t") || value.endsWith("\t");
        if (needQuote) {
            value = QUOTE + value + QUOTE;
        }
        return value;
    }

    public static String makeCSVRow(String[] values, String sep, boolean addCR) {
        StringBuffer buf = new StringBuffer(values.length * 10);
        int i = 0;
        while (i < values.length) {
            String value;
            if (i > 0) {
                buf.append(sep);
            }
            if ((value = CSVUtil.quoteCSVValue(values[i], sep)) != null) {
                buf.append(value);
            }
            ++i;
        }
        if (addCR) {
            buf.append(CR);
        }
        buf.append(LF);
        return buf.toString();
    }
}

