/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

class ResultClassHelper {
    private IResultClass resultClass;
    private boolean hasClobOrBlob = false;
    private int[] clobIndex = null;
    private int[] blobIndex = null;

    ResultClassHelper(IResultClass resultClass) throws DataException {
        this.resultClass = resultClass;
        this.initIndex();
    }

    private void initIndex() throws DataException {
        ArrayList<Integer> clobIndexList = new ArrayList<Integer>();
        ArrayList<Integer> blobIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.resultClass.getFieldCount()) {
            Class valueClass = this.resultClass.getFieldValueClass(i + 1);
            assert (valueClass != null);
            if (valueClass.isAssignableFrom(IClob.class)) {
                clobIndexList.add(i);
            } else if (valueClass.isAssignableFrom(IBlob.class)) {
                blobIndexList.add(i);
            }
            ++i;
        }
        this.clobIndex = this.toIntArray(clobIndexList);
        this.blobIndex = this.toIntArray(blobIndexList);
        this.hasClobOrBlob = this.clobIndex.length > 0 || this.blobIndex.length > 0;
    }

    private int[] toIntArray(List integerList) {
        int[] reArray = new int[integerList.size()];
        int i = 0;
        while (i < reArray.length) {
            reArray[i] = (Integer)integerList.get(i);
            ++i;
        }
        return reArray;
    }

    boolean hasClobOrBlob() {
        return this.hasClobOrBlob;
    }

    int[] getClobIndexArray() {
        return this.clobIndex;
    }

    int[] getBlobIndexArray() {
        return this.blobIndex;
    }
}

