/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.binding;

import jaxx.runtime.JAXXObject;
import jaxx.runtime.binding.DefaultJAXXBinding;

public abstract class SimpleJAXXObjectBinding
extends DefaultJAXXBinding {
    protected final String[] propertyNames;

    public SimpleJAXXObjectBinding(JAXXObject source, String id, boolean defaultBinding, String ... propertyNames) {
        super(source, id, defaultBinding);
        if (propertyNames == null || propertyNames.length == 0) {
            throw new IllegalArgumentException("must at least have one propertyName ");
        }
        this.propertyNames = propertyNames;
    }

    public boolean canApply() {
        return true;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public void applyDataBinding() {
        if (this.canApply()) {
            for (String s : this.propertyNames) {
                this.source.addPropertyChangeListener(s, this);
            }
        }
    }

    @Override
    public void removeDataBinding() {
        if (this.canApply()) {
            for (String s : this.propertyNames) {
                this.source.removePropertyChangeListener(s, this);
            }
        }
    }
}

