/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IAutoTextModel;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class AutoText
extends ReportItem
implements IAutoTextModel {
    public AutoText() {
    }

    public AutoText(String theName) {
        super(theName);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitAutoText(this);
    }

    @Override
    public String getElementName() {
        return "AutoText";
    }

    public AutoTextHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new AutoTextHandle(module, this);
        }
        return (AutoTextHandle)this.handle;
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    private String getChoiceDisplayName(String value) {
        MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
        IChoiceSet cSet = dictionary.getChoiceSet("autoTextType");
        IChoice choice = cSet.findChoice(value);
        if (choice != null) {
            String thevalue = choice.getDisplayName();
            return this.limitStringLength(thevalue);
        }
        return null;
    }

    @Override
    protected String getDefnDisplayName(Module module) {
        String retValue = null;
        String value = this.getStringProperty(module, "type");
        if (!StringUtil.isBlank(value)) {
            retValue = this.getChoiceDisplayName(value);
        }
        if (!StringUtil.isBlank(retValue)) {
            return retValue;
        }
        return super.getDefnDisplayName(module);
    }

    @Override
    protected String getNameForDisplayLabel() {
        return null;
    }

    @Override
    public String getDisplayLabel(Module module, int level) {
        if (level == 2 && "page-variable".equals(this.getProperty(module, "type"))) {
            VariableElement variable;
            String variableName = (String)this.getProperty(module, "pageVariable");
            if (module instanceof ReportDesign && (variable = ((ReportDesign)module).findVariableElement(variableName)) != null && variable.getProperty(module, "type") != null) {
                String displayLable = variable.getDisplayProperty(module, "type");
                displayLable = String.valueOf(displayLable) + "(" + this.limitStringLength(variableName) + ")";
                return displayLable;
            }
        }
        return super.getDisplayLabel(module, level);
    }
}

