/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.api.TOCStyle;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;

public class TOCStyleUtil {
    private HashMap<String, TOCStyle> styleCaches = new HashMap();
    private ReportDesignHandle reportHandle;

    public TOCStyleUtil(ReportDesignHandle report) {
        this.reportHandle = report;
    }

    public TOCStyle getTOCStyle(int tocLevel, long elementId) throws ScriptException {
        String cacheKey = String.valueOf(tocLevel) + "." + elementId;
        TOCStyle tocStyle = this.styleCaches.get(cacheKey);
        if (tocStyle == null) {
            tocStyle = this.createTOCStyle(tocLevel, elementId);
            this.styleCaches.put(cacheKey, tocStyle);
        }
        return tocStyle;
    }

    private TOCStyle createTOCStyle(int tocLevel, long elementId) throws ScriptException {
        String styleName;
        ReportElementHandle handle = (ReportElementHandle)this.reportHandle.getElementByID(elementId);
        String tocStyleName = "TOC-level-" + tocLevel;
        SharedStyleHandle tocStyleHandle = this.reportHandle.findStyle(tocStyleName);
        SharedStyleHandle sharedStyleHandle = null;
        TOCHandle tocHandle = null;
        if (handle instanceof ReportItemHandle) {
            tocHandle = ((ReportItemHandle)handle).getTOC();
        } else if (handle instanceof GroupHandle) {
            tocHandle = ((GroupHandle)handle).getTOC();
        }
        if (tocHandle != null && (styleName = tocHandle.getStyleName()) != null) {
            sharedStyleHandle = this.reportHandle.findStyle(styleName);
        }
        TOCStyle tocStyle = this.createTOCStyle(tocStyleHandle);
        TOCStyle sharedStyle = this.createTOCStyle(sharedStyleHandle);
        TOCStyle privateStyle = this.createTOCStyle(tocHandle);
        return this.mergeStyles(tocStyle, sharedStyle, privateStyle);
    }

    private String getColor(ColorHandle color) {
        if (color != null) {
            return color.getCssValue();
        }
        return null;
    }

    private String getDimension(DimensionHandle dimension) {
        if (dimension != null) {
            return dimension.getStringValue();
        }
        return null;
    }

    private String getDimensionIfSet(DimensionHandle dimension) {
        if (dimension != null && dimension.isSet()) {
            return dimension.getStringValue();
        }
        return null;
    }

    private String getFontFamily(FontHandle font) {
        if (font != null) {
            return font.getStringValue();
        }
        return null;
    }

    private TOCStyle createTOCStyle(StyleHandle handle) throws ScriptException {
        if (handle == null) {
            return null;
        }
        TOCStyle style = new TOCStyle();
        style.setBackgroundColor(this.getColor(handle.getBackgroundColor()));
        style.setBackgroundImage(handle.getBackgroundImage());
        style.setBackgroundPositionX(this.getDimension(handle.getBackGroundPositionX()));
        style.setBackgroundPositionY(this.getDimension(handle.getBackGroundPositionY()));
        style.setBackgroundRepeat(handle.getBackgroundRepeat());
        style.setTextAlign(handle.getTextAlign());
        style.setTextIndent(this.getDimension(handle.getTextIndent()));
        style.setLetterSpacing(this.getDimension(handle.getLetterSpacing()));
        style.setLineHeight(this.getDimension(handle.getLineHeight()));
        style.setTextTransform(handle.getTextTransform());
        style.setVerticalAlign(handle.getVerticalAlign());
        style.setWhiteSpace(handle.getWhiteSpace());
        style.setWordSpacing(this.getDimension(handle.getWordSpacing()));
        style.setDisplay(handle.getDisplay());
        style.setMasterPage(handle.getMasterPage());
        style.setPageBreakAfter(handle.getPageBreakAfter());
        style.setPageBreakBefore(handle.getPageBreakBefore());
        style.setPageBreakInside(handle.getPageBreakInside());
        style.setFontFamily(this.getFontFamily(handle.getFontFamilyHandle()));
        style.setColor(this.getColor(handle.getColor()));
        style.setFontSize(this.getDimensionIfSet(handle.getFontSize()));
        style.setFontStyle(handle.getFontStyle());
        style.setFontWeight(handle.getFontWeight());
        style.setFontVariant(handle.getFontVariant());
        style.setTextLineThrough(handle.getTextLineThrough());
        style.setTextOverline(handle.getTextOverline());
        style.setTextUnderline(handle.getTextUnderline());
        style.setBorderBottomColor(this.getColor(handle.getBorderBottomColor()));
        style.setBorderBottomStyle(handle.getBorderBottomStyle());
        style.setBorderBottomWidth(this.getDimension(handle.getBorderBottomWidth()));
        style.setBorderLeftColor(this.getColor(handle.getBorderLeftColor()));
        style.setBorderLeftStyle(handle.getBorderLeftStyle());
        style.setBorderLeftWidth(this.getDimension(handle.getBorderLeftWidth()));
        style.setBorderRightColor(this.getColor(handle.getBorderRightColor()));
        style.setBorderRightStyle(handle.getBorderRightStyle());
        style.setBorderRightWidth(this.getDimension(handle.getBorderRightWidth()));
        style.setBorderTopColor(this.getColor(handle.getBorderTopColor()));
        style.setBorderTopStyle(handle.getBorderTopStyle());
        style.setBorderTopWidth(this.getDimension(handle.getBorderTopWidth()));
        style.setMarginBottom(this.getDimension(handle.getMarginBottom()));
        style.setMarginLeft(this.getDimension(handle.getMarginLeft()));
        style.setMarginRight(this.getDimension(handle.getMarginRight()));
        style.setMarginTop(this.getDimension(handle.getMarginTop()));
        style.setPaddingBottom(this.getDimension(handle.getPaddingBottom()));
        style.setPaddingLeft(this.getDimension(handle.getPaddingLeft()));
        style.setPaddingRight(this.getDimension(handle.getPaddingRight()));
        style.setPaddingTop(this.getDimension(handle.getPaddingTop()));
        style.setStringFormat(handle.getStringFormat());
        style.setNumberFormat(handle.getNumberFormat());
        style.setDateFormat(handle.getDateTimeFormat());
        style.setDirection(handle.getTextDirection());
        return style;
    }

    private TOCStyle createTOCStyle(TOCHandle handle) throws ScriptException {
        if (handle == null) {
            return null;
        }
        TOCStyle style = new TOCStyle();
        style.setBackgroundColor(this.getColor(handle.getBackgroundColor()));
        style.setTextAlign(handle.getTextAlign());
        style.setTextIndent(this.getDimension(handle.getTextIndent()));
        style.setTextTransform(handle.getTextTransform());
        style.setFontFamily(this.getFontFamily(handle.getFontFamily()));
        style.setColor(this.getColor(handle.getColor()));
        style.setFontSize(this.getDimensionIfSet(handle.getFontSize()));
        style.setFontStyle(handle.getFontStyle());
        style.setFontWeight(handle.getFontWeight());
        style.setFontVariant(handle.getFontVariant());
        style.setTextLineThrough(handle.getTextLineThrough());
        style.setTextOverline(handle.getTextOverline());
        style.setTextUnderline(handle.getTextUnderline());
        style.setBorderBottomColor(this.getColor(handle.getBorderBottomColor()));
        style.setBorderBottomStyle(handle.getBorderBottomStyle());
        style.setBorderBottomWidth(this.getDimension(handle.getBorderBottomWidth()));
        style.setBorderLeftColor(this.getColor(handle.getBorderLeftColor()));
        style.setBorderLeftStyle(handle.getBorderLeftStyle());
        style.setBorderLeftWidth(this.getDimension(handle.getBorderLeftWidth()));
        style.setBorderRightColor(this.getColor(handle.getBorderRightColor()));
        style.setBorderRightStyle(handle.getBorderRightStyle());
        style.setBorderRightWidth(this.getDimension(handle.getBorderRightWidth()));
        style.setBorderTopColor(this.getColor(handle.getBorderTopColor()));
        style.setBorderTopStyle(handle.getBorderTopStyle());
        style.setBorderTopWidth(this.getDimension(handle.getBorderTopWidth()));
        style.setStringFormat(handle.getStringFormat());
        style.setNumberFormat(handle.getNumberFormat());
        style.setDateFormat(handle.getDateTimeFormat());
        style.setDirection(handle.getTextDirection());
        return style;
    }

    private TOCStyle mergeStyles(TOCStyle s1, TOCStyle s2, TOCStyle s3) {
        TOCStyle style = new TOCStyle();
        Map properties = style.getProperties();
        if (s1 != null) {
            properties.putAll(s1.getProperties());
        }
        if (s2 != null) {
            properties.putAll(s2.getProperties());
        }
        if (s3 != null) {
            properties.putAll(s3.getProperties());
        }
        return style;
    }
}

