/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class UniqueConstraint
extends AbstractDatabaseObject {
    public UniqueConstraint() {
        this.setAttribute("columns", new ArrayList());
        this.setAttribute("deferrable", false);
        this.setAttribute("initiallyDeferred", false);
        this.setAttribute("disabled", false);
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String column : this.getColumns()) {
            columns.add(new Column().setName(column).setRelation(this.getTable()));
        }
        return columns.toArray(new DatabaseObject[columns.size()]);
    }

    @Override
    public String getName() {
        return this.getAttribute("name", String.class);
    }

    public UniqueConstraint setName(String constraintName) {
        this.setAttribute("name", constraintName);
        return this;
    }

    @Override
    public Schema getSchema() {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().getSchema();
    }

    public Table getTable() {
        return this.getAttribute("table", Table.class);
    }

    public UniqueConstraint setTable(Table table) {
        this.setAttribute("table", table);
        return this;
    }

    public List<String> getColumns() {
        return this.getAttribute("columns", List.class);
    }

    public UniqueConstraint setColumns(String columnNames) {
        this.getColumns().addAll(StringUtils.splitAndTrim(columnNames, ","));
        return this;
    }

    public UniqueConstraint addColumn(int position, String columnName) {
        if (position >= this.getColumns().size()) {
            int i = this.getColumns().size() - 1;
            while (i < position) {
                this.getColumns().add(null);
                ++i;
            }
        }
        this.getColumns().set(position, columnName);
        return this;
    }

    public boolean isDeferrable() {
        return this.getAttribute("deferrable", Boolean.class);
    }

    public UniqueConstraint setDeferrable(boolean deferrable) {
        this.setAttribute("deferrable", deferrable);
        return this;
    }

    public boolean isInitiallyDeferred() {
        return this.getAttribute("initiallyDeferred", Boolean.class);
    }

    public UniqueConstraint setInitiallyDeferred(boolean initiallyDeferred) {
        this.setAttribute("initiallyDeferred", initiallyDeferred);
        return this;
    }

    public String getColumnNames() {
        return StringUtils.join(this.getColumns(), ", ");
    }

    public UniqueConstraint setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        return this.getAttribute("disabled", Boolean.class);
    }

    public Index getBackingIndex() {
        return this.getAttribute("backingIndex", Index.class);
    }

    public UniqueConstraint setBackingIndex(Index backingIndex) {
        this.setAttribute("backingIndex", backingIndex);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.getColumnNames() == null) {
            return false;
        }
        UniqueConstraint that = (UniqueConstraint)o;
        boolean result = false;
        boolean bl = (this.getColumnNames() != null ? this.getColumnNames().equalsIgnoreCase(that.getColumnNames()) : that.getColumnNames() == null) && this.isDeferrable() == that.isDeferrable() && this.isInitiallyDeferred() == that.isInitiallyDeferred() && this.isDisabled() == that.isDisabled() ? true : (result = false);
        if (result) {
            result = this.getTable() == null ? that.getTable() == null : (that.getTable() == null ? false : this.getTable().getName().equals(that.getTable().getName()));
        }
        return result;
    }

    @Override
    public int compareTo(Object other) {
        String thatTableName;
        UniqueConstraint o = (UniqueConstraint)other;
        String thisTableName = this.getTable() == null ? "" : this.getTable().getName();
        int returnValue = thisTableName.compareTo(thatTableName = o.getTable() == null ? "" : o.getTable().getName());
        if (returnValue == 0) {
            returnValue = this.getName().compareTo(o.getName());
        }
        if (returnValue == 0) {
            returnValue = this.getColumnNames().compareTo(o.getColumnNames());
        }
        return returnValue;
    }

    public int hashCode() {
        int result = 0;
        if (this.getTable() != null) {
            result = this.getTable().hashCode();
        }
        if (this.getName() != null) {
            result = 31 * result + this.getName().toUpperCase().hashCode();
        }
        if (this.getColumnNames() != null) {
            result = 31 * result + this.getColumnNames().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " on " + this.getTable().getName() + "(" + this.getColumnNames() + ")";
    }
}

