/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAndCleanDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportAndCleanDbAction.class);
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd");
    protected File file;

    public ExportAndCleanDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        this.file = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile("tutti-db-" + df.format(new Date()), "zip", I18n.t((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), new String[]{"^.*\\.zip", I18n.t((String)"tutti.common.file.zip", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export db to " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3);
        progressionModel.setMessage(I18n.t((String)"tutti.exportDb.step.closeDb", (Object[])new Object[0]));
        this.getContext().getPersistenceService().clearAllCaches();
        this.getContext().setDbLoaded(false);
        this.getContext().reloadPersistenceService();
        this.getContext().clearDbContext();
        progressionModel.increments(1);
        progressionModel.setMessage(I18n.t((String)"tutti.exportDb.step.createArchive", (Object[])new Object[]{this.file}));
        this.getContext().getPersistenceService().exportDb(this.file);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n.t((String)"tutti.exportDb.step.reloadApplication", (Object[])new Object[0]));
        RunTutti.closeTutti((MainUIHandler)this.getHandler(), 89);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.flash.info.db.exported.and.clean", (Object[])new Object[]{this.file}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

