/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.validators.MasterPageMultiColumnValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageTypeValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.interfaces.IGraphicMaterPageModel;

public class GraphicMasterPage
extends MasterPage
implements IGraphicMaterPageModel {
    public GraphicMasterPage() {
        this.initSlots();
    }

    public GraphicMasterPage(String theName) {
        super(theName);
        this.initSlots();
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot == 0);
        return this.slots[0];
    }

    public GraphicMasterPageHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new GraphicMasterPageHandle(module, this);
        }
        return (GraphicMasterPageHandle)this.handle;
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitGraphicMasterPage(this);
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        List<SemanticException> pageSizeErrors = MasterPageTypeValidator.getInstance().validate(module, this);
        if (pageSizeErrors.isEmpty()) {
            list.addAll(MasterPageMultiColumnValidator.getInstance().validate(module, this));
        }
        return list;
    }

    @Override
    public String getElementName() {
        return "GraphicMasterPage";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }
}

