/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.MarineLitterExportRow;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.csv.ValueFormatter;

public class MarineLitterExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<MarineLitterExportRow> {
    public MarineLitterExportModel(char separator) {
        super(separator);
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("MarineLitterCategory", "marineLitterCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("MarineLitterSizeCategory", "marineLitterSizeCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Number", "number", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Weight", "weight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Commentaire", "comment", TuttiCsvUtil.COMMENT_FORMATTER);
    }

    public void prepareRows(PersistenceService persistenceService, List<MarineLitterExportRow> rows, Cruise cruise, FishingOperation operation) {
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = persistenceService.getRootMarineLitterBatch(operation.getId());
        List children = rootMarineLitterBatch.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (MarineLitterBatch child : children) {
                MarineLitterExportRow row = new MarineLitterExportRow();
                row.setCruise(cruise);
                row.setFishingOperation(operation);
                row.setBatch(child);
                rows.add(row);
            }
        }
    }
}

