/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.config;

import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionConfiguration;

public class PostgresConfigStandard
extends ConnectionConfiguration {
    @Override
    public String getDatabaseShortName() {
        return "postgresql";
    }

    @Override
    public String getConfigurationName() {
        return "standard";
    }

    @Override
    public String getUrl() {
        return "jdbc:postgresql://" + this.getHostname() + "/liquibase";
    }

    @Override
    public Set<String> getPuppetModules() {
        Set<String> modules = super.getPuppetModules();
        modules.add("puppetlabs/postgresql");
        return modules;
    }

    @Override
    public String getPuppetInit(String box) {
        return "class { '::postgresql::server':\n    ip_mask_deny_postgres_user => '0.0.0.0/32',\n    ip_mask_allow_all_users    => '0.0.0.0/0',\n    listen_addresses           => '*',\n    ipv4acls                   => ['host all liquibase 0.0.0.0/0 password'],\n    postgres_password          => 'postgres',\n}\n\npostgresql::server::db { 'liquibase':\n  user     => '" + this.getDatabaseUsername() + "',\n" + "  password => '" + this.getDatabasePassword() + "'\n" + "}\n";
    }
}

