/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesAbleBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecoratorComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortableRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataTableCell;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.validator.NuitonValidatorResult;

public class BenthosBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<BenthosBatchRowModel, BenthosBatchUIModel, BenthosBatchTableModel, BenthosBatchUI> {
    private static final Log log = LogFactory.getLog(BenthosBatchUIHandler.class);
    private EnumMap<TableViewMode, RowFilter<BenthosBatchTableModel, Integer>> tableFilters;
    protected SampleCategoryModel sampleCategoryModel;
    protected WeightUnit weightUnit;
    protected Integer qualitative_unsorted_id;

    public BenthosBatchUIHandler() {
        super("speciesToConfirm", "species", "weight", "number", "sampleCategoryWeight", "comment", "attachment", "frequency");
    }

    @Override
    protected ColumnIdentifier<BenthosBatchRowModel> getCommentIdentifier() {
        return BenthosBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<BenthosBatchRowModel> getAttachementIdentifier() {
        return BenthosBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((TuttiEntity)bean)) {
                BatchContainer rootBenthosBatch = this.getPersistenceService().getRootBenthosBatch(bean.getId(), true);
                List catches = rootBenthosBatch.getChildren();
                Integer firstCategoryId = this.sampleCategoryModel.getFirstCategoryId();
                for (BenthosBatch aBatch : catches) {
                    Preconditions.checkState((boolean)firstCategoryId.equals(aBatch.getSampleCategoryId()), (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryId()));
                    BenthosBatchRowModel rootRow = this.loadBatch(aBatch, null, rows);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded root batch " + this.decorate((Serializable)rootRow.getSpecies(), "fromProtocol") + " - " + this.decorate((Serializable)rootRow.getSampleCategoryById(firstCategoryId))));
                }
            }
            SpeciesBatchDecorator<BenthosBatchRowModel> decorator = this.getSpeciesColumnDecorator();
            SpeciesSortMode speciesSortMode = model.getSpeciesSortMode();
            SpeciesBatchDecoratorComparator<BenthosBatchRowModel> comparator = this.getSpeciesRowComparator();
            SpeciesAbleBatchRowHelper.sortSpeciesRows(comparator, decorator, rows, speciesSortMode);
        }
        model.setRows(rows);
    }

    public BenthosBatchTableModel getTableModel() {
        return (BenthosBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((BenthosBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(BenthosBatchRowModel row) {
        boolean result;
        BenthosBatch batch = this.convertRowToEntity(row, true);
        NuitonValidatorResult validator = this.getValidationService().validateEditBenthosBatch(batch);
        boolean bl = result = !validator.hasErrorMessagess();
        if (result && "validate".equals(this.getContext().getValidationContext()) && row.isBatchLeaf()) {
            List<BenthosBatchFrequency> frequencies = BenthosFrequencyRowModel.toEntity(row.getFrequency(), batch);
            result = this.getValidateCruiseOperationsService().isBenthosBatchValid(batch, frequencies);
        }
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, BenthosBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        BenthosBatchTableModel tableModel = this.getTableModel();
        if ("sampleCategoryWeight".equals(propertyName)) {
            SampleCategory sampleCategory = (SampleCategory)newValue;
            Integer sampleCategoryId = sampleCategory.getCategoryId();
            SampleCategoryAble firstAncestorRow = row.getFirstAncestor(sampleCategory);
            int firstAncestorIndex = tableModel.getRowIndex((Serializable)((Object)firstAncestorRow));
            if (rowIndex != firstAncestorIndex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sample category " + sampleCategoryId + " weight was modified, First ancestor row: " + firstAncestorIndex + " will save it"));
                }
                this.saveRow((BenthosBatchRowModel)firstAncestorRow);
                this.cleanrRowMonitor();
                return;
            }
        } else if ("speciesToConfirm".equals(propertyName)) {
            HashSet shell = Sets.newHashSet();
            row.collectShell(shell);
            boolean newVal = newValue == null ? false : (Boolean)newValue;
            for (BenthosBatchRowModel rowToUpdate : shell) {
                rowToUpdate.setSpeciesToConfirm(newVal);
            }
            tableModel.fireTableRowUpdatedShell(shell);
        }
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<BenthosBatchRowModel> rowMonitor, BenthosBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(row.getSpecies(), row, "Sauvegarde du lot Capture - Benthos : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<BenthosBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setRootNumber(0);
        for (BenthosBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
        this.getTable().clearSelection();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EVEN, HighlightPredicate.EDITABLE}), (Color)Color.WHITE);
        table.addHighlighter(evenHighlighter);
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.EDITABLE, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BenthosBatchRowModel row = (BenthosBatchRowModel)BenthosBatchUIHandler.this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
                return row.isSpeciesToConfirm();
            }
        }}), (Color)toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.READ_ONLY, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BenthosBatchRowModel row = (BenthosBatchRowModel)BenthosBatchUIHandler.this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
                return row.isSpeciesToConfirm();
            }
        }}), (Color)toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableChangeSampleCategory = false;
        boolean enableAddSampleCategory = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        boolean enableEditFrequencies = false;
        if (rowIndex != -1) {
            BenthosBatchTableModel tableModel = this.getTableModel();
            BenthosBatchRowModel row = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            enableSplit = true;
            enableRemove = selectedRowCount == 1;
            enableRemoveSub = selectedRowCount == 1;
            enableRename = selectedRowCount == 1;
            enableEditFrequencies = selectedRowCount == 1;
            enableChangeSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            enableAddSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            boolean bl = enableCreateMelag = selectedRowCount > 1;
            if (enableSplit) {
                Integer lastSamplingId = this.sampleCategoryModel.getLastCategoryId();
                enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && ObjectUtils.notEqual((Object)lastSamplingId, (Object)row.getFinestCategory().getCategoryId()) && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
            boolean firstCategory = false;
            SampleCategoryModelEntry category = null;
            ArrayList available = null;
            if (sampleCategoryId != null) {
                category = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
                firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
                if (category.getCaracteristic().isNumericType()) {
                    available = Collections.emptyList();
                } else {
                    BenthosBatchRowModel firstAncestorRow = row.getFirstAncestor(sampleCategoryId);
                    Set<Serializable> used = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
                    available = Lists.newArrayList((Iterable)category.getCaracteristic().getQualitativeValue());
                    available.removeAll(used);
                    if (firstCategory) {
                        CaracteristicQualitativeValues.removeQualitativeValue((Collection)available, (int)this.qualitative_unsorted_id);
                    }
                }
            }
            if (enableChangeSampleCategory) {
                enableChangeSampleCategory = sampleCategoryId == null ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableAddSampleCategory) {
                enableAddSampleCategory = sampleCategoryId == null || firstCategory ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableEditFrequencies) {
                enableEditFrequencies = row.isBatchLeaf();
            }
            if (enableRename) {
                enableRename = row.isBatchRoot();
            }
            if (enableRemove) {
                // empty if block
            }
            if (enableRemoveSub) {
                enableRemoveSub = !row.isBatchLeaf();
            }
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setSplitBatchEnabled(enableSplit);
        model.setChangeSampleCategoryEnabled(enableChangeSampleCategory);
        model.setAddSampleCategoryEnabled(enableAddSampleCategory);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
        model.setEditFrequenciesEnabled(enableEditFrequencies);
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("actions for (" + rowIndex + "," + columnIndex + "):");
            builder.append("\nenableSplit:                ").append(enableSplit);
            builder.append("\nenableChangeSampleCategory: ").append(enableChangeSampleCategory);
            builder.append("\nenableAddSampleCategory:    ").append(enableAddSampleCategory);
            builder.append("\nenableRemove:               ").append(enableRemove);
            builder.append("\nenableRemoveSub:            ").append(enableRemoveSub);
            builder.append("\nenableRename:               ").append(enableRename);
            builder.append("\nenableCreateMelag:          ").append(enableCreateMelag);
            builder.append("\nenableEditFrequencies:      ").append(enableEditFrequencies);
            log.debug((Object)builder.toString());
        }
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return ((BenthosBatchUI)this.ui).getValidator();
    }

    public void beforeInit(BenthosBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.qualitative_unsorted_id = QualitativeValueId.UNSORTED.getValue();
        this.weightUnit = this.getConfig().getBenthosWeightUnit();
        this.sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        this.tableFilters = new EnumMap(TableViewMode.class);
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    BenthosBatchTableModel model = entry.getModel();
                    BenthosBatchRowModel row = (BenthosBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    BenthosBatchTableModel model = entry.getModel();
                    BenthosBatchRowModel row = (BenthosBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + ui));
        }
        EditCatchesUIModel catchesUIModel = ui.getContextValue(EditCatchesUIModel.class);
        BenthosBatchUIModel model = new BenthosBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
        ui.setContextValue(model);
    }

    public void afterInit(BenthosBatchUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + ui));
        }
        this.initUI(ui);
        List samplingOrder = this.sampleCategoryModel.getSamplingOrder();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Number> numberDecorator = this.getDecorator(Number.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        TableColumnExt speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, BenthosBatchTableModel.SPECIES);
        speciesColumn.setSortable(true);
        SpeciesBatchDecorator speciesDecorator = SpeciesBatchDecorator.newDecorator();
        speciesColumn.putClientProperty((Object)"decorator", speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        for (SampleCategoryModelEntry sampleCategoryDef : this.sampleCategoryModel.getCategory()) {
            SampleCategoryColumnIdentifier<BenthosBatchRowModel> columnIdentifier = SampleCategoryColumnIdentifier.newId("sampleCategory[" + sampleCategoryDef.getOrder() + "]", sampleCategoryDef.getCategoryId(), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]));
            Decorator<Number> decorator = sampleCategoryDef.getCaracteristic().isNumericType() ? numberDecorator : caracteristicDecorator;
            this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, columnIdentifier, decorator, defaultRenderer, this.weightUnit);
        }
        this.addColumnToModel((TableColumnModel)columnModel, ComputableDataTableCell.newEditor(Float.class, this.weightUnit, computedDataColor), ComputableDataTableCell.newRender(defaultRenderer, this.weightUnit, computedDataColor), BenthosBatchTableModel.WEIGHT, this.weightUnit);
        this.addColumnToModel((TableColumnModel)columnModel, BenthosFrequencyCellComponent.newEditor(ui, computedDataColor), BenthosFrequencyCellComponent.newRender(computedDataColor), BenthosBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), BenthosBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), BenthosBatchTableModel.ATTACHMENT);
        BenthosBatchTableModel tableModel = new BenthosBatchTableModel(this.weightUnit, this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
        ((BenthosBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)BenthosBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                BenthosBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
        ((BenthosBatchUIModel)this.getModel()).addPropertyChangeListener("speciesSortMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesSortMode newValue = (SpeciesSortMode)((Object)evt.getNewValue());
                if (log.isInfoEnabled()) {
                    log.info((Object)("New species sort mode: " + (Object)((Object)newValue)));
                }
                BenthosBatchUIHandler.this.selectFishingOperation(((BenthosBatchUIModel)BenthosBatchUIHandler.this.getModel()).getFishingOperation());
            }
        });
        ((BenthosBatchUIModel)this.getModel()).addPropertyChangeListener("speciesDecoratorContextIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newValue = (Integer)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("New species decorator context index: " + newValue));
                }
                BenthosBatchUIHandler.this.getSpeciesColumnDecorator().setContextIndex(newValue);
                BenthosBatchUIHandler.this.selectFishingOperation(((BenthosBatchUIModel)BenthosBatchUIHandler.this.getModel()).getFishingOperation());
            }
        });
    }

    @Override
    protected void initBatchTable(JXTable table, TableColumnModelExt columnModel, BenthosBatchTableModel tableModel) {
        super.initBatchTable(table, columnModel, tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(table);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                BenthosBatchTableModel tableModel = (BenthosBatchTableModel)((Object)e.getSource());
                int type = e.getType();
                if (type == -1 || type == 1 || e.getLastRow() == Integer.MAX_VALUE) {
                    SpeciesBatchDecoratorComparator<BenthosBatchRowModel> comparator = BenthosBatchUIHandler.this.getSpeciesRowComparator();
                    SpeciesBatchDecorator<BenthosBatchRowModel> decorator = BenthosBatchUIHandler.this.getSpeciesColumnDecorator();
                    comparator.init((JXPathDecorator<BenthosBatchRowModel>)decorator, tableModel.getRows());
                }
            }
        });
        SpeciesAbleBatchRowHelper.installSpeciesColumnComparatorPopup(table, speciesColumn, (SpeciesSortableRowModel)this.getModel(), I18n.t((String)"tutti.species.surveyCode.tip", (Object[])new Object[0]), I18n.t((String)"tutti.species.name.tip", (Object[])new Object[0]));
    }

    protected JComponent getComponentToFocus() {
        return ((BenthosBatchUI)this.getUI()).getTable();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((BenthosBatchUI)this.ui).getBenthosBatchAttachmentsButton().onCloseUI();
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        CreateBenthosBatchUI createBatchEditor = parent.getBenthosTabCreateBatch();
        createBatchEditor.getHandler().openUI((BenthosBatchUIModel)this.getModel());
        parent.getHandler().setBenthosSelectedCard("createBatch");
    }

    public void addBatch(CreateBenthosBatchUIModel batchRootRowModel) {
        if (batchRootRowModel.isValid()) {
            BenthosBatchTableModel tableModel = this.getTableModel();
            BenthosBatchRowModel newRow = tableModel.createNewRow();
            Species species = batchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            newRow.setNumber(batchRootRowModel.getBatchCount());
            CaracteristicQualitativeValue sampleCategory = batchRootRowModel.getSampleCategory();
            SampleCategory<?> category = newRow.getFirstSampleCategory();
            category.setCategoryValue((Serializable)sampleCategory);
            category.setCategoryWeight(batchRootRowModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            int insertIndex = SpeciesAbleBatchRowHelper.getIndexToInsert(tableModel.getRows(), newRow, ((BenthosBatchUIModel)this.getModel()).getSpeciesSortMode(), this.getSpeciesColumnDecorator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will insert at index: " + insertIndex));
            }
            tableModel.addNewRow(insertIndex, newRow);
            TuttiUIUtil.doSelectCell((JTable)this.getTable(), (int)insertIndex, (int)0);
            this.addToSpeciesUsed(newRow);
            if (batchRootRowModel.getBatchCount() == null && batchRootRowModel.getSelectedCategory() != null) {
                this.splitBatch(batchRootRowModel.getSelectedCategory(), batchRootRowModel.getRows(), batchRootRowModel.getSampleWeight());
            }
        }
    }

    public void editFrequencies() {
        JXTable table = this.getTable();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        TableColumnModelExt columnModel = (TableColumnModelExt)this.getTable().getColumnModel();
        int columnIndex = columnModel.getColumnIndex(BenthosBatchTableModel.COMPUTED_NUMBER);
        TuttiUIUtil.doSelectCell((JTable)this.getTable(), (int)rowIndex, (int)columnIndex);
        BenthosFrequencyCellComponent.FrequencyCellEditor cellEditor = (BenthosFrequencyCellComponent.FrequencyCellEditor)columnModel.getColumnExt(columnIndex).getCellEditor();
        cellEditor.startEdit();
    }

    public void splitBatch() {
        JXTable table = this.getTable();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        BenthosBatchTableModel tableModel = this.getTableModel();
        BenthosBatchRowModel parentBatch = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editBenthosBatch.split.weightNotNull.message", (Object[])new Object[0]), I18n.t((String)"tutti.editBenthosBatch.split.weightNotNull.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editBenthosBatch.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
            SplitBenthosBatchUI splitBatchEditor = parent.getBenthosTabSplitBatch();
            parent.getHandler().splitBenthosBatch(parentBatch, splitBatchEditor);
        }
    }

    public void addBatchCategory() {
        BenthosBatchTableModel tableModel = this.getTableModel();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)this.getTable());
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        int columnIndex = SwingUtil.getSelectedModelColumn((JTable)this.getTable());
        Preconditions.checkState((columnIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        BenthosBatchRowModel selectedRow = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        BenthosBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        BenthosBatchRowModel parentBatch = firstAncestorRow.getParentBatch();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Open addChangeCategory batch ui for row [" + rowIndex + "] and category " + sampleCategoryId));
        }
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        SplitBenthosBatchUI splitBatchEditor = parent.getBenthosTabAddSampleCategoryBatch();
        parent.getHandler().addSampleCategoryBenthosBatch(parentBatch, splitBatchEditor, sampleCategoryId);
    }

    public void changeBatchCategory() {
        Object selectedItem;
        BenthosBatchTableModel tableModel = this.getTableModel();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)this.getTable());
        int columnIndex = SwingUtil.getSelectedModelColumn((JTable)this.getTable());
        BenthosBatchRowModel selectedRow = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        SampleCategoryModelEntry sampleCategoryEntry = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        Caracteristic caracteristic = sampleCategoryEntry.getCaracteristic();
        BenthosBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        Set<Serializable> usedValues = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
        String categoryDecorated = this.decorate((Serializable)caracteristic, "parameterOnly");
        String dialogTitle = I18n.t((String)"tutti.editBenthosBatch.title.changeSampleCategoryValue", (Object[])new Object[]{categoryDecorated});
        boolean numericType = caracteristic.isNumericType();
        if (numericType) {
            NumberEditor editor = new NumberEditor();
            editor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
            editor.setUseSign(false);
            editor.setShowPopupButton(Boolean.valueOf(false));
            editor.setShowReset(Boolean.valueOf(false));
            int response = JOptionPane.showConfirmDialog((Component)this.getUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? editor.getModel() : null;
            if (usedValues.contains(selectedItem)) {
                JOptionPane.showMessageDialog(this.getTopestUI(), I18n.t((String)"tutti.editBenthosBatch.error.sampleCategoryValue.notAvailable", (Object[])new Object[]{selectedItem, categoryDecorated}));
                selectedItem = null;
            }
        } else {
            ArrayList availableValues = Lists.newArrayList((Iterable)caracteristic.getQualitativeValue());
            boolean firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
            if (firstCategory) {
                CaracteristicQualitativeValues.removeQualitativeValue((Collection)availableValues, (int)this.qualitative_unsorted_id);
            }
            availableValues.removeAll(usedValues);
            JComboBox editor = new JComboBox();
            editor.setRenderer(new DecoratorListCellRenderer(this.getDecorator(CaracteristicQualitativeValue.class, null)));
            SwingUtil.fillComboBox(editor, (Collection)availableValues, availableValues.get(0));
            int response = JOptionPane.showConfirmDialog(this.getTopestUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? (CaracteristicQualitativeValue)editor.getSelectedItem() : null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("New selected category: " + selectedItem));
        }
        if (selectedItem != null) {
            Serializable oldValue = tableModel.updateSampleCategorieValue(firstAncestorRow, columnIndex, (Serializable)selectedItem);
            this.saveRow(firstAncestorRow);
            if (!numericType) {
                EditCatchesUIModel createBatchModel = ((BenthosBatchUI)this.ui).getParentContainer(EditCatchesUI.class).getModel();
                createBatchModel.replaceCaracteristicValue(firstAncestorRow.getSpecies(), (CaracteristicQualitativeValue)oldValue, (CaracteristicQualitativeValue)selectedItem);
            }
        }
    }

    public void splitBatch(SampleCategoryModelEntry sampleCategoryDef, List<SplitBenthosBatchRowModel> rows, Float totalRowWeight) {
        JXTable table = this.getTable();
        int insertRow = SwingUtil.getSelectedModelRow((JTable)table);
        BenthosBatchTableModel tableModel = this.getTableModel();
        BenthosBatchRowModel parentBatch = (BenthosBatchRowModel)tableModel.getEntry(insertRow);
        Float parentWeight = parentBatch.getFinestCategory().getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight((float)parentWeight.floatValue(), (float)totalRowWeight.floatValue());
        ArrayList newBatches = Lists.newArrayList();
        for (SplitBenthosBatchRowModel row : rows) {
            if (!row.isValid()) continue;
            BenthosBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            newBatch.getFinestCategory().setSubSample(subSample);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(++insertRow, newBatch);
        }
        parentBatch.setChildBatch(newBatches);
        this.saveRows(newBatches);
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
    }

    public void addSampleCategoryBatch(BenthosBatchRowModel parentBatch, SampleCategoryModelEntry sampleCategoryDef, List<SplitBenthosBatchRowModel> rows, Float totalRowWeight) {
        BenthosBatchTableModel tableModel = this.getTableModel();
        int insertRow = tableModel.getNextChildRowIndex(parentBatch);
        ArrayList newBatches = Lists.newArrayList();
        for (SplitBenthosBatchRowModel row : rows) {
            if (!row.isEditable() || !row.isValid()) continue;
            BenthosBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(insertRow++, newBatch);
        }
        List<BenthosBatchRowModel> childBatch = parentBatch.getChildBatch();
        childBatch.addAll(newBatches);
        parentBatch.setChildBatch(childBatch);
        int categoryIndex = this.sampleCategoryModel.indexOf(sampleCategoryDef);
        Float parentWeight = parentBatch.getSampleCategoryByIndex(categoryIndex - 1).getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight((float)parentWeight.floatValue(), (float)totalRowWeight.floatValue());
        HashSet shell = Sets.newHashSet();
        parentBatch.collectShell(shell);
        for (BenthosBatchRowModel rowModel : shell) {
            rowModel.getSampleCategoryByIndex(categoryIndex).setSubSample(subSample);
        }
        this.saveRows(newBatches);
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        tableModel.updateShell(shell, SwingUtil.getSelectedModelColumn((JTable)this.getTable()));
    }

    public void updateTotalFromFrequencies(BenthosBatchRowModel row) {
        List<BenthosFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (BenthosFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<BenthosBatchRowModel> rows) {
        for (BenthosBatchRowModel row : rows) {
            this.recomputeRowValidState(row);
            this.saveRow(row);
        }
    }

    public String getFilterBenthosBatchRootButtonText(int rootNumber) {
        return I18n.t((String)"tutti.editBenthosBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    public void collectChildren(BenthosBatchRowModel row, Set<BenthosBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (BenthosBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public BenthosBatchRowModel loadBatch(BenthosBatch aBatch, BenthosBatchRowModel parentRow, List<BenthosBatchRowModel> rows) {
        List speciesList;
        int i;
        String id = aBatch.getId();
        List frequencies = this.getPersistenceService().getAllBenthosBatchFrequency(id);
        BenthosBatchRowModel newRow = new BenthosBatchRowModel(this.weightUnit, this.sampleCategoryModel, aBatch, frequencies);
        List attachments = this.getPersistenceService().getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        if (parentRow == null && this.getContext().isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentBenthosWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        Preconditions.checkNotNull((Object)sampleCategoryId, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryId, aBatch.getSampleCategoryValue(), this.weightUnit.fromEntity(aBatch.getSampleCategoryWeight()), this.weightUnit.fromEntity(aBatch.getSampleCategoryComputedWeight()));
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            Float childrenWeights = Float.valueOf(0.0f);
            for (BenthosBatch childBatch : aBatch.getChildBatchs()) {
                BenthosBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                if (childrenWeights != null) {
                    Float weight = childRow.getFinestCategory().getNotNullWeight();
                    childrenWeights = weight == null ? null : Float.valueOf(childrenWeights.floatValue() + weight.floatValue());
                }
                batchChilds.add(childRow);
            }
            Float rowWeight = newRow.getFinestCategory().getNotNullWeight();
            boolean subSample = rowWeight != null && childrenWeights != null && Weights.isSmallerWeight((float)childrenWeights.floatValue(), (float)rowWeight.floatValue());
            for (BenthosBatchRowModel childRow : batchChilds) {
                childRow.getFinestCategory().setSubSample(subSample);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    public void removeFromSpeciesUsed(BenthosBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        Preconditions.checkNotNull(firstSampleCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove from speciesUsed: " + this.decorate((Serializable)categoryValue) + " - " + this.decorate((Serializable)row.getSpecies())));
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)categoryValue, (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
        }
    }

    protected void saveRow(BenthosBatchRowModel row) {
        FishingOperation fishingOperation = ((BenthosBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getFinestCategory());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryId());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryValue());
        BenthosBatch entityToSave = row.toEntity();
        entityToSave.setFishingOperation(fishingOperation);
        BenthosBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            entityToSave.setParentBatch((BenthosBatch)parent.toBean());
        }
        if (TuttiEntities.isNew((TuttiEntity)entityToSave)) {
            BenthosBatchRowModel batchParent = row.getParentBatch();
            String parentBatchId = null;
            if (batchParent != null) {
                parentBatchId = batchParent.getId();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            entityToSave = this.getPersistenceService().createBenthosBatch(entityToSave, parentBatchId);
            row.setId(entityToSave.getId());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist existing species batch: " + entityToSave.getId() + " (parent : " + entityToSave.getParentBatch() + ")"));
            }
            this.getPersistenceService().saveBenthosBatch(entityToSave);
        }
        List<BenthosFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = BenthosFrequencyRowModel.toEntity(frequencyRows, entityToSave);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.getPersistenceService().saveBenthosBatchFrequency(entityToSave.getId(), frequency);
        frequencyRows = BenthosFrequencyRowModel.fromEntity(this.weightUnit, frequency);
        row.setFrequency(frequencyRows);
        ((BenthosBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }

    protected void loadBatchRow(BenthosBatchRowModel parentRow, BenthosBatchRowModel newRow, Integer sampleCategoryId, Serializable categoryValue, Float categoryWeight, Float categoryComputedWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategoryById(sampleCategoryId);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        sampleCategory.setComputedWeight(categoryComputedWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            newRow.setSpeciesToConfirm(parentRow.isSpeciesToConfirm());
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            for (Integer id : this.sampleCategoryModel.getSamplingOrder()) {
                if (id.equals(sampleCategoryId)) continue;
                newRow.setSampleCategory(parentRow.getSampleCategoryById(id));
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<BenthosBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer, WeightUnit weightUnit) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator, weightUnit), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights(), weightUnit), columnIdentifier, weightUnit);
    }

    protected void addToSpeciesUsed(BenthosBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        Preconditions.checkNotNull(firstSampleCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate((Serializable)categoryValue) + " - " + this.decorate((Serializable)row.getSpecies())));
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)categoryValue, (Object)row.getSpecies());
        model.setRootNumber(model.getRootNumber() + 1);
    }

    protected BenthosBatch convertRowToEntity(BenthosBatchRowModel row, boolean convertParent) {
        SampleCategory sampleCategory = row.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryValue());
        BenthosBatch catchBean = (BenthosBatch)row.toBean();
        Float weight = catchBean.getWeight();
        catchBean.setWeight(this.weightUnit.toEntity(weight));
        catchBean.setSampleCategoryId(sampleCategory.getCategoryId());
        catchBean.setSampleCategoryValue(sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        catchBean.setSampleCategoryWeight(this.weightUnit.toEntity(categoryWeight));
        if (convertParent && row.getParentBatch() != null) {
            BenthosBatch parent = this.convertRowToEntity(row.getParentBatch(), true);
            catchBean.setParentBatch(parent);
        }
        return catchBean;
    }

    protected Set<Serializable> getSampleUsedValues(BenthosBatchRowModel row, int sampleCategoryId) {
        List<Object> childs;
        HashSet usedValues = Sets.newHashSet();
        if (row.isBatchRoot()) {
            Species species = row.getSpecies();
            childs = Lists.newArrayList();
            for (BenthosBatchRowModel rowToScan : ((BenthosBatchUIModel)this.getModel()).getRows()) {
                if (!rowToScan.isBatchRoot() || !species.equals(rowToScan.getSpecies())) continue;
                childs.add(rowToScan);
            }
        } else {
            BenthosBatchRowModel parentBatch = row.getParentBatch();
            childs = parentBatch.getChildBatch();
        }
        for (BenthosBatchRowModel benthosBatchRowModel : childs) {
            SampleCategory<?> category = benthosBatchRowModel.getSampleCategoryById(sampleCategoryId);
            usedValues.add(category.getCategoryValue());
        }
        return usedValues;
    }

    protected SpeciesBatchDecoratorComparator<BenthosBatchRowModel> getSpeciesRowComparator() {
        boolean comparatorNull;
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(this.getTable());
        SpeciesBatchDecoratorComparator comparator = (SpeciesBatchDecoratorComparator)((Object)speciesColumn.getComparator());
        SpeciesBatchDecorator<BenthosBatchRowModel> decorator = this.getSpeciesColumnDecorator();
        boolean bl = comparatorNull = comparator == null;
        if (comparatorNull) {
            comparator = (SpeciesBatchDecoratorComparator)decorator.getCurrentComparator();
        }
        if (comparatorNull) {
            speciesColumn.setComparator((Comparator)((Object)comparator));
        }
        return comparator;
    }

    protected SpeciesBatchDecorator<BenthosBatchRowModel> getSpeciesColumnDecorator() {
        TableColumnExt speciesColumn = SpeciesAbleBatchRowHelper.getSpeciesColumn(this.getTable());
        SpeciesBatchDecorator decorator = (SpeciesBatchDecorator)SpeciesAbleBatchRowHelper.getSpeciesColumnDecorator(speciesColumn);
        return decorator;
    }
}

